/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.subclass;

import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.PCClass;
import pcgen.core.SpellProhibitor;
import pcgen.core.SubClass;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;
import pcgen.util.enumeration.ProhibitedSpellType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceToken
extends AbstractToken
implements CDOMPrimaryToken<SubClass> {
    public String getTokenName() {
        return "CHOICE";
    }

    public boolean parse(LoadContext loadContext, SubClass subClass, String string) {
        SpellProhibitor spellProhibitor = this.subParse(loadContext, subClass, string);
        if (spellProhibitor == null) {
            return false;
        }
        loadContext.getObjectContext().put((CDOMObject)subClass, ObjectKey.CHOICE, (Object)spellProhibitor);
        return true;
    }

    public SpellProhibitor subParse(LoadContext loadContext, SubClass subClass, String string) {
        ProhibitedSpellType prohibitedSpellType;
        if (this.isEmpty(string) || this.hasIllegalSeparator('|', string)) {
            return null;
        }
        int n = string.indexOf(124);
        if (n == -1) {
            Logging.errorPrint((String)(this.getTokenName() + " has no | separator for arguments: " + string));
            return null;
        }
        if (string.lastIndexOf(124) != n) {
            Logging.errorPrint((String)(this.getTokenName() + " has more than two | separated arguments: " + string));
            return null;
        }
        String string2 = string.substring(0, n);
        try {
            prohibitedSpellType = ProhibitedSpellType.valueOf((String)string2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Logging.errorPrint((String)(this.getTokenName() + " encountered an invalid Prohibited Spell Type: " + string));
            Logging.errorPrint((String)("  Legal values are: " + StringUtil.join(Arrays.asList(ProhibitedSpellType.values()), (String)", ")));
            return null;
        }
        if (prohibitedSpellType.equals((Object)ProhibitedSpellType.SCHOOL) || prohibitedSpellType.equals((Object)ProhibitedSpellType.SUBSCHOOL) || prohibitedSpellType.equals((Object)ProhibitedSpellType.DESCRIPTOR)) {
            SpellProhibitor spellProhibitor = this.typeSafeParse(loadContext, (PCClass)subClass, prohibitedSpellType, string.substring(n + 1));
            if (spellProhibitor == null) {
                Logging.errorPrint((String)("  entire token value was: " + string));
                return null;
            }
            return spellProhibitor;
        }
        Logging.errorPrint((String)("Invalid TYPE in " + this.getTokenName() + ": " + string2));
        return null;
    }

    private SpellProhibitor typeSafeParse(LoadContext loadContext, PCClass pCClass, ProhibitedSpellType prohibitedSpellType, String string) {
        SpellProhibitor spellProhibitor = new SpellProhibitor();
        spellProhibitor.setType(prohibitedSpellType);
        if (string.length() == 0) {
            Logging.errorPrint((String)(this.getTokenName() + " " + prohibitedSpellType + " has no arguments"));
            return null;
        }
        spellProhibitor.addValue(string);
        return spellProhibitor;
    }

    public String[] unparse(LoadContext loadContext, SubClass subClass) {
        SpellProhibitor spellProhibitor = (SpellProhibitor)loadContext.getObjectContext().getObject((CDOMObject)subClass, ObjectKey.CHOICE);
        if (spellProhibitor == null) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        ProhibitedSpellType prohibitedSpellType = spellProhibitor.getType();
        stringBuilder.append(prohibitedSpellType.toString().toUpperCase());
        stringBuilder.append('|');
        List list = spellProhibitor.getValueList();
        stringBuilder.append(StringUtil.join(new TreeSet(list), (String)"|"));
        return new String[]{stringBuilder.toString()};
    }

    public Class<SubClass> getTokenClass() {
        return SubClass.class;
    }
}

