/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import com.vladium.util.IConstants;
import com.vladium.util.IJREVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.StringTokenizer;

public abstract class Files {
    private static final int CREATE_TEMP_FILE_RETRIES = 20;
    private static final Object CREATE_TEMP_FILE_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] readFileList(File atfile) throws IOException {
        LinkedList<String> _result;
        block8: {
            if (atfile == null) {
                throw new IllegalArgumentException("null input: atfile");
            }
            _result = null;
            BufferedReader in = null;
            try {
                String line;
                in = new BufferedReader(new FileReader(atfile), 8192);
                _result = new LinkedList<String>();
                while ((line = in.readLine()) != null) {
                    if ((line = line.trim()).length() == 0 || line.charAt(0) == '#') continue;
                    _result.add(line);
                }
                Object var5_4 = null;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (in == null) throw throwable;
                try {
                    in.close();
                    throw throwable;
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception ignore) {}
            in.close();
        }
        if (_result == null) return IConstants.EMPTY_STRING_ARRAY;
        if (_result.isEmpty()) {
            return IConstants.EMPTY_STRING_ARRAY;
        }
        String[] result = new String[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static File[] pathToFiles(String[] path, boolean canonical) {
        if (path == null) {
            throw new IllegalArgumentException("null input: path");
        }
        if (path.length == 0) {
            return IConstants.EMPTY_FILE_ARRAY;
        }
        ArrayList<File> _result = new ArrayList<File>(path.length);
        HashSet<String> pathnames = new HashSet<String>(path.length);
        String separators = ",".concat(File.pathSeparator);
        for (int i = 0; i < path.length; ++i) {
            String segment = path[i];
            if (segment == null) {
                throw new IllegalArgumentException("null input: path[" + i + "]");
            }
            StringTokenizer tokenizer = new StringTokenizer(segment, separators);
            while (tokenizer.hasMoreTokens()) {
                String pathname = tokenizer.nextToken();
                if (canonical) {
                    pathname = Files.canonicalizePathname(pathname);
                }
                if (!pathnames.add(pathname)) continue;
                _result.add(new File(pathname));
            }
        }
        File[] result = new File[_result.size()];
        _result.toArray(result);
        return result;
    }

    public static String canonicalizePathname(String pathname) {
        if (pathname == null) {
            throw new IllegalArgumentException("null input: pathname");
        }
        try {
            return new File(pathname).getCanonicalPath();
        }
        catch (Exception e) {
            return new File(pathname).getAbsolutePath();
        }
    }

    public static File canonicalizeFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        try {
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            return file.getAbsoluteFile();
        }
    }

    public static String getFileName(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return name;
        }
        return name.substring(0, lastDot);
    }

    public static String getFileExtension(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        String name = file.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return name.substring(lastDot);
    }

    public static File newFile(File dir, File file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        if (dir == null || file.isAbsolute()) {
            return file;
        }
        return new File(dir, file.getPath());
    }

    public static File newFile(File dir, String file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File fileFile = new File(file);
        if (dir == null || fileFile.isAbsolute()) {
            return fileFile;
        }
        return new File(dir, file);
    }

    public static File newFile(String dir, String file) {
        if (file == null) {
            throw new IllegalArgumentException("null input: file");
        }
        File fileFile = new File(file);
        if (dir == null || fileFile.isAbsolute()) {
            return fileFile;
        }
        return new File(dir, file);
    }

    public static boolean renameFile(File source, File target, boolean overwrite) {
        if (source == null || !source.exists()) {
            throw new IllegalArgumentException("invalid input source: [" + source + "]");
        }
        if (target == null) {
            throw new IllegalArgumentException("null input: target");
        }
        boolean targetExists = target.exists();
        if (!targetExists || overwrite) {
            if (targetExists) {
                target.delete();
            } else {
                File targetDir = target.getParentFile();
                if (targetDir != null && !targetDir.equals(source.getParentFile())) {
                    targetDir.mkdirs();
                }
            }
            return source.renameTo(target);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File createTempFile(File parentDir, String prefix, String extension) throws IOException {
        if (parentDir == null) throw new IllegalArgumentException("invalid parent directory: [" + parentDir + "]");
        if (!parentDir.exists()) {
            throw new IllegalArgumentException("invalid parent directory: [" + parentDir + "]");
        }
        if (prefix == null) throw new IllegalArgumentException("null or less than 2 chars long: " + prefix);
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("null or less than 2 chars long: " + prefix);
        }
        if (extension == null) {
            extension = ".tmp";
        } else if (extension.charAt(0) != '.') {
            extension = ".".concat(extension);
        }
        if (IJREVersion.JRE_1_3_PLUS) {
            return File.createTempFile(prefix, extension, parentDir);
        }
        patternChars = new char[12];
        for (c = 0; c < 3; ++c) {
            patternChars[c] = prefix.charAt(c);
        }
        for (c = 8; c < 12; ++c) {
            patternChars[c] = extension.charAt(c - 8);
        }
        random = new Random();
        var5_6 = Files.CREATE_TEMP_FILE_LOCK;
        synchronized (var5_6) {
            retry = 0;
            while (retry < 20) {
                block22: {
                    block23: {
                        segment = random.nextInt();
                        for (d = 0; d < 5; ++d) {
                            patternChars[d + 3] = Character.forDigit(segment >>> (d << 2) & 15, 16);
                        }
                        candidate = Files.newFile(parentDir, new File(new String(patternChars)));
                        if (candidate.exists()) break block22;
                        raf = null;
                        try {
                            try {
                                raf = new RandomAccessFile(candidate, "rw");
                                var10_13 = candidate;
                                var12_14 = null;
                                if (raf == null) return var10_13;
                            }
                            catch (FileNotFoundException fnfe) {
                                var12_14 = null;
                                if (raf == null) break block22;
                                try {
                                    raf.close();
                                }
                                catch (Exception ignore) {}
                                break block22;
                            }
                        }
                        catch (Throwable var11_16) {
                            var12_14 = null;
                            if (raf == null) throw var11_16;
                            ** try [egrp 3[TRYBLOCK] [4 : 332->340)] { 
lbl55:
                            // 1 sources

                            raf.close();
                            throw var11_16;
lbl57:
                            // 1 sources

                            catch (Exception ignore) {
                                // empty catch block
                            }
                            throw var11_16;
                        }
                        ** try [egrp 3[TRYBLOCK] [4 : 332->340)] { 
lbl62:
                        // 1 sources

                        raf.close();
                        break block23;
lbl64:
                        // 1 sources

                        catch (Exception ignore) {
                            // empty catch block
                        }
                    }
                    return var10_13;
                }
                ++retry;
            }
            throw new IOException("could not create temp file in [" + parentDir.getAbsolutePath() + "] after " + 20 + " retries");
        }
    }

    private Files() {
    }
}

