/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.util;

import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public interface IProperties {
    public String getProperty(String var1);

    public String getProperty(String var1, String var2);

    public Iterator properties();

    public boolean isEmpty();

    public void list(PrintWriter var1);

    public String setProperty(String var1, String var2);

    public static abstract class Factory {
        public static IProperties create(IMapper mapper) {
            return new PropertiesImpl(null, mapper);
        }

        public static IProperties wrap(Properties properties, IMapper mapper) {
            HashMap<String, String> map = new HashMap<String, String>();
            Enumeration<?> names = properties.propertyNames();
            while (names.hasMoreElements()) {
                String n = (String)names.nextElement();
                String v = properties.getProperty(n);
                map.put(n, v);
            }
            return new PropertiesImpl(map, mapper);
        }

        public static IProperties combine(IProperties overrides, IProperties base) {
            if (overrides == null) {
                if (base == null) {
                    return Factory.create(null);
                }
                return base;
            }
            if (base == null) {
                return overrides;
            }
            ((PropertiesImpl)overrides).getLastProperties().setDelegate((PropertiesImpl)base);
            return overrides;
        }

        private static final class PropertiesImpl
        implements IProperties {
            private final IMapper m_mapper;
            private final Map m_valueMap;
            private PropertiesImpl m_delegate;
            private transient Set m_unmappedKeySet;

            public String getProperty(String key) {
                return this.getProperty(key, null);
            }

            public String getProperty(String key, String dflt) {
                String mappedKey;
                String value = (String)this.m_valueMap.get(key);
                if (value == null && this.m_mapper != null && (mappedKey = this.m_mapper.getMappedKey(key)) != null) {
                    value = (String)this.m_valueMap.get(mappedKey);
                }
                if (value == null && this.m_delegate != null) {
                    value = this.m_delegate.getProperty(key, null);
                }
                return value != null ? value : dflt;
            }

            public Iterator properties() {
                return this.unmappedKeySet().iterator();
            }

            public boolean isEmpty() {
                return this.m_valueMap.isEmpty() && (this.m_delegate == null || this.m_delegate != null && this.m_delegate.isEmpty());
            }

            public void list(PrintWriter out) {
                if (out != null) {
                    Iterator i = this.properties();
                    while (i.hasNext()) {
                        String n = (String)i.next();
                        String v = this.getProperty(n);
                        out.println(n + ":\t[" + v + "]");
                    }
                }
            }

            public String setProperty(String key, String value) {
                if (value == null) {
                    throw new IllegalArgumentException("null input: value");
                }
                this.m_unmappedKeySet = null;
                return this.m_valueMap.put(key, value);
            }

            PropertiesImpl(Map values, IMapper mapper) {
                this.m_mapper = mapper;
                this.m_valueMap = values != null ? values : new HashMap();
                this.m_delegate = null;
            }

            Set unmappedKeySet() {
                TreeSet result = this.m_unmappedKeySet;
                if (result == null) {
                    result = new TreeSet();
                    result.addAll(this.m_valueMap.keySet());
                    if (this.m_delegate != null) {
                        result.addAll(this.m_delegate.unmappedKeySet());
                    }
                    this.m_unmappedKeySet = result;
                    return result;
                }
                return result;
            }

            PropertiesImpl getLastProperties() {
                PropertiesImpl result = this;
                PropertiesImpl delegate = this.m_delegate;
                while (delegate != null) {
                    if (delegate == this) {
                        throw new IllegalStateException("cyclic delegation detected");
                    }
                    result = delegate;
                    delegate = delegate.m_delegate;
                }
                return result;
            }

            void setDelegate(PropertiesImpl delegate) {
                this.m_delegate = delegate;
                this.m_unmappedKeySet = null;
            }
        }
    }

    public static interface IMapper {
        public String getMappedKey(String var1);
    }
}

