/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.kit.ability;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import java.util.logging.Level;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.Category;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.AbilityUtilities;
import pcgen.core.kit.KitAbilities;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.TokenUtilities;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMSecondaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbilityToken
extends AbstractToken
implements CDOMSecondaryToken<KitAbilities> {
    private static final Class<Ability> ABILITY_CLASS = Ability.class;

    public String getTokenName() {
        return "ABILITY";
    }

    public Class<KitAbilities> getTokenClass() {
        return KitAbilities.class;
    }

    public String getParentToken() {
        return "*KITTOKEN";
    }

    public boolean parse(LoadContext loadContext, KitAbilities kitAbilities, String string) {
        if (this.isEmpty(string)) {
            return false;
        }
        int n = string.indexOf("|");
        if (n == -1) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"No pipe found.  ABILITY token in a Kit requires CATEGORY=<cat>|<ability>,<ability>");
            return false;
        }
        String string2 = string.substring(0, n);
        if (!string2.startsWith("CATEGORY=")) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"No CATEGORY= found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>");
            return false;
        }
        if (string2.length() < 10) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"No category found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>");
            return false;
        }
        Category category = loadContext.ref.getCategoryFor(ABILITY_CLASS, string2.substring(9));
        kitAbilities.setCategory((AbilityCategory)category);
        String string3 = string.substring(n + 1);
        if (this.isEmpty(string3) || this.hasIllegalSeparator('|', string3)) {
            Logging.addParseMessage((Level)Logging.LST_ERROR, (String)"No abilities found.  ABILITY token in a Kit requires CATEGORY=<cat>|<abilities>");
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "|");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.startsWith("CATEGORY=")) {
                Logging.errorPrint((String)("Attempting to change the Category to '" + string4 + "': " + string));
                return false;
            }
            CDOMReference cDOMReference = TokenUtilities.getTypeOrPrimitive((LoadContext)loadContext, ABILITY_CLASS, (Category)category, (String)string4);
            if (cDOMReference == null) {
                return false;
            }
            ArrayList arrayList = null;
            if (string4.indexOf(40) != -1) {
                arrayList = new ArrayList();
                AbilityUtilities.getUndecoratedName((String)string4, arrayList);
            }
            kitAbilities.addAbility(cDOMReference, arrayList);
        }
        return true;
    }

    public String[] unparse(LoadContext loadContext, KitAbilities kitAbilities) {
        Collection collection = kitAbilities.getAbilityKeys();
        if (collection == null || collection.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("CATEGORY=");
        stringBuilder.append(kitAbilities.getCategory().getKeyName());
        for (CDOMReference cDOMReference : collection) {
            stringBuilder.append("|");
            stringBuilder.append(cDOMReference.getLSTformat());
        }
        return new String[]{stringBuilder.toString()};
    }
}

