/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens.pcclass;

import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeSet;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCClass;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.Prerequisite;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.AbstractToken;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonskillToken
extends AbstractToken
implements CDOMPrimaryToken<PCClass> {
    public String getTokenName() {
        return "MONSKILL";
    }

    public boolean parse(LoadContext loadContext, PCClass pCClass, String string) throws PersistenceLayerException {
        if (this.isEmpty(string)) {
            return false;
        }
        BonusObj bonusObj = Bonus.newBonus((String)("0|MONSKILLPTS|NUMBER|" + string));
        if (bonusObj == null) {
            Logging.errorPrint((String)(this.getTokenName() + " was given invalid bonus value: " + string));
            return false;
        }
        Prerequisite prerequisite = this.getPrerequisite("PRELEVELMAX:1");
        if (prerequisite == null) {
            Logging.errorPrint((String)("Internal Error: " + this.getTokenName() + " had invalid prerequisite"));
            return false;
        }
        bonusObj.addPrerequisite(prerequisite);
        bonusObj.setCreatorObject((Object)pCClass);
        bonusObj.setTokenSource(this.getTokenName());
        loadContext.obj.addToList((CDOMObject)pCClass, ListKey.BONUS, (Object)bonusObj);
        return true;
    }

    public String[] unparse(LoadContext loadContext, PCClass pCClass) {
        Changes changes = loadContext.obj.getListChanges((CDOMObject)pCClass, ListKey.BONUS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        Collection collection = changes.getAdded();
        String string = this.getTokenName();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (BonusObj bonusObj : collection) {
            if (!string.equals(bonusObj.getTokenSource())) continue;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(bonusObj.getValue());
            ArrayList arrayList = new ArrayList(bonusObj.getPrerequisiteList());
            Prerequisite prerequisite = this.getPrerequisite("PRELEVELMAX:1");
            arrayList.remove(prerequisite);
            if (!arrayList.isEmpty()) {
                stringBuilder.append('|');
                stringBuilder.append(this.getPrerequisiteString(loadContext, arrayList));
            }
            treeSet.add(stringBuilder.toString());
        }
        if (treeSet.isEmpty()) {
            return null;
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<PCClass> getTokenClass() {
        return PCClass.class;
    }
}

