/*
 * Decompiled with CFR 0.152.
 */
package plugin.lsttokens;

import java.util.TreeSet;
import java.util.logging.Level;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.helper.FollowerLimit;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.persistence.PersistenceLayerException;
import pcgen.rules.context.Changes;
import pcgen.rules.context.LoadContext;
import pcgen.rules.persistence.token.CDOMPrimaryToken;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FollowersLst
implements CDOMPrimaryToken<CDOMObject> {
    public String getTokenName() {
        return "FOLLOWERS";
    }

    public boolean parse(LoadContext loadContext, CDOMObject cDOMObject, String string) throws PersistenceLayerException {
        int n = string.indexOf("|");
        if (n == -1) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " has no PIPE character: Must be of the form <follower type>|<formula>"));
            return false;
        }
        if (n != string.lastIndexOf("|")) {
            Logging.log((Level)Logging.LST_ERROR, (String)(this.getTokenName() + " has too many PIPE characters: " + "Must be of the form <follower type>|<formula"));
            return false;
        }
        String string2 = string.substring(0, n);
        if (string2.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Follower Type in " + this.getTokenName() + " cannot be empty"));
            return false;
        }
        String string3 = string.substring(n + 1);
        if (string3.length() == 0) {
            Logging.log((Level)Logging.LST_ERROR, (String)("Follower Count in " + this.getTokenName() + " cannot be empty"));
            return false;
        }
        CDOMSingleRef cDOMSingleRef = loadContext.ref.getCDOMReference(CompanionList.class, string2);
        Formula formula = FormulaFactory.getFormulaFor((String)string3);
        loadContext.getObjectContext().addToList(cDOMObject, ListKey.FOLLOWERS, (Object)new FollowerLimit(cDOMSingleRef, formula));
        return true;
    }

    public String[] unparse(LoadContext loadContext, CDOMObject cDOMObject) {
        Changes changes = loadContext.getObjectContext().getListChanges(cDOMObject, ListKey.FOLLOWERS);
        if (changes == null || changes.isEmpty()) {
            return null;
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (FollowerLimit followerLimit : changes.getAdded()) {
            String string = followerLimit.getCompanionList().getLSTformat();
            Formula formula = followerLimit.getValue();
            treeSet.add(string + "|" + formula.toString());
        }
        return treeSet.toArray(new String[treeSet.size()]);
    }

    public Class<CDOMObject> getTokenClass() {
        return CDOMObject.class;
    }
}

