/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import gmgen.GMGenSystem;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import javax.swing.JOptionPane;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import pcgen.core.RollingMethods;
import pcgen.util.Logging;

public class DiceBagModel
extends Observable {
    private List<String> m_dice = new ArrayList<String>();
    private String m_filePath;
    private String m_name = "";
    private boolean m_changed = false;

    public DiceBagModel() {
    }

    public DiceBagModel(String string) {
        this();
        this.m_name = string;
    }

    public DiceBagModel(File file) {
        this();
        this.loadFromFile(file);
    }

    public boolean isBagEmpty() {
        return this.m_dice.isEmpty();
    }

    public boolean isChanged() {
        return this.m_changed;
    }

    public String setDie(int n, String string) {
        this.m_changed = true;
        return this.m_dice.set(n, string);
    }

    public String getDie(int n) {
        return this.m_dice.get(n);
    }

    public String getFilePath() {
        return this.m_filePath;
    }

    public void setName(String string) {
        this.m_changed = true;
        this.m_name = string;
    }

    public String getName() {
        return this.m_name;
    }

    public void addDie(int n, String string) {
        this.m_dice.add(n, string);
        this.m_changed = true;
    }

    public boolean addDie(String string) {
        this.m_changed = true;
        return this.m_dice.add(string);
    }

    public void clearDice() {
        this.m_changed = true;
        this.m_dice.clear();
    }

    public int diceCount() {
        return this.m_dice.size();
    }

    public String removeDie(int n) {
        this.m_changed = true;
        return this.m_dice.remove(n);
    }

    public double rollDie(int n) {
        double d = 0.0;
        if (n < this.m_dice.size()) {
            d = RollingMethods.roll((String)this.m_dice.get(n));
        }
        return d;
    }

    public double rollDie(String string) {
        double d = RollingMethods.roll((String)string);
        return d;
    }

    public void saveToFile(File file) {
        try {
            Document document = new Document();
            this.saveToDocument(document);
            XMLOutputter xMLOutputter = new XMLOutputter();
            xMLOutputter.setIndent("   ");
            xMLOutputter.setNewlines(true);
            FileWriter fileWriter = new FileWriter(file);
            xMLOutputter.setEncoding("UTF-8");
            xMLOutputter.output(document, (Writer)fileWriter);
            fileWriter.flush();
            fileWriter.close();
            this.m_filePath = file.getPath();
            this.m_changed = false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "File load error: " + file.getName());
            Logging.errorPrint((String)("File Load Error" + file.getName()));
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void loadFromDocument(Document document) {
        this.m_dice.clear();
        Element element = document.getRootElement();
        if (element.getName().equals("dice-bag")) {
            this.m_name = element.getAttributeValue("name");
            List list = element.getChildren("dice-roll");
            for (Element element2 : list) {
                this.m_dice.add(element2.getTextNormalize());
            }
        }
    }

    private void loadFromFile(File file) {
        try {
            SAXBuilder sAXBuilder = new SAXBuilder();
            Document document = sAXBuilder.build(file);
            this.m_filePath = file.getPath();
            this.loadFromDocument(document);
            this.m_changed = false;
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog((Component)GMGenSystem.inst, "File load error: " + file.getName());
            Logging.errorPrint((String)("File Load Error" + file.getName()));
            Logging.errorPrint((String)exception.getMessage(), (Throwable)exception);
        }
    }

    private void saveToDocument(Document document) {
        Element element = new Element("dice-bag");
        element.setAttribute("name", this.m_name);
        for (String string : this.m_dice) {
            Element element2 = new Element("dice-roll");
            element2.addContent(string);
            element.addContent(element2);
        }
        document.setRootElement(element);
    }
}

