/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import plugin.dicebag.gui.DiceBagMessage;
import plugin.dicebag.gui.DiceBagModel;

public class DiceBagPluginModel
extends Observable {
    private DiceBagModel m_activeBag;
    private List<DiceBagModel> m_diceBags = new ArrayList<DiceBagModel>();

    public void setActiveBag(DiceBagModel diceBagModel) {
        this.m_activeBag = diceBagModel;
    }

    public DiceBagModel getActiveBag() {
        return this.m_activeBag;
    }

    public void addNewDicebag() {
        DiceBagModel diceBagModel = new DiceBagModel();
        this.m_diceBags.add(diceBagModel);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(2, diceBagModel));
    }

    public void closeDiceBag(DiceBagModel diceBagModel) {
        this.m_diceBags.remove(diceBagModel);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(4, diceBagModel));
    }

    public boolean loadDiceBag(File file) {
        boolean bl = false;
        DiceBagModel diceBagModel = new DiceBagModel(file);
        bl = this.m_diceBags.add(diceBagModel);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(2, diceBagModel));
        return bl;
    }

    public void saveDiceBag(DiceBagModel diceBagModel, File file) {
        diceBagModel.saveToFile(file);
        this.setChanged();
        this.notifyObservers(new DiceBagMessage(64, diceBagModel));
    }

    public void saveDiceBag(DiceBagModel diceBagModel) {
        this.saveDiceBag(diceBagModel, new File(diceBagModel.getFilePath()));
    }
}

