/*
 * Decompiled with CFR 0.152.
 */
package plugin.dicebag.gui;

import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JDesktopPane;
import javax.swing.JOptionPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import pcgen.core.SettingsHandler;
import plugin.dicebag.gui.DiceBagMessage;
import plugin.dicebag.gui.DiceBagModel;
import plugin.dicebag.gui.DiceBagPluginController;
import plugin.dicebag.gui.DiceBagPluginModel;
import plugin.dicebag.gui.DiceBagView;

public class DiceBagPluginView
implements Observer {
    private DiceBagPluginModel m_model;
    private InternalFrameAdapter listener = new ChildListener();
    private JDesktopPane theDesktop = null;
    private int newX = 0;
    private int newY = 0;

    public DiceBagPluginView(DiceBagPluginModel diceBagPluginModel) {
        diceBagPluginModel.addObserver(this);
        this.m_model = diceBagPluginModel;
        this.initComponents();
    }

    public Component getMainComponent() {
        return this.theDesktop;
    }

    public void closeAll() {
        Component[] componentArray = this.theDesktop.getComponents();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof DiceBagView)) continue;
            DiceBagModel diceBagModel = ((DiceBagView)componentArray[i]).getBag();
            this.askSaveBag(diceBagModel, 0);
            if (diceBagModel.isChanged() || diceBagModel.isBagEmpty()) continue;
            stringBuffer.append(diceBagModel.getFilePath() + "|");
        }
        SettingsHandler.setGMGenOption((String)"DiceBagcloseFiles", (String)stringBuffer.toString());
    }

    public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
        if (internalFrameEvent.getInternalFrame() != null && internalFrameEvent.getInternalFrame() instanceof DiceBagView) {
            this.m_model.setActiveBag(((DiceBagView)internalFrameEvent.getInternalFrame()).getBag());
        }
    }

    public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
        if (internalFrameEvent.getInternalFrame() != null && internalFrameEvent.getInternalFrame() instanceof DiceBagView) {
            this.m_model.closeDiceBag(((DiceBagView)internalFrameEvent.getInternalFrame()).getBag());
        }
    }

    public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
        if (internalFrameEvent.getInternalFrame() != null && internalFrameEvent.getInternalFrame() instanceof DiceBagView) {
            int n = this.askSaveBag(((DiceBagView)internalFrameEvent.getInternalFrame()).getBag(), 1);
            if (n == 2) {
                internalFrameEvent.getInternalFrame().setDefaultCloseOperation(0);
            } else if (n == 1 && n == 0) {
                internalFrameEvent.getInternalFrame().setDefaultCloseOperation(1);
            }
        }
    }

    public void update(Observable observable, Object object) {
        if (observable != null && observable instanceof DiceBagPluginModel && object != null && object instanceof DiceBagMessage) {
            DiceBagMessage diceBagMessage = (DiceBagMessage)object;
            switch (diceBagMessage.getType()) {
                case 8: {
                    this.allDiceBagsRemoved();
                    break;
                }
                case 2: {
                    this.diceBagAdded(diceBagMessage.getDiceBag());
                    break;
                }
                case 4: {
                    this.diceBagRemoved(diceBagMessage.getDiceBag());
                    break;
                }
                case 64: {
                    this.diceBagSaved(diceBagMessage.getDiceBag());
                    break;
                }
                case 1: {
                    this.modelInitialized();
                    break;
                }
            }
        }
    }

    private void allDiceBagsRemoved() {
        Component[] componentArray = this.theDesktop.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof DiceBagView)) continue;
            ((DiceBagView)componentArray[i]).hide();
        }
    }

    private int askSaveBag(DiceBagModel diceBagModel, int n) {
        int n2 = 2;
        if (diceBagModel.isChanged()) {
            n2 = JOptionPane.showConfirmDialog(this.getMainComponent(), "Do you want to save your changes to dicebag " + diceBagModel.getName() + "?", "Save?", n);
            if (n2 == 0) {
                if (diceBagModel.getFilePath() != null && diceBagModel.getFilePath().length() > 0) {
                    this.m_model.saveDiceBag(diceBagModel);
                } else {
                    File file = DiceBagPluginController.chooseSaveFile(diceBagModel);
                    if (file != null) {
                        this.m_model.saveDiceBag(diceBagModel, file);
                    } else {
                        n2 = 2;
                    }
                }
            }
        } else {
            n2 = 1;
        }
        return n2;
    }

    private void diceBagAdded(DiceBagModel diceBagModel) {
        DiceBagView diceBagView = new DiceBagView(diceBagModel);
        diceBagView.addInternalFrameListener(this.listener);
        this.theDesktop.add(diceBagView);
        diceBagView.setLocation(this.newX, this.newY);
        this.newX += 20;
        this.newY += 20;
        if (!this.theDesktop.getBounds().contains(this.newX + 40, this.newY + 40)) {
            this.newX = 0;
            this.newY = 0;
        }
        diceBagView.setVisible(true);
    }

    private void diceBagRemoved(DiceBagModel diceBagModel) {
        Component[] componentArray = this.theDesktop.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!(componentArray[i] instanceof DiceBagView) || ((DiceBagView)componentArray[i]).getBag() != diceBagModel) continue;
            ((DiceBagView)componentArray[i]).hide();
        }
    }

    private void diceBagSaved(DiceBagModel diceBagModel) {
    }

    private void initComponents() {
        this.theDesktop = new JDesktopPane();
        this.theDesktop.setBackground(Color.LIGHT_GRAY);
    }

    private void modelInitialized() {
    }

    private class ChildListener
    extends InternalFrameAdapter {
        private ChildListener() {
        }

        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            DiceBagPluginView.this.internalFrameActivated(internalFrameEvent);
        }

        public void internalFrameClosed(InternalFrameEvent internalFrameEvent) {
            DiceBagPluginView.this.internalFrameClosed(internalFrameEvent);
        }

        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            DiceBagPluginView.this.internalFrameClosing(internalFrameEvent);
        }
    }
}

