/*
 * Decompiled with CFR 0.152.
 */
package pcgen.base.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pcgen.base.util.WrappedMapSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DoubleKeyMap<K1, K2, V>
implements Cloneable {
    private final Class<? extends Map> firstClass;
    private final Class<? extends Map> secondClass;
    private Map<K1, Map<K2, V>> map;

    public DoubleKeyMap() {
        this.firstClass = HashMap.class;
        this.secondClass = this.firstClass;
        this.map = new HashMap<K1, Map<K2, V>>();
    }

    public DoubleKeyMap(Class<? extends Map> clazz, Class<? extends Map> clazz2) {
        if (clazz == null) {
            throw new IllegalArgumentException("First underlying Class cannot be null for DoubleKeyMap");
        }
        if (clazz2 == null) {
            throw new IllegalArgumentException("Second underlying Class cannot be null for DoubleKeyMap");
        }
        this.firstClass = clazz;
        this.secondClass = clazz2;
        this.map = this.createGlobalMap();
        this.createLocalMap();
    }

    public DoubleKeyMap(DoubleKeyMap<K1, K2, V> doubleKeyMap) {
        this(doubleKeyMap.firstClass, doubleKeyMap.secondClass);
        this.putAll(doubleKeyMap);
    }

    public V put(K1 K1, K2 K2, V v) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            map = this.createLocalMap();
            this.map.put(K1, map);
        }
        return map.put(K2, v);
    }

    public final void putAll(DoubleKeyMap<K1, K2, V> doubleKeyMap) {
        for (Map.Entry<K1, Map<K2, V>> entry : doubleKeyMap.map.entrySet()) {
            Map<K2, V> map = this.map.get(entry.getKey());
            if (map == null) {
                map = this.createLocalMap();
                this.map.put(entry.getKey(), map);
            }
            map.putAll(entry.getValue());
        }
    }

    public V get(K1 K1, K2 K2) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            return null;
        }
        return map.get(K2);
    }

    public Map<K2, V> getMapFor(K1 K1) {
        Map<K2, V> map = this.map.get(K1);
        HashMap<K2, V> hashMap = new HashMap<K2, V>();
        if (map != null) {
            hashMap.putAll(map);
        }
        return hashMap;
    }

    public boolean containsKey(K1 K1) {
        return this.map.containsKey(K1);
    }

    public boolean containsKey(K1 K1, K2 K2) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            return false;
        }
        return map.containsKey(K2);
    }

    public V remove(K1 K1, K2 K2) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            return null;
        }
        V v = map.remove(K2);
        if (map.isEmpty()) {
            this.map.remove(K1);
        }
        return v;
    }

    public Map<K2, V> removeAll(K1 K1) {
        return this.map.remove(K1);
    }

    public Set<K1> getKeySet() {
        return new WrappedMapSet<K1>(this.firstClass, this.map.keySet());
    }

    public Set<K2> getSecondaryKeySet(K1 K1) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            return Collections.emptySet();
        }
        return new WrappedMapSet<K2>(this.secondClass, map.keySet());
    }

    public void clear() {
        this.map.clear();
    }

    public Set<V> values(K1 K1) {
        Map<K2, V> map = this.map.get(K1);
        if (map == null) {
            return Collections.emptySet();
        }
        return new HashSet<V>(map.values());
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int primaryKeyCount() {
        return this.map.size();
    }

    public DoubleKeyMap<K1, K2, V> clone() throws CloneNotSupportedException {
        DoubleKeyMap doubleKeyMap = (DoubleKeyMap)super.clone();
        doubleKeyMap.map = this.createGlobalMap();
        for (Map.Entry<K1, Map<K2, V>> entry : this.map.entrySet()) {
            doubleKeyMap.map.put(entry.getKey(), new HashMap<K2, V>(entry.getValue()));
        }
        return doubleKeyMap;
    }

    public boolean removeValue(K1 K1, V v) {
        Map<K2, V> map = this.map.get(K1);
        if (map != null) {
            return map.values().remove(v);
        }
        return false;
    }

    public int deepSize() {
        int n = 0;
        for (K1 K1 : this.map.keySet()) {
            for (K2 K2 : this.getSecondaryKeySet(K1)) {
                V v = this.get(K1, K2);
                if (v instanceof Collection) {
                    n += ((Collection)v).size();
                    continue;
                }
                ++n;
            }
        }
        return n;
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof DoubleKeyMap && ((Object)this.map).equals(((DoubleKeyMap)object).map);
    }

    private Map<K2, V> createLocalMap() {
        try {
            return this.secondClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", illegalAccessException);
        }
    }

    private Map<K1, Map<K2, V>> createGlobalMap() {
        try {
            return this.firstClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a zero-argument constructor", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new IllegalArgumentException("Class for DoubleKeyMap must possess a public zero-argument constructor", illegalAccessException);
        }
    }
}

