/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.base;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.JEPFormula;
import pcgen.core.Equipment;
import pcgen.core.PlayerCharacter;

public final class FormulaFactory {
    public static final Formula ZERO = new IntegerFormula(0);
    public static final Formula ONE = new IntegerFormula(1);

    private FormulaFactory() {
    }

    public static Formula getFormulaFor(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Formula cannot be empty");
        }
        try {
            return FormulaFactory.getFormulaFor(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return FormulaFactory.getFormulaFor(Double.valueOf(string));
            }
            catch (NumberFormatException numberFormatException2) {
                return new JEPFormula(string);
            }
        }
    }

    public static Formula getFormulaFor(Integer n) {
        return new IntegerFormula(n);
    }

    public static Formula getFormulaFor(Double d) {
        return new DoubleFormula(d);
    }

    private static class DoubleFormula
    implements Formula {
        private final Double i;

        public DoubleFormula(Double d) {
            if (d == null) {
                throw new IllegalArgumentException("Cannot create an DoubleFormula with a null Double");
            }
            this.i = d;
        }

        public Double resolve(PlayerCharacter playerCharacter, String string) {
            return this.i;
        }

        public Double resolve(Equipment equipment, boolean bl, PlayerCharacter playerCharacter, String string) {
            return this.i;
        }

        public String toString() {
            return this.i.toString();
        }

        public int hashCode() {
            return this.i.intValue();
        }

        public boolean equals(Object object) {
            return object instanceof DoubleFormula && ((DoubleFormula)object).i.equals(this.i);
        }

        public boolean isStatic() {
            return true;
        }
    }

    private static class IntegerFormula
    implements Formula {
        private final Integer i;

        public IntegerFormula(Integer n) {
            if (n == null) {
                throw new IllegalArgumentException("Cannot create an IntegerFormula with a null Integer");
            }
            this.i = n;
        }

        public Integer resolve(PlayerCharacter playerCharacter, String string) {
            return this.i;
        }

        public Integer resolve(Equipment equipment, boolean bl, PlayerCharacter playerCharacter, String string) {
            return this.i;
        }

        public String toString() {
            return this.i.toString();
        }

        public int hashCode() {
            return this.i;
        }

        public boolean equals(Object object) {
            return object instanceof IntegerFormula && ((IntegerFormula)object).i.equals(this.i);
        }

        public boolean isStatic() {
            return true;
        }
    }
}

