/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.choiceset;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.PrimitiveChoiceSet;
import pcgen.core.PlayerCharacter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleChoiceSet<T extends Comparable<T>>
implements PrimitiveChoiceSet<T> {
    private final Set<T> set;

    public SimpleChoiceSet(Collection<? extends T> collection) {
        if (collection == null) {
            throw new IllegalArgumentException("Choice Collection cannot be null");
        }
        if (collection.isEmpty()) {
            throw new IllegalArgumentException("Choice Collection cannot be empty");
        }
        this.set = new HashSet<T>(collection);
    }

    @Override
    public String getLSTformat(boolean bl) {
        return StringUtil.join(new TreeSet<T>(this.set), ",");
    }

    @Override
    public Class<T> getChoiceClass() {
        return this.set == null ? null : ((Comparable)this.set.iterator().next()).getClass();
    }

    @Override
    public Set<T> getSet(PlayerCharacter playerCharacter) {
        return new HashSet<T>(this.set);
    }

    public int hashCode() {
        return this.set.size();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof SimpleChoiceSet) {
            SimpleChoiceSet simpleChoiceSet = (SimpleChoiceSet)object;
            return ((Object)this.set).equals(simpleChoiceSet.set);
        }
        return false;
    }
}

