/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.base.formula.Formula;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.base.FormulaFactory;

public class ChallengeRating
extends ConcretePrereqObject {
    public static final ChallengeRating ZERO = new ChallengeRating("0");
    private final Formula rating;

    public ChallengeRating(String string) {
        try {
            int n = Integer.parseInt(string.startsWith("1/") ? string.substring(2) : string);
            if (n < 0) {
                throw new IllegalArgumentException("Challenge Rating cannot be negative");
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Challenge Rating must be a positive integer i or 1/i", numberFormatException);
        }
        this.rating = FormulaFactory.getFormulaFor(string);
    }

    public Formula getRating() {
        return this.rating;
    }

    public String getLSTformat() {
        String string = this.rating.toString();
        if (string.charAt(0) == '-') {
            string = "1/" + string.substring(1);
        }
        return string;
    }

    public int hashCode() {
        return this.rating.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ChallengeRating) {
            ChallengeRating challengeRating = (ChallengeRating)object;
            return this.rating.equals(challengeRating.rating) && this.equalsPrereqObject(challengeRating);
        }
        return false;
    }
}

