/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.Globals;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HitDie
extends ConcretePrereqObject
implements Comparable<HitDie> {
    public static final HitDie ZERO = new HitDie(0);
    private final int die;

    public HitDie(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("HitDie can not have a negative die size");
        }
        this.die = n;
    }

    public int getDie() {
        return this.die;
    }

    public HitDie getNext() {
        int[] nArray = Globals.getDieSizes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.die != nArray[i]) continue;
            if (i == n - 1) {
                Logging.debugPrint("Hit Die: " + this.die + " is Highest Hit Die in Die Sizes");
                return this;
            }
            return new HitDie(nArray[i + 1]);
        }
        Logging.errorPrint("Cannot find Hit Die: " + this.die + " in Global Die Sizes");
        return this;
    }

    public HitDie getPrevious() {
        int[] nArray = Globals.getDieSizes();
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (this.die != nArray[i]) continue;
            if (i == 0) {
                Logging.debugPrint("Hit Die: " + this.die + " is Lowest Hit Die in Die Sizes");
                continue;
            }
            return new HitDie(nArray[i - 1]);
        }
        Logging.errorPrint("Cannot find Hit Die: " + this.die + " in Global Die Sizes");
        return this;
    }

    public int hashCode() {
        return this.die;
    }

    public boolean equals(Object object) {
        return object instanceof HitDie && ((HitDie)object).die == this.die;
    }

    public String toString() {
        return "HitDie: " + this.die;
    }

    @Override
    public int compareTo(HitDie hitDie) {
        return this.die == hitDie.die ? 0 : (this.die < hitDie.die ? -1 : 1);
    }
}

