/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.content;

import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.core.PCClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LevelExchange
extends ConcretePrereqObject {
    private final CDOMSingleRef<PCClass> exchangeClass;
    private final int minDonatingLevel;
    private final int maxDonatedLevels;
    private final int donatingLowerLevelBound;

    public LevelExchange(CDOMSingleRef<PCClass> cDOMSingleRef, int n, int n2, int n3) {
        if (n <= 0) {
            throw new IllegalArgumentException("Error: Min Donating Level <= 0: Cannot Allow Donations to produce negative levels");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("Error: Max Donated Levels <= 0: Cannot Allow Donations to produce negative levels");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("Error: Max Remaining Levels < 0: Cannot Allow Donations to produce negative levels");
        }
        if (n - n2 > n3) {
            throw new IllegalArgumentException("Error: Donating Lower Bound cannot be reached");
        }
        this.exchangeClass = cDOMSingleRef;
        this.minDonatingLevel = n;
        this.maxDonatedLevels = n2;
        this.donatingLowerLevelBound = n3;
    }

    public int getDonatingLowerLevelBound() {
        return this.donatingLowerLevelBound;
    }

    public CDOMSingleRef<PCClass> getExchangeClass() {
        return this.exchangeClass;
    }

    public int getMaxDonatedLevels() {
        return this.maxDonatedLevels;
    }

    public int getMinDonatingLevel() {
        return this.minDonatingLevel;
    }

    public int hashCode() {
        return this.minDonatingLevel * 23 + this.maxDonatedLevels * 31 + this.donatingLowerLevelBound;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof LevelExchange)) {
            return false;
        }
        LevelExchange levelExchange = (LevelExchange)object;
        return this.minDonatingLevel == levelExchange.minDonatingLevel && this.maxDonatedLevels == levelExchange.maxDonatedLevels && this.donatingLowerLevelBound == levelExchange.donatingLowerLevelBound && this.exchangeClass.equals(levelExchange.exchangeClass);
    }
}

