/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.enumeration;

import java.util.Collection;
import java.util.Collections;
import pcgen.base.enumeration.TypeSafeConstant;
import pcgen.base.util.CaseInsensitiveMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Type
implements TypeSafeConstant,
Comparable<Type> {
    private static CaseInsensitiveMap<Type> typeMap = new CaseInsensitiveMap();
    public static final Type NATURAL = Type.getConstant("Natural");
    public static final Type CUSTOM = Type.getConstant("Custom");
    public static final Type NONE = Type.getConstant("None");
    public static final Type HUMANOID = Type.getConstant("Humanoid");
    public static final Type WEAPON = Type.getConstant("Weapon");
    public static final Type MELEE = Type.getConstant("Melee");
    public static final Type SIMPLE = Type.getConstant("Simple");
    public static final Type UNARMED = Type.getConstant("Unarmed");
    public static final Type SUBDUAL = Type.getConstant("Subdual");
    public static final Type STANDARD = Type.getConstant("Standard");
    public static final Type MONK = Type.getConstant("Monk");
    public static final Type BLUDGEONING = Type.getConstant("Bludgeoning");
    public static final Type AUTO_GEN = Type.getConstant("AUTO_GEN");
    public static final Type BOTH = Type.getConstant("Both");
    public static final Type THROWN = Type.getConstant("Thrown");
    public static final Type RANGED = Type.getConstant("Ranged");
    public static final Type DOUBLE = Type.getConstant("Double");
    public static final Type HEAD1 = Type.getConstant("Head1");
    public static final Type HEAD2 = Type.getConstant("Head2");
    public static final Type TEMPORARY = Type.getConstant("TEMPORARY");
    public static final Type DIVINE = Type.getConstant("Divine");
    private static int ordinalCount = 0;
    private final String fieldName;
    private final transient int ordinal;

    private Type(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Name for Type cannot be null");
        }
        this.ordinal = ordinalCount++;
        this.fieldName = string;
    }

    public String toString() {
        return this.fieldName;
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    public String getComparisonString() {
        return this.fieldName.toUpperCase();
    }

    public static Type getConstant(String string) {
        Type type = typeMap.get(string);
        if (type == null) {
            type = new Type(string);
            typeMap.put(string, type);
        }
        return type;
    }

    public static Type valueOf(String string) {
        Type type = typeMap.get(string);
        if (type == null) {
            throw new IllegalArgumentException(string + " is not a previously defined Type");
        }
        return type;
    }

    public static Collection<Type> getAllConstants() {
        return Collections.unmodifiableCollection(typeMap.values());
    }

    public static void clearConstants() {
        typeMap.clear();
    }

    @Override
    public int compareTo(Type type) {
        return this.fieldName.compareTo(type.fieldName);
    }
}

