/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.reference.CDOMGroupRef;
import pcgen.cdom.reference.ReferenceUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOMCompoundOrReference<T extends PrereqObject>
extends CDOMGroupRef<T> {
    private final ArrayList<CDOMReference<T>> references = new ArrayList();

    public CDOMCompoundOrReference(Class<T> clazz, String string) {
        super(clazz, string);
    }

    public void addReference(CDOMReference<T> cDOMReference) {
        if (!this.getReferenceClass().equals(cDOMReference.getReferenceClass())) {
            throw new IllegalArgumentException("Cannot add reference of " + cDOMReference.getReferenceClass() + " to CDOMCompoundOrReference of " + this.getReferenceClass());
        }
        this.references.add(cDOMReference);
    }

    @Override
    public boolean contains(T t) {
        for (CDOMReference<T> cDOMReference : this.references) {
            if (!cDOMReference.contains(t)) continue;
            return true;
        }
        return false;
    }

    public void trimToSize() {
        this.references.trimToSize();
    }

    @Override
    public String getLSTformat() {
        return ReferenceUtilities.joinLstFormat(this.references, ",");
    }

    @Override
    public void addResolution(T t) {
        throw new IllegalStateException("CompoundReference cannot be given a resolution");
    }

    @Override
    public int getObjectCount() {
        int n = 0;
        for (CDOMReference<T> cDOMReference : this.references) {
            n += cDOMReference.getObjectCount();
        }
        return n;
    }

    @Override
    public Collection<T> getContainedObjects() {
        HashSet<T> hashSet = new HashSet<T>();
        for (CDOMReference<T> cDOMReference : this.references) {
            hashSet.addAll(cDOMReference.getContainedObjects());
        }
        return hashSet;
    }
}

