/*
 * Decompiled with CFR 0.152.
 */
package pcgen.cdom.reference;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.reference.AbstractReferenceManufacturer;
import pcgen.cdom.reference.CDOMAllRef;
import pcgen.cdom.reference.CDOMCategorizedSingleRef;
import pcgen.cdom.reference.CDOMTypeRef;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.UnconstructedValidator;
import pcgen.core.AbilityUtilities;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorizedReferenceManufacturer<T extends CDOMObject>
extends AbstractReferenceManufacturer<T, CDOMCategorizedSingleRef<T>, CDOMTypeRef<T>, CDOMAllRef<T>>
implements ReferenceManufacturer<T, CDOMCategorizedSingleRef<T>> {
    private final Category<T> category;
    private CategorizedReferenceManufacturer<T> parentCrm = null;

    public CategorizedReferenceManufacturer(Class<T> clazz, Category<T> category) {
        super(clazz);
        this.category = category;
    }

    public void setParentCRM(CategorizedReferenceManufacturer<T> categorizedReferenceManufacturer) {
        this.parentCrm = categorizedReferenceManufacturer;
    }

    @Override
    public boolean validate(UnconstructedValidator unconstructedValidator) {
        if (this.parentCrm != null) {
            Collection collection = this.getReferenced();
            for (CDOMCategorizedSingleRef cDOMCategorizedSingleRef : collection) {
                String string = cDOMCategorizedSingleRef.getName();
                if (this.parentCrm.containsObject(string) && !this.containsObject(string)) {
                    Logging.debugPrint("Found match in parent for " + this.category + " - " + string);
                    this.addObject(this.parentCrm.getObject(string), string);
                    continue;
                }
                ArrayList<String> arrayList = new ArrayList<String>();
                String string2 = AbilityUtilities.getUndecoratedName(string, arrayList);
                if (!this.parentCrm.containsObject(string2) || this.containsObject(string2)) continue;
                Logging.debugPrint("Found match in parent for " + this.category + " - " + string2 + " - " + arrayList);
                this.addObject(this.parentCrm.getObject(string2), string2);
            }
        }
        return super.validate(unconstructedValidator);
    }

    @Override
    protected CDOMCategorizedSingleRef<T> getLocalReference(String string) {
        return new CDOMCategorizedSingleRef(this.getReferenceClass(), this.category, string);
    }

    @Override
    protected CDOMTypeRef<T> getLocalTypeReference(String[] stringArray) {
        return new CDOMTypeRef(this.getReferenceClass(), stringArray);
    }

    @Override
    protected CDOMAllRef<T> getLocalAllReference() {
        return new CDOMAllRef(this.getReferenceClass());
    }

    @Override
    protected String getReferenceDescription() {
        return this.getReferenceClass().getSimpleName() + " " + this.category;
    }

    @Override
    protected T buildObject(String string) {
        Object t = super.buildObject(string);
        ((CategorizedCDOMObject)t).setCDOMCategory(this.category);
        return t;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.getReferenceClass() + " " + this.category + "]";
    }

    @Override
    protected boolean validate(UnconstructedValidator unconstructedValidator, String string) {
        return unconstructedValidator != null && unconstructedValidator.allow(this.getReferenceClass(), this.category, string);
    }
}

