/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.Ability;
import pcgen.core.AbilityInfo;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;
import pcgen.core.CategorisableStore;
import pcgen.core.Globals;
import pcgen.util.Logging;

public class AbilityStore
extends CategorisableStore {
    public static final String CLEAR_TOKEN = ".CLEAR";
    public static final String CATEGORY_START_TOKEN = "CATEGORY=";

    public void addAbilityInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (CLEAR_TOKEN.equals(string)) {
            this.clear();
            return;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3, false);
        String string4 = this.getInitialCategory(string2, bl, stringTokenizer);
        if ("".equals(string4)) {
            return;
        }
        while (stringTokenizer.hasMoreTokens()) {
            String string5;
            String string6 = stringTokenizer.nextToken();
            if (string6.startsWith(CATEGORY_START_TOKEN)) {
                string5 = string6.substring(CATEGORY_START_TOKEN.length());
                if (bl && !string4.equals(string5)) {
                    Logging.errorPrint("Attempting to change the Category of a Feat to '" + string5 + "'", new Throwable());
                    return;
                }
                string4 = string5;
                continue;
            }
            if (string6.startsWith("TYPE=") || string6.startsWith("TYPE.")) {
                string5 = string6.substring(5);
                Iterator<? extends Categorisable> iterator = Globals.getAbilityNameIterator(string4);
                while (iterator.hasNext()) {
                    Ability ability = (Ability)iterator.next();
                    if (!ability.isType(string5)) continue;
                    this.addAsPerParsedInfo(bl2, string4, ability.getKeyName());
                }
                continue;
            }
            this.addAsPerParsedInfo(bl2, string4, string6);
        }
    }

    private void addAsPerParsedInfo(boolean bl, String string, String string2) {
        Comparable<Object> comparable;
        Comparable<Object> comparable2 = comparable = bl ? AbilityUtilities.retrieveAbilityKeyed(string, string2) : new AbilityInfo(string, string2);
        if (comparable == null) {
            if (bl) {
                Logging.errorPrint("Couldn't retrieve Ability! Category: " + string + ", KeyName: " + string2);
            }
        } else if (!this.addCategorisable((Categorisable)((Object)comparable))) {
            String string3 = bl ? "Ability object" : "AbilityInfo object";
            Logging.errorPrint("problem adding " + string3);
        }
    }

    private String getInitialCategory(String string, boolean bl, StringTokenizer stringTokenizer) {
        if (!"".equalsIgnoreCase(string)) {
            return string;
        }
        if (bl) {
            Logging.errorPrint("No Category set for Ability");
            return "";
        }
        String string2 = stringTokenizer.nextToken();
        if (string2.startsWith(CATEGORY_START_TOKEN)) {
            return string2.substring(CATEGORY_START_TOKEN.length());
        }
        Logging.errorPrint("No Category set for Ability");
        return "";
    }

    public String getParsableStringRepresentation() {
        String string = "";
        Iterator<String> iterator = this.getCategoryIterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next();
            if (string.length() > 0) {
                string = string + "|";
            }
            string = string + CATEGORY_START_TOKEN + string2;
            Iterator<Categorisable> iterator2 = this.getKeyIterator(string2);
            while (iterator2.hasNext()) {
                AbilityInfo abilityInfo = (AbilityInfo)iterator2.next();
                string = string + "|" + abilityInfo.getKeyName();
            }
        }
        return string;
    }
}

