/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CategorizedCDOMObject;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.reference.ReferenceManufacturer;
import pcgen.cdom.reference.TransparentCategorizedReferenceManufacturer;
import pcgen.cdom.reference.TransparentReferenceManufacturer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.rules.context.ConsolidatedListCommitStrategy;
import pcgen.rules.context.GameReferenceContext;
import pcgen.rules.context.LoadContext;
import pcgen.rules.context.ReferenceContext;
import pcgen.rules.context.RuntimeLoadContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Campaign
extends PObject {
    private boolean isLoaded;
    private boolean isInitted;
    private ConsolidatedListCommitStrategy masterLCS = new ConsolidatedListCommitStrategy();
    private GameReferenceContext gameRefContext = new GameReferenceContext();
    private LoadContext context = new RuntimeLoadContext(this.gameRefContext, this.masterLCS);

    public boolean isGameMode(List<String> list) {
        for (String string : list) {
            if (!this.containsInList(ListKey.GAME_MODE, string)) continue;
            return true;
        }
        return false;
    }

    public boolean isInitted() {
        return this.isInitted;
    }

    public void setInitted(boolean bl) {
        this.isInitted = bl;
    }

    public void setIsLoaded(boolean bl) {
        this.isLoaded = bl;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    @Override
    public Campaign getSourceCampaign() {
        return this;
    }

    public List<Campaign> getSubCampaigns() {
        List<CampaignSourceEntry> list = this.getSafeListFor(ListKey.FILE_PCC);
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>(list.size());
        for (CampaignSourceEntry campaignSourceEntry : list) {
            Campaign campaign = Globals.getCampaignByURI(campaignSourceEntry.getURI(), true);
            arrayList.add(campaign);
        }
        return arrayList;
    }

    @Override
    public Campaign clone() {
        Campaign campaign = null;
        try {
            campaign = (Campaign)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return campaign;
    }

    public LoadContext getCampaignContext() {
        return this.context;
    }

    public void applyTo(ReferenceContext referenceContext) {
        for (TransparentReferenceManufacturer<? extends CDOMObject> transparentReferenceManufacturer : this.gameRefContext.getAllManufacturers()) {
            this.resolveReferenceManufacturer(referenceContext, transparentReferenceManufacturer);
        }
    }

    private <T extends CDOMObject> void resolveReferenceManufacturer(ReferenceContext referenceContext, TransparentReferenceManufacturer<T> transparentReferenceManufacturer) {
        ReferenceManufacturer referenceManufacturer;
        Class clazz = transparentReferenceManufacturer.getReferenceClass();
        if (CategorizedCDOMObject.class.isAssignableFrom(clazz)) {
            String string = ((TransparentCategorizedReferenceManufacturer)transparentReferenceManufacturer).getCDOMCategory();
            referenceManufacturer = referenceContext.getManufacturer(clazz, string);
        } else {
            referenceManufacturer = referenceContext.getManufacturer(clazz);
        }
        transparentReferenceManufacturer.resolveUsing(referenceManufacturer);
    }
}

