/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import pcgen.core.AbilityUtilities;
import pcgen.core.Categorisable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CategorisableStore
implements Cloneable {
    private static final Comparator<Categorisable> catKeyComp = new Comparator<Categorisable>(){

        @Override
        public int compare(Categorisable categorisable, Categorisable categorisable2) {
            return categorisable.getKeyName().compareToIgnoreCase(categorisable2.getKeyName());
        }
    };
    private static final Comparator<Categorisable> catNameComp = new Comparator<Categorisable>(){

        @Override
        public int compare(Categorisable categorisable, Categorisable categorisable2) {
            int n = categorisable.getDisplayName().compareToIgnoreCase(categorisable2.getDisplayName());
            if (n == 0) {
                n = categorisable.getKeyName().compareToIgnoreCase(categorisable2.getKeyName());
            }
            return n;
        }
    };
    private static final Comparator<String> stringComp = new Comparator<String>(){

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    };
    protected Map<String, Map<String, Categorisable>> categoryMap = new HashMap<String, Map<String, Categorisable>>();

    public boolean addCategorisable(Categorisable categorisable) {
        String string;
        Map<String, Categorisable> map = this.categoryMap.get(categorisable.getCategory());
        if (map == null) {
            map = new HashMap<String, Categorisable>();
            this.categoryMap.put(categorisable.getCategory(), map);
        }
        if (map.get(string = categorisable.getKeyName().toLowerCase()) != null) {
            return false;
        }
        map.put(string, categorisable);
        return map.get(string) == categorisable;
    }

    public void clear() {
        this.categoryMap = new HashMap<String, Map<String, Categorisable>>();
    }

    public Object clone() {
        CategorisableStore categorisableStore = new CategorisableStore();
        Iterator<Categorisable> iterator = this.getKeyIterator("ALL");
        while (iterator.hasNext()) {
            categorisableStore.addCategorisable(iterator.next());
        }
        return categorisableStore;
    }

    public Categorisable getKeyed(String string, String string2) {
        Map<String, Categorisable> map = this.categoryMap.get(string);
        if (map == null) {
            return null;
        }
        String string3 = string2.toLowerCase();
        return map.get(string3);
    }

    public Iterator<Categorisable> getKeyIterator(String string) {
        TreeSet<Categorisable> treeSet = this.getSortedSet(string, catKeyComp);
        if (treeSet == null) {
            Set set = Collections.emptySet();
            return set.iterator();
        }
        return Collections.unmodifiableSortedSet(treeSet).iterator();
    }

    @Deprecated
    public Categorisable getNamed(String string, String string2) {
        Iterator<Categorisable> iterator = this.getNameIterator(string);
        if (iterator == null) {
            return null;
        }
        String string3 = AbilityUtilities.removeChoicesFromName(string2);
        while (iterator.hasNext()) {
            Categorisable categorisable = iterator.next();
            if (!categorisable.getDisplayName().equalsIgnoreCase(string2) && !categorisable.getDisplayName().equalsIgnoreCase(string3)) continue;
            return categorisable;
        }
        return null;
    }

    public Iterator<Categorisable> getNameIterator(String string) {
        TreeSet<Categorisable> treeSet = this.getSortedSet(string, catNameComp);
        if (treeSet == null) {
            Set set = Collections.emptySet();
            return set.iterator();
        }
        return Collections.unmodifiableSortedSet(treeSet).iterator();
    }

    public Iterator<String> getCategoryIterator() {
        TreeSet<String> treeSet = this.getSortedCategorySet(stringComp);
        if (treeSet == null) {
            Set set = Collections.emptySet();
            return set.iterator();
        }
        return Collections.unmodifiableSortedSet(treeSet).iterator();
    }

    private TreeSet<Categorisable> getSortedSet(String string, Comparator<Categorisable> comparator) {
        Map<String, Categorisable> map;
        HashSet<Categorisable> hashSet;
        if ("ALL".equals(string)) {
            hashSet = this.makeAggregateSet();
        } else {
            map = this.categoryMap.get(string);
            if (map == null) {
                return null;
            }
            hashSet = new HashSet(map.values());
        }
        map = new TreeSet<Categorisable>(comparator);
        ((TreeSet)((Object)map)).addAll(hashSet);
        return map;
    }

    private TreeSet<String> getSortedCategorySet(Comparator<String> comparator) {
        TreeSet<String> treeSet = new TreeSet<String>(comparator);
        treeSet.addAll(this.categoryMap.keySet());
        return treeSet;
    }

    public List<Categorisable> getUnmodifiableList(String string) {
        TreeSet<Categorisable> treeSet = this.getSortedSet(string, catNameComp);
        if (treeSet == null) {
            return Collections.emptyList();
        }
        ArrayList<Categorisable> arrayList = new ArrayList<Categorisable>(treeSet.size());
        arrayList.addAll(treeSet);
        return Collections.unmodifiableList(arrayList);
    }

    private HashSet<Categorisable> makeAggregateSet() {
        HashSet<Categorisable> hashSet = new HashSet<Categorisable>();
        for (Map<String, Categorisable> map : this.categoryMap.values()) {
            hashSet.addAll(map.values());
        }
        return hashSet;
    }

    public boolean removeKeyed(String string, String string2) {
        Map<String, Categorisable> map = this.categoryMap.get(string);
        if (map == null) {
            return false;
        }
        Categorisable categorisable = map.remove(string2.toLowerCase());
        return categorisable != null;
    }

    @Deprecated
    public boolean removeNamed(String string, String string2) {
        Iterator<Categorisable> iterator = this.getNameIterator(string);
        if (iterator == null) {
            return false;
        }
        String string3 = AbilityUtilities.removeChoicesFromName(string2);
        while (iterator.hasNext()) {
            Categorisable categorisable = iterator.next();
            if (!categorisable.getDisplayName().equalsIgnoreCase(string2) && !categorisable.getDisplayName().equalsIgnoreCase(string3)) continue;
            String string4 = categorisable.getKeyName().toLowerCase();
            Map<String, Categorisable> map = this.categoryMap.get(string);
            Categorisable categorisable2 = map.remove(string4);
            return categorisable2 != null;
        }
        return false;
    }

    public int size() {
        int n = 0;
        for (Map<String, Categorisable> map : this.categoryMap.values()) {
            n += map.size();
        }
        return n;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

