/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

public class Description
extends ConcretePrereqObject {
    private List<String> theComponents = new ArrayList<String>();
    private List<String> theVariables = null;
    private static final String VAR_NAME = "%NAME";
    private static final String VAR_CHOICE = "%CHOICE";
    private static final String VAR_LIST = "%LIST";
    private static final String VAR_FEATS = "%FEAT=";
    private static final String VAR_MARKER = "$$VAR:";

    public Description(String string) {
        int n = 0;
        int n2 = -1;
        while ((n2 = string.indexOf(37, n)) != -1) {
            String string2 = string.substring(n, n2);
            if (string2.length() > 0) {
                this.theComponents.add(string2);
            }
            if (n2 == string.length() - 1) {
                this.theComponents.add("%");
                return;
            }
            if (string.charAt(n2 + 1) == '{') {
                n = string.indexOf(125, n2 + 1) + 1;
                String string3 = string.substring(n2 + 1, n);
                try {
                    Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    Logging.errorPrintLocalised("Errors.Description.InvalidVariableReplacement", string3);
                }
                this.theComponents.add(VAR_MARKER + string3);
                continue;
            }
            if (string.charAt(n2 + 1) == '%') {
                n = n2 + 2;
                this.theComponents.add("%");
                continue;
            }
            for (n = n2 + 1; n < string.length(); ++n) {
                char c = string.charAt(n);
                try {
                    Integer.parseInt(String.valueOf(c));
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    break;
                }
            }
            if (n > n2 + 1) {
                this.theComponents.add(VAR_MARKER + string.substring(n2 + 1, n));
                continue;
            }
            this.theComponents.add(string.substring(n2, n2 + 1));
            Logging.log(Logging.LST_WARNING, "The % without a number in the description '" + string + "' should be either escaped e.g. %% or made into a parameter reference e.g. %1 .");
        }
        this.theComponents.add(string.substring(n));
    }

    public void addVariable(String string) {
        if (this.theVariables == null) {
            this.theVariables = new ArrayList<String>();
        }
        this.theVariables.add(string);
    }

    public String getDescription(PlayerCharacter playerCharacter, PObject pObject) {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.qualifies(playerCharacter)) {
            if (pObject instanceof Ability) {
                pObject = playerCharacter.getAbilityMatching((Ability)pObject);
            }
            for (String string : this.theComponents) {
                if (string.startsWith(VAR_MARKER)) {
                    Object object;
                    Object object2;
                    int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                    if (this.theVariables == null || n > this.theVariables.size()) {
                        stringBuffer.append("");
                        continue;
                    }
                    String string2 = this.theVariables.get(n - 1);
                    if (string2.equals(VAR_NAME)) {
                        if (pObject == null) continue;
                        stringBuffer.append(pObject.getOutputName());
                        continue;
                    }
                    if (string2.equals(VAR_CHOICE)) {
                        if (pObject == null || !playerCharacter.hasAssociations(pObject)) continue;
                        stringBuffer.append(playerCharacter.getFirstAssociation(pObject));
                        continue;
                    }
                    if (string2.equals(VAR_LIST)) {
                        if (pObject == null) continue;
                        object2 = playerCharacter.getExpandedAssociations(pObject);
                        object = object2.size() == 2 ? " and " : ", ";
                        stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(playerCharacter.getExpandedAssociations(pObject), (String)object));
                        continue;
                    }
                    if (string2.startsWith(VAR_FEATS)) {
                        object2 = string2.substring(VAR_FEATS.length());
                        if (((String)object2).startsWith("TYPE=") || ((String)object2).startsWith("TYPE.")) {
                            object = playerCharacter.getAggregateAbilityList(AbilityCategory.FEAT);
                            boolean bl = true;
                            Iterator iterator = object.iterator();
                            while (iterator.hasNext()) {
                                Ability ability = (Ability)iterator.next();
                                if (!ability.isType(((String)object2).substring(5))) continue;
                                if (!bl) {
                                    stringBuffer.append(", ");
                                }
                                stringBuffer.append(playerCharacter.getDescription(ability));
                                bl = false;
                            }
                            continue;
                        }
                        object = playerCharacter.getAbilityKeyed(AbilityCategory.FEAT, (String)object2);
                        stringBuffer.append(playerCharacter.getDescription((PObject)object));
                        continue;
                    }
                    if (string2.startsWith("\"")) {
                        stringBuffer.append(string2.substring(1, string2.length() - 1));
                        continue;
                    }
                    stringBuffer.append(playerCharacter.getVariableValue(string2, "Description").intValue());
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.theComponents) {
            if (string.startsWith(VAR_MARKER)) {
                int n = Integer.parseInt(string.substring(VAR_MARKER.length()));
                stringBuffer.append('%' + String.valueOf(n));
                continue;
            }
            if (string.equals("%")) {
                stringBuffer.append("%%");
                continue;
            }
            stringBuffer.append(string);
        }
        if (this.theVariables != null) {
            for (String string : this.theVariables) {
                stringBuffer.append("|");
                stringBuffer.append(string);
            }
        }
        PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
        try {
            String string;
            string = prerequisiteWriter.getPrerequisiteString(this.getPrerequisiteList());
            if (string != null) {
                stringBuffer.append("|");
                stringBuffer.append(string);
            }
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Error writing Prerequisite: " + persistenceLayerException);
        }
        return stringBuffer.toString();
    }

    public String toString() {
        return this.getPCCText();
    }

    public int hashCode() {
        return this.theComponents.size() + 7 * this.getPrerequisiteCount() + 31 * (this.theVariables == null ? 0 : this.theVariables.size());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Description)) {
            return false;
        }
        Description description = (Description)object;
        if (this.theVariables == null && description.theVariables != null) {
            return false;
        }
        return ((Object)this.theComponents).equals(description.theComponents) && (this.theVariables == null || ((Object)this.theVariables).equals(description.theVariables)) && this.equalsPrereqObject(description);
    }
}

