/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Type;
import pcgen.core.Equipment;
import pcgen.core.EquipmentChoice;
import pcgen.core.EquipmentModifier;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.analysis.EquipmentChoiceDriver;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.util.Delta;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentList {
    private static boolean autoGeneration = false;

    private EquipmentList() {
    }

    private static boolean isAutoGeneration() {
        return autoGeneration;
    }

    public static void setAutoGeneration(boolean bl) {
        autoGeneration = bl;
    }

    public static Equipment getEquipmentFromName(String string, PlayerCharacter playerCharacter) {
        Object object;
        Object object2;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        String string2 = string;
        int n = string2.indexOf(40);
        if (n >= 0) {
            object2 = new StringTokenizer(string2.substring(n + 1), "/)", false);
            while (((StringTokenizer)object2).hasMoreTokens()) {
                int n2;
                String string3 = ((StringTokenizer)object2).nextToken();
                for (n2 = 0; n2 <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1 && !string3.equalsIgnoreCase(SettingsHandler.getGame().getSizeAdjustmentAtIndex(n2).getAbbreviation()); ++n2) {
                }
                if (n2 <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
                    arrayList3.add(string3);
                    continue;
                }
                if ("Mighty Composite".equalsIgnoreCase(string3)) {
                    arrayList.add("Mighty");
                    arrayList.add("Composite");
                    continue;
                }
                arrayList.add(string3);
            }
            string2 = string2.substring(0, n).trim();
        }
        if (n >= 0) {
            for (n = arrayList.size() - 1; n >= 0; --n) {
                object2 = (String)arrayList.get(n);
                if (EquipmentList.getModifierNamed((String)object2) != null) continue;
                arrayList2.add(0, (String)object2);
                arrayList.remove(n);
            }
        }
        object2 = null;
        int n3 = 0;
        n = string2.indexOf(43);
        if (n >= 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2.substring(n), "/", false);
            n3 = stringTokenizer.countTokens();
            object2 = new int[n3];
            int n4 = 0;
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                object2[n4++] = Delta.decode(string4);
            }
            string2 = string2.substring(0, n).trim();
            if (n3 > 0) {
                for (int i = 0; i < arrayList2.size(); ++i) {
                    String string5 = (String)arrayList2.get(i);
                    if (!"Mighty".equalsIgnoreCase(string5)) continue;
                    string5 = Delta.toString((int)object2[n3 - 1]) + " " + string5;
                    arrayList2.set(i, string5);
                    --n3;
                }
            }
        }
        String string6 = "";
        String string7 = "";
        while (true) {
            String string8;
            if ((object = EquipmentList.findEquipment(string8 = string2 + string7, null, arrayList2, arrayList3, string6)) != null) {
                if (arrayList3.size() <= 1) break;
                arrayList3.remove(0);
                break;
            }
            object = EquipmentList.findEquipment(string8, arrayList2, null, arrayList3, string6);
            if (object != null) {
                if (arrayList3.size() <= 1) break;
                arrayList3.remove(0);
                break;
            }
            object = EquipmentList.findEquipment(string8, arrayList2, null, null, string6);
            if (object != null) break;
            if (arrayList3.size() == 1) {
                object = EquipmentList.findEquipment(string8, arrayList3, arrayList2, null, string6);
                if (object == null) {
                    object = EquipmentList.findEquipment(string8, arrayList2, arrayList3, null, string6);
                }
                if (object != null) {
                    arrayList3.clear();
                    break;
                }
            }
            if (string.indexOf("Thrown") >= 0 && string6.length() == 0) {
                string6 = "Thrown";
                continue;
            }
            if (n3 <= 0 || object2 == null || string7.length() != 0) break;
            string6 = "";
            string7 = " " + Delta.toString((int)object2[0]);
        }
        if (object != null) {
            boolean bl = false;
            boolean bl2 = false;
            object = ((Equipment)object).clone();
            for (String string9 : arrayList) {
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed(string9, (Equipment)object);
                if (equipmentModifier != null) {
                    ((Equipment)object).addEqModifier(equipmentModifier, true, playerCharacter);
                    if (!equipmentModifier.getSafe(ObjectKey.ASSIGN_TO_ALL).booleanValue() || !((Equipment)object).isDouble()) continue;
                    ((Equipment)object).addEqModifier(equipmentModifier, false, playerCharacter);
                    bl = true;
                    continue;
                }
                Logging.errorPrint("Could not find a qualified modifier named: " + string9 + " for " + ((Equipment)object).getName() + ":" + ((Equipment)object).typeList());
                bl2 = true;
            }
            if (bl2) {
                return null;
            }
            if (arrayList3.size() != 0) {
                ((Equipment)object).resizeItem(playerCharacter, SettingsHandler.getGame().getSizeAdjustmentNamed((String)arrayList3.get(0)));
                bl = true;
                if (arrayList3.size() > 1) {
                    Logging.errorPrint("Too many sizes in item name, used only 1st of: " + arrayList3);
                }
            }
            if (bl) {
                ((Equipment)object).nameItemFromModifiers(playerCharacter);
                Equipment equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, ((CDOMObject)object).getKeyName());
                if (equipment == null) {
                    Globals.getContext().ref.importObject(object);
                } else {
                    object = equipment;
                }
            }
        }
        return object;
    }

    public static List<Equipment> getEquipmentOfType(String string, String string2) {
        List<String> list = CoreUtility.split(string, '.');
        List<String> list2 = CoreUtility.split(string2, '.');
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(100);
        if (list.size() != 0) {
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                boolean bl = true;
                for (String string3 : list) {
                    if (equipment.isType(string3)) continue;
                    bl = false;
                    break;
                }
                if (bl && list2.size() != 0) {
                    for (String string3 : list2) {
                        if (!equipment.isType(string3)) continue;
                        bl = false;
                        break;
                    }
                }
                if (!bl) continue;
                arrayList.add(equipment);
            }
        }
        return arrayList;
    }

    public static void autoGenerateEquipment() {
        EquipmentList.setAutoGeneration(true);
        EquipmentList.autogenerateRacialEquipment();
        EquipmentList.autogenerateMasterWorkEquipment();
        EquipmentList.autogenerateMagicEquipment();
        EquipmentList.autogenerateExoticMaterialsEquipment();
        EquipmentList.setAutoGeneration(false);
    }

    private static void autogenerateExoticMaterialsEquipment() {
        if (SettingsHandler.isAutogenExoticMaterial()) {
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                if (equipment.isMagic() || equipment.isUnarmed() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Darkwood", equipment);
                EquipmentModifier equipmentModifier2 = EquipmentList.getQualifiedModifierNamed("Adamantine", equipment);
                EquipmentModifier equipmentModifier3 = EquipmentList.getQualifiedModifierNamed("Mithral", equipment);
                EquipmentList.createItem(equipment, equipmentModifier, null, null, null);
                EquipmentList.createItem(equipment, equipmentModifier2, null, null, null);
                EquipmentList.createItem(equipment, equipmentModifier3, null, null, null);
            }
        }
    }

    private static void autogenerateMagicEquipment() {
        if (SettingsHandler.isAutogenMagic()) {
            for (int i = 1; i <= 5; ++i) {
                String string = Delta.toString(i);
                for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                    if (equipment.isMagic() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                    EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Masterwork", equipment);
                    if (equipmentModifier == null) {
                        Logging.debugPrint("Could not generate a Masterwork " + equipment.toString() + " as the equipment modifier could not be found.");
                        continue;
                    }
                    EquipmentChoice equipmentChoice = EquipmentChoiceDriver.buildEquipmentChoice(0, equipment, equipmentModifier, false, false, 0, null);
                    EquipmentChoice.EquipChoiceIterator equipChoiceIterator = equipmentChoice.getChoiceIterator(true);
                    while (equipChoiceIterator.hasNext()) {
                        String string2 = (String)equipChoiceIterator.next();
                        equipment = equipment.clone();
                        equipment.addEqModifier(equipmentModifier, true, null, string2, equipmentChoice);
                        if (equipment.isWeapon() && equipment.isDouble()) {
                            equipment.addEqModifier(equipmentModifier, false, null, string2, equipmentChoice);
                        }
                        if ((equipmentModifier = EquipmentList.getQualifiedModifierNamed(string, equipment)) == null) {
                            Logging.debugPrint("Could not generate a " + string + " " + equipment.toString() + " as the equipment modifier could not be found.");
                            continue;
                        }
                        EquipmentList.createItem(equipment, equipmentModifier, null, null, null);
                    }
                }
            }
        }
    }

    private static void autogenerateMasterWorkEquipment() {
        if (SettingsHandler.isAutogenMasterwork()) {
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                if (equipment.isMagic() || equipment.isUnarmed() || equipment.isMasterwork() || !equipment.isAmmunition() && !equipment.isArmor() && !equipment.isShield() && !equipment.isWeapon()) continue;
                EquipmentModifier equipmentModifier = EquipmentList.getQualifiedModifierNamed("Masterwork", equipment);
                EquipmentChoice equipmentChoice = EquipmentChoiceDriver.buildEquipmentChoice(0, equipment, equipmentModifier, false, false, 0, null);
                EquipmentChoice.EquipChoiceIterator equipChoiceIterator = equipmentChoice.getChoiceIterator(true);
                while (equipChoiceIterator.hasNext()) {
                    String string = (String)equipChoiceIterator.next();
                    EquipmentList.createItem(equipment, equipmentModifier, null, string, equipmentChoice);
                }
            }
        }
    }

    private static void autogenerateRacialEquipment() {
        if (SettingsHandler.isAutogenRacial()) {
            int[] nArray = new int[10];
            for (Race object : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
                int equipment;
                int n = equipment = object.getSafe(FormulaKey.SIZE).resolve(null, "").intValue();
                nArray[n] = nArray[n] | 1;
            }
            int n = -1;
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                if (!Globals.canResizeHaveEffect(null, equipment, null)) continue;
                for (int i = 0; i <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1; ++i) {
                    SizeAdjustment sizeAdjustment;
                    if (n == -1 && (sizeAdjustment = SettingsHandler.getGame().getSizeAdjustmentAtIndex(i)).isDefaultSize()) {
                        n = i;
                    }
                    if (i == n || (nArray[i] & 1) == 0) continue;
                    EquipmentList.createItem(equipment, i, null);
                }
            }
        }
    }

    private static EquipmentModifier getModifierNamed(String string) {
        for (EquipmentModifier equipmentModifier : Globals.getContext().ref.getConstructedCDOMObjects(EquipmentModifier.class)) {
            if (!equipmentModifier.getDisplayName().equals(string)) continue;
            return equipmentModifier;
        }
        return null;
    }

    private static EquipmentModifier getQualifiedModifierNamed(String string, Equipment equipment) {
        for (EquipmentModifier equipmentModifier : Globals.getContext().ref.getConstructedCDOMObjects(EquipmentModifier.class)) {
            if (!equipmentModifier.getDisplayName().startsWith(string)) continue;
            for (String string2 : equipment.typeList()) {
                if (!equipmentModifier.isType(string2) || !PrereqHandler.passesAll(equipmentModifier.getPrerequisiteList(), equipment, null)) continue;
                return equipmentModifier;
            }
        }
        return null;
    }

    private static void appendNameParts(List<String> list, String string, StringBuffer stringBuffer) {
        for (String string2 : list) {
            if (string.length() != 0 && string2.equals(string)) continue;
            if (stringBuffer.length() > 2) {
                stringBuffer.append('/');
            }
            stringBuffer.append(string2);
        }
    }

    private static void createItem(Equipment equipment, int n, PlayerCharacter playerCharacter) {
        EquipmentList.createItem(equipment, null, n, playerCharacter, "", null);
    }

    private static void createItem(Equipment equipment, EquipmentModifier equipmentModifier, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        EquipmentList.createItem(equipment, equipmentModifier, -1, playerCharacter, string, equipmentChoice);
    }

    private static void createItem(Equipment equipment, EquipmentModifier equipmentModifier, int n, PlayerCharacter playerCharacter, String string, EquipmentChoice equipmentChoice) {
        if (equipment == null) {
            return;
        }
        try {
            String string2;
            Equipment equipment2;
            if (!equipment.getSafe(ObjectKey.MOD_CONTROL).getModifiersAllowed() || equipment.isArmor() && equipment.getACMod(playerCharacter) == 0 && equipmentModifier != null && !equipmentModifier.getDisplayName().equalsIgnoreCase("MASTERWORK")) {
                return;
            }
            if ((equipment = equipment.clone()) == null) {
                Logging.errorPrint("could not clone item");
                return;
            }
            if (equipmentModifier != null) {
                equipment.addEqModifier(equipmentModifier, true, playerCharacter, string, equipmentChoice);
                if (equipment.isWeapon() && equipment.isDouble()) {
                    equipment.addEqModifier(equipmentModifier, false, playerCharacter, string, equipmentChoice);
                }
            }
            if (n >= 0 && n <= SettingsHandler.getGame().getSizeAdjustmentListSize() - 1) {
                equipment.resizeItem(playerCharacter, SettingsHandler.getGame().getSizeAdjustmentAtIndex(n));
            }
            if ((equipment2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string2 = equipment.nameItemFromModifiers(playerCharacter))) != null) {
                return;
            }
            Type type = EquipmentList.isAutoGeneration() ? Type.AUTO_GEN : Type.CUSTOM;
            if (!equipment.isType(type.toString())) {
                equipment.addType(type);
            }
            Globals.getContext().addTypesToList(equipment);
            Globals.getContext().ref.importObject(equipment);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("createItem: exception: " + equipment.getName());
        }
    }

    private static Equipment findEquipment(String string, List<String> list, List<String> list2, List<String> list3, String string2) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer(80);
        stringBuffer.append(" (");
        if (list != null) {
            object = list;
            EquipmentList.appendNameParts(object, string2, stringBuffer);
        }
        if (list3 != null && list3.size() > 1) {
            stringBuffer.append(list3.get(0));
        }
        if (list2 != null) {
            EquipmentList.appendNameParts(list2, string2, stringBuffer);
        }
        if (stringBuffer.length() == 2) {
            stringBuffer.setLength(0);
        } else {
            stringBuffer.append(')');
        }
        object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string + stringBuffer);
        return object;
    }
}

