/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.SpellResistance;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.AssociationStore;
import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SpecialProperty;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EquipmentModifier
extends PObject
implements Comparable<Object> {
    private static final Formula CHOICE_FORMULA = FormulaFactory.getFormulaFor("%CHOICE");

    public List<BonusObj> getActiveBonuses(Equipment equipment, PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getBonusList(equipment)) {
            if (!PrereqHandler.passesAll(bonusObj.getPrerequisiteList(), equipment, playerCharacter)) continue;
            bonusObj.setApplied(true);
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    @Override
    public List<BonusObj> getBonusList(AssociationStore associationStore) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>(super.getBonusList(associationStore));
        for (int i = arrayList.size() - 1; i > -1; --i) {
            BonusObj bonusObj = (BonusObj)arrayList.get(i);
            String string = bonusObj.toString();
            int n = string.indexOf("%CHOICE");
            if (n < 0) continue;
            for (String string2 : associationStore.getAssociationList(this)) {
                BonusObj bonusObj2 = Bonus.newBonus(string.substring(0, n) + string2 + string.substring(n + 7));
                bonusObj2.setCreatorObject(this);
                if (bonusObj.hasPrerequisites()) {
                    bonusObj2.clearPrerequisiteList();
                    for (Prerequisite prerequisite : bonusObj.getPrerequisiteList()) {
                        try {
                            bonusObj2.addPrerequisite(prerequisite.clone());
                        }
                        catch (CloneNotSupportedException cloneNotSupportedException) {}
                    }
                }
                bonusObj2.expandToken("%CHOICE", string2);
                arrayList.add(bonusObj2);
            }
            arrayList.remove(bonusObj);
        }
        return arrayList;
    }

    public boolean isIType(String string) {
        for (String string2 : this.getSafeListFor(ListKey.ITEM_TYPES)) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public List<String> getSpecialProperties(Equipment equipment, PlayerCharacter playerCharacter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (SpecialProperty specialProperty : this.getSafeListFor(ListKey.SPECIAL_PROPERTIES)) {
            String string = specialProperty.getParsedText(playerCharacter, equipment);
            for (String string2 : equipment.getAssociationList(this)) {
                string = string.replaceFirst("%CHOICE", string2);
            }
            if (string == null || string.equals("")) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    public double bonusTo(PlayerCharacter playerCharacter, String string, String string2, AssociationStore associationStore) {
        double d = super.bonusTo(string, string2, associationStore, this.getBonusList(associationStore), playerCharacter);
        return d;
    }

    @Override
    public EquipmentModifier clone() {
        EquipmentModifier equipmentModifier = null;
        try {
            equipmentModifier = (EquipmentModifier)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            ShowMessageDelegate.showMessageDialog(cloneNotSupportedException.getMessage(), "PCGen", MessageType.ERROR);
        }
        return equipmentModifier;
    }

    @Override
    public String toString() {
        return this.getKeyName();
    }

    public int getSR(Equipment equipment, PlayerCharacter playerCharacter) {
        SpellResistance spellResistance = this.get(ObjectKey.SR);
        if (spellResistance == null) {
            return 0;
        }
        if (spellResistance.getReduction().equals(CHOICE_FORMULA) && equipment.hasAssociations(this)) {
            return Delta.parseInt(equipment.getFirstAssociation(this));
        }
        return spellResistance.getReduction().resolve(equipment, true, playerCharacter, this.getQualifiedKey()).intValue();
    }

    @Override
    public int compareTo(Object object) {
        if (object instanceof EquipmentModifier) {
            return this.getKeyName().compareTo(((PObject)object).getKeyName());
        }
        return this.getKeyName().compareTo(object.toString());
    }
}

