/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.ConcretePrereqObject;
import pcgen.cdom.list.CompanionList;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.ReferenceUtilities;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FollowerOption
extends ConcretePrereqObject
implements Comparable<FollowerOption> {
    private int theAdjustment = 0;
    private final CDOMReference<Race> ref;
    private final CDOMSingleRef<CompanionList> list;

    public FollowerOption(CDOMReference<Race> cDOMReference, CDOMSingleRef<CompanionList> cDOMSingleRef) {
        this.ref = cDOMReference;
        this.list = cDOMSingleRef;
    }

    public Race getRace() {
        Collection<Race> collection = this.ref.getContainedObjects();
        return collection.size() == 1 ? collection.iterator().next() : null;
    }

    public CDOMReference<Race> getRaceRef() {
        return this.ref;
    }

    public void setAdjustment(int n) {
        this.theAdjustment = n;
    }

    public int getAdjustment() {
        return this.theAdjustment;
    }

    @Override
    public boolean qualifies(PlayerCharacter playerCharacter) {
        int n;
        if (this.theAdjustment != 0 && (n = playerCharacter.getEffectiveCompanionLevel(this.list.resolvesTo())) + this.theAdjustment <= 0) {
            return false;
        }
        return super.qualifies(playerCharacter);
    }

    @Override
    public int compareTo(FollowerOption followerOption) {
        return ReferenceUtilities.compareRefs(this.ref, followerOption.ref);
    }

    public CDOMSingleRef<CompanionList> getListRef() {
        return this.list;
    }

    public Collection<FollowerOption> getExpandedOptions() {
        ArrayList<FollowerOption> arrayList = new ArrayList<FollowerOption>();
        if (this.ref.getObjectCount() == 1) {
            arrayList.add(this);
            return arrayList;
        }
        for (Race race : this.ref.getContainedObjects()) {
            FollowerOption followerOption = new FollowerOption(CDOMDirectSingleRef.getRef(race), this.list);
            followerOption.setAdjustment(this.getAdjustment());
            followerOption.addAllPrerequisites(this.getPrerequisiteList());
            arrayList.add(followerOption);
        }
        return arrayList;
    }
}

