/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.io.Serializable;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.ClassSpellList;
import pcgen.cdom.list.DomainSpellList;
import pcgen.core.Ability;
import pcgen.core.AssociationStore;
import pcgen.core.Campaign;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;
import pcgen.core.chooser.ChooserUtilities;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.KeyedListContainer;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.output.prereq.PrerequisiteWriter;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PObject
extends CDOMObject
implements Cloneable,
Serializable,
Comparable<Object>,
KeyedListContainer {
    private static final long serialVersionUID = 1L;
    private static boolean dontRecurse = false;
    private String displayName = "";
    private URI sourceURI = null;
    private final Class<?> myClass = this.getClass();

    public List<BonusObj> getTempBonusList() {
        return this.getSafeListFor(ListKey.TEMP_BONUS);
    }

    public final void addSave(String string) {
        this.addToListFor(ListKey.SAVE, string);
    }

    public final void addSelectedWeaponProfBonus(String string) {
        this.addToListFor(ListKey.SELECTED_WEAPON_PROF_BONUS, string);
    }

    public void addTempBonus(BonusObj bonusObj) {
        this.addToListFor(ListKey.TEMP_BONUS, bonusObj);
    }

    public void removeTempBonus(BonusObj bonusObj) {
        this.removeFromListFor(ListKey.TEMP_BONUS, bonusObj);
    }

    @Override
    public PObject clone() throws CloneNotSupportedException {
        PObject pObject = (PObject)super.clone();
        pObject.setName(this.displayName);
        pObject.put(StringKey.KEY_NAME, this.get(StringKey.KEY_NAME));
        return pObject;
    }

    @Override
    public int compareTo(Object object) {
        if (object != null) {
            return this.getKeyName().compareToIgnoreCase(((PObject)object).getKeyName());
        }
        return 1;
    }

    public boolean equals(Object object) {
        String string;
        String string2;
        if (object == null) {
            return false;
        }
        if (object instanceof PObject) {
            string2 = this.getKeyName();
            string = ((PObject)object).getKeyName();
        } else {
            string2 = this.toString();
            string = object.toString();
        }
        return string2.equalsIgnoreCase(string);
    }

    public final void getChoices(String string, PlayerCharacter playerCharacter) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        ChooserUtilities.getChoices(this, string, arrayList, arrayList2, playerCharacter);
    }

    @Override
    public void setName(String string) {
        if (!string.endsWith(".MOD")) {
            this.fireNameChanged(this.displayName, string);
            this.displayName = string;
            this.put(StringKey.KEY_NAME, string);
        }
    }

    public void setDisplayName(String string) {
        this.displayName = string;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    public final String getOutputName() {
        String string = this.get(StringKey.OUTPUT_NAME);
        if (string == null) {
            return this.displayName;
        }
        if (string.equalsIgnoreCase("[BASE]") && this.displayName.indexOf(40) != -1) {
            string = this.displayName.substring(0, this.displayName.indexOf(40)).trim();
        }
        if (string.indexOf("[NAME]") >= 0) {
            string = string.replaceAll("\\[NAME\\]", this.getPreFormatedOutputName());
        }
        return string;
    }

    public final void setSourceURI(URI uRI) {
        this.sourceURI = uRI;
    }

    public final URI getSourceURI() {
        return this.sourceURI;
    }

    public String getDefaultSourceString() {
        return SourceFormat.getFormattedString(this, Globals.getSourceDisplay(), true);
    }

    public String getType() {
        return StringUtil.join(this.getTrueTypeList(false), ".");
    }

    public List<Type> getTrueTypeList(boolean bl) {
        List<Type> list = this.getSafeListFor(ListKey.TYPE);
        if (bl) {
            Iterator<Type> iterator = list.iterator();
            while (iterator.hasNext()) {
                if (!SettingsHandler.getGame().isTypeHidden(this.myClass, iterator.next().toString())) continue;
                iterator.remove();
            }
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public boolean isType(String string) {
        if (string.length() == 0) {
            return false;
        }
        String string2 = string.charAt(0) == '!' ? string.substring(1).toUpperCase() : (string.startsWith("TYPE=") || string.startsWith("TYPE.") ? string.substring(5).toUpperCase() : string.toUpperCase());
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (this.containsInList(ListKey.TYPE, Type.getConstant(stringTokenizer.nextToken()))) continue;
            return false;
        }
        return true;
    }

    public final void removeSave(String string) {
        boolean bl = this.removeFromListFor(ListKey.SAVE, string);
        if (!bl) {
            Logging.errorPrint("removeSave: Could not find: " + string + " in saveList.");
        }
    }

    public void resetTempBonusList() {
        this.removeListFor(ListKey.TEMP_BONUS);
    }

    public void setSourceCampaign(Campaign campaign) {
        this.put(ObjectKey.SOURCE_CAMPAIGN, campaign);
    }

    public Campaign getSourceCampaign() {
        return this.get(ObjectKey.SOURCE_CAMPAIGN);
    }

    public String toString() {
        return this.displayName;
    }

    public String getPCCText() {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(this.getDisplayName());
        stringBuffer.append("\t");
        stringBuffer.append((CharSequence)StringUtil.joinToStringBuffer(Globals.getContext().unparse(this), "\t"));
        stringBuffer.append("\t");
        stringBuffer.append(this.getPCCText(false));
        return stringBuffer.toString();
    }

    protected String getPCCText(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(200);
        if (bl) {
            stringBuffer.append(this.getDisplayName());
        }
        if (this.hasPrerequisites()) {
            StringWriter stringWriter = new StringWriter();
            for (Prerequisite prerequisite : this.getPrerequisiteList()) {
                PrerequisiteWriter prerequisiteWriter = new PrerequisiteWriter();
                try {
                    stringWriter.write("\t");
                    prerequisiteWriter.write(stringWriter, prerequisite);
                }
                catch (PersistenceLayerException persistenceLayerException) {
                    persistenceLayerException.printStackTrace();
                }
            }
            stringBuffer.append(stringWriter);
        }
        return stringBuffer.toString();
    }

    public List<SpecialAbility> addSpecialAbilitiesToList(List<SpecialAbility> list, PlayerCharacter playerCharacter) {
        for (SpecialAbility specialAbility : this.getSafeListFor(ListKey.SPECIAL_ABILITY)) {
            if (!specialAbility.pcQualifiesFor(playerCharacter)) continue;
            String string = specialAbility.getKeyName();
            int n = string.indexOf("%CHOICE");
            if (n >= 0) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string.substring(0, n));
                if (playerCharacter.hasAssociations(this)) {
                    stringBuilder.append((CharSequence)StringUtil.joinToStringBuffer(playerCharacter.getAssociationList(this), ", "));
                } else {
                    stringBuilder.append("<undefined>");
                }
                stringBuilder.append(string.substring(n + 7));
                specialAbility = new SpecialAbility(stringBuilder.toString(), specialAbility.getSASource(), specialAbility.getSADesc());
            }
            list.add(specialAbility);
        }
        return list;
    }

    public void globalChecks(PlayerCharacter playerCharacter) {
        this.globalChecks(false, playerCharacter);
    }

    protected void globalChecks(boolean bl, PlayerCharacter playerCharacter) {
        playerCharacter.setDirty(true);
        for (TransitionChoice<Kit> object : this.getSafeListFor(ListKey.KIT_CHOICE)) {
            object.act(object.driveChoice(playerCharacter), this, playerCharacter);
        }
        TransitionChoice<Region> transitionChoice = this.get(ObjectKey.REGION_CHOICE);
        if (transitionChoice != null) {
            transitionChoice.act(transitionChoice.driveChoice(playerCharacter), this, playerCharacter);
        }
        if (bl) {
            this.getChoices(this.getSafe(StringKey.CHOICE_STRING), playerCharacter);
        }
        if (this instanceof PCClass) {
            PCClass pCClass = (PCClass)this;
            PCClassLevel pCClassLevel = pCClass.getClassLevel(pCClass.level);
            pCClassLevel.addAdds(playerCharacter);
            pCClassLevel.checkRemovals(playerCharacter);
        } else {
            this.addAdds(playerCharacter);
            this.checkRemovals(playerCharacter);
        }
        this.activateBonuses(playerCharacter);
    }

    void fireNameChanged(String string, String string2) {
    }

    int numberInList(PlayerCharacter playerCharacter, String string) {
        return 0;
    }

    private String getPreFormatedOutputName() {
        if (this.displayName.indexOf(40) < 0 || this.displayName.indexOf(41) < 0) {
            return this.displayName;
        }
        String string = this.displayName.substring(this.displayName.indexOf(40) + 1, this.displayName.lastIndexOf(41));
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        StringBuilder stringBuilder = new StringBuilder();
        while (stringTokenizer.hasMoreTokens()) {
            stringBuilder.insert(0, stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuilder.insert(0, " ");
        }
        return stringBuilder.toString();
    }

    public void clearSelectedWeaponProfBonus() {
        this.removeListFor(ListKey.SELECTED_WEAPON_PROF_BONUS);
    }

    public List<BonusObj> getRawBonusList(PlayerCharacter playerCharacter) {
        List<BonusObj> list;
        List<BonusObj> list2 = this.getSafeListFor(ListKey.BONUS);
        if (playerCharacter != null && (list = playerCharacter.getAssocList(this, AssociationListKey.BONUS)) != null) {
            list2.addAll(list);
        }
        return list2;
    }

    public List<BonusObj> getBonusListOfType(AssociationStore associationStore, String string, String string2) {
        return BonusUtilities.getBonusFromList(this.getBonusList(associationStore), string, string2);
    }

    public double bonusTo(String string, String string2, AssociationStore associationStore, PlayerCharacter playerCharacter) {
        return this.bonusTo(string, string2, associationStore, this.getBonusList(associationStore), playerCharacter);
    }

    public double bonusTo(String string, String string2, Object object, List<BonusObj> list, PlayerCharacter playerCharacter) {
        int n;
        if (list == null || list.size() == 0) {
            return 0.0;
        }
        double d = 0.0;
        string = string.toUpperCase();
        string2 = string2.toUpperCase();
        String string3 = new StringBuffer(string).append('.').append(string2).append('.').toString();
        if (!dontRecurse && this instanceof Ability && !Globals.checkRule("FEATPRE")) {
            dontRecurse = true;
            n = 0;
            if (!PrereqHandler.passesAll(this.getPrerequisiteList(), playerCharacter, this)) {
                n = 1;
            }
            dontRecurse = false;
            if (n != 0) {
                return 0.0;
            }
        }
        n = 1;
        if (playerCharacter != null && "VAR".equals(string)) {
            n = Math.max(1, playerCharacter.getDetailedAssociationCount(this));
            String string4 = this.getSafe(StringKey.CHOICE_STRING);
            if (string4.startsWith("SALIST|") && string4.indexOf("|VAR|") >= 0) {
                n = 1;
            }
        }
        for (BonusObj bonusObj : list) {
            String string5 = bonusObj.toString().toUpperCase();
            if (playerCharacter != null && playerCharacter.hasAssociations(this)) {
                int n2 = 4;
                int n3 = string5.indexOf("%VAR");
                if (n3 == -1) {
                    n3 = string5.indexOf("%LIST|");
                    n2 = 5;
                }
                if (n3 < 0) continue;
                String string6 = string5.substring(0, n3);
                String string7 = string5.substring(n3 + n2);
                for (String string8 : playerCharacter.getAssociationList(this)) {
                    String string9 = new StringBuffer().append(string6).append(string8).append(string7).toString().toUpperCase();
                    d += this.calcBonus(string9, string, string2, string3, object, n, bonusObj, playerCharacter);
                }
                continue;
            }
            d += this.calcBonus(string5, string, string2, string3, object, n, bonusObj, playerCharacter);
        }
        return d;
    }

    public List<BonusObj> getActiveBonuses(PlayerCharacter playerCharacter) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            if (!bonusObj.isApplied()) continue;
            arrayList.add(bonusObj);
        }
        return arrayList;
    }

    public boolean hasBonusWithInfo(PlayerCharacter playerCharacter, String string) {
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            if (!bonusObj.getBonusInfo().equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    public void activateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            bonusObj.setApplied(false);
            if (!bonusObj.qualifies(playerCharacter) || bonusObj.getPCLevel() > playerCharacter.getTotalLevels()) continue;
            bonusObj.setApplied(true);
        }
    }

    public void deactivateBonuses(PlayerCharacter playerCharacter) {
        for (BonusObj bonusObj : this.getRawBonusList(playerCharacter)) {
            bonusObj.setApplied(false);
        }
    }

    private double calcBonus(String string, String string2, String string3, String string4, Object object, int n, BonusObj bonusObj, PlayerCharacter playerCharacter) {
        int n2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        if (stringTokenizer.countTokens() < 3) {
            Logging.errorPrint("Badly formed BONUS:" + string);
            return 0.0;
        }
        String string5 = stringTokenizer.nextToken();
        if (!string5.equalsIgnoreCase(string2) && !string5.endsWith("%LIST") || string5.endsWith("%LIST") && this.numberInList(playerCharacter, string2) == 0 || string3.equals("ALL")) {
            return 0.0;
        }
        String string6 = stringTokenizer.nextToken();
        if (!string6.equals("LIST") && !string6.equals("ALL") && string6.toUpperCase().indexOf(string3.toUpperCase()) < 0) {
            return 0.0;
        }
        if (string6.equals("ALL") && (string3.indexOf("STAT=") >= 0 || string3.indexOf("TYPE=") >= 0 || string3.indexOf("LIST") >= 0 || string3.indexOf("VAR") >= 0)) {
            return 0.0;
        }
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        double d = 0.0;
        if (object instanceof PlayerCharacter) {
            d = ((PlayerCharacter)object).getVariableValue(string5, "").doubleValue();
        } else if (object instanceof Equipment) {
            d = ((Equipment)object).getVariableValue(string5, "", playerCharacter).doubleValue();
        } else {
            try {
                d = Float.parseFloat(string5);
            }
            catch (NumberFormatException numberFormatException) {
                Logging.errorPrint("calcBonus NumberFormatException in BONUS: " + string5, numberFormatException);
            }
        }
        String string7 = bonusObj.getTypeString();
        if (object instanceof PlayerCharacter ? !bonusObj.qualifies((PlayerCharacter)object) : !PrereqHandler.passesAll(bonusObj.getPrerequisiteList(), (Equipment)object, playerCharacter)) {
            return 0.0;
        }
        double d2 = 0.0;
        if ("LIST".equalsIgnoreCase(string6) && (n2 = this.numberInList(playerCharacter, string3)) != 0) {
            d2 += d * (double)n2;
        }
        String string8 = null;
        StringTokenizer stringTokenizer2 = new StringTokenizer(string6, ",");
        if (string6.equalsIgnoreCase("LIST")) {
            stringTokenizer2.nextToken();
        } else if (string6.equalsIgnoreCase("ALL")) {
            string4 = new StringBuffer(string2).append('.').append(string3).append('.').toString();
            d2 = d;
            string8 = string7;
        }
        while (stringTokenizer2.hasMoreTokens()) {
            if (!stringTokenizer2.nextToken().equalsIgnoreCase(string3)) continue;
            d2 += d;
            string8 = string7;
        }
        if (object instanceof Equipment) {
            ((Equipment)object).setBonusStackFor(d2 * (double)n, string4 + string8);
        }
        if (string6.equals("ALL")) {
            return 0.0;
        }
        return d2 * (double)n;
    }

    public PObject getActiveEquivalent(PlayerCharacter playerCharacter) {
        return this;
    }

    public List<BonusObj> getBonusList(AssociationStore associationStore) {
        if (associationStore instanceof PlayerCharacter) {
            return this.getRawBonusList((PlayerCharacter)associationStore);
        }
        return this.getRawBonusList(null);
    }

    public List<? extends CDOMList<Spell>> getSpellLists(PlayerCharacter playerCharacter) {
        return null;
    }

    public String getVariableSource() {
        return "POBJECT|" + this.getKeyName();
    }

    public void clearSpellListInfo() {
        Collection<CDOMReference<? extends CDOMList<? extends PrereqObject>>> collection = this.getModifiedLists();
        for (CDOMReference<? extends CDOMList<? extends PrereqObject>> cDOMReference : collection) {
            if (!cDOMReference.getReferenceClass().equals(ClassSpellList.class) && !cDOMReference.getReferenceClass().equals(DomainSpellList.class)) continue;
            this.removeAllFromList(cDOMReference);
        }
    }
}

