/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.StringTokenizer;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.TextProperty;
import pcgen.core.prereq.PrereqHandler;
import pcgen.util.Logging;

public final class SpecialAbility
extends TextProperty {
    protected String saSource = "";
    private String propDesc = "";

    public SpecialAbility() {
    }

    public SpecialAbility(String string) {
        super(string);
    }

    public SpecialAbility(String string, String string2) {
        super(string);
        this.saSource = string2;
    }

    public SpecialAbility(String string, String string2, String string3) {
        super(string);
        this.saSource = string2;
        this.propDesc = string3;
    }

    public void setQualificationClass(String string, String string2) {
        if ("".equals(this.saSource)) {
            return;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(this.saSource, "|=", false);
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            String string5 = stringTokenizer.nextToken();
            if (string4.equals(string)) {
                Logging.errorPrint("Source class changed from " + string + " to " + string2 + " for " + this.getDisplayName());
                this.setSASource(string3 + "=" + string2 + "|" + string5);
            }
        }
        catch (Exception exception) {
            Logging.errorPrint("setQualificationClass:" + this.saSource, exception);
        }
    }

    public void setSADesc(String string) {
        this.setPropDesc(string);
    }

    public String getSADesc() {
        return this.getPropDesc();
    }

    public void setSASource(String string) {
        this.saSource = string;
    }

    public String getSASource() {
        return this.saSource;
    }

    public int compareTo(Object object) {
        if (object instanceof SpecialAbility) {
            SpecialAbility specialAbility = (SpecialAbility)object;
            if (this.getKeyName().equals(specialAbility.getKeyName())) {
                return this.saSource.compareToIgnoreCase(specialAbility.saSource);
            }
        }
        return this.getKeyName().compareToIgnoreCase(object.toString());
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean pcQualifiesFor(PlayerCharacter playerCharacter) {
        int n;
        if (!PrereqHandler.passesAll(this.getPrerequisiteList(), playerCharacter, null)) {
            return false;
        }
        if ("".equals(this.saSource) || this.saSource.endsWith("|0")) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(this.saSource, "|=", false);
        String string = stringTokenizer.nextToken();
        String string2 = stringTokenizer.nextToken();
        try {
            n = Integer.parseInt(stringTokenizer.nextToken());
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("pcQualifiesFor:" + this.saSource, numberFormatException);
            return false;
        }
        if ("PCCLASS".equals(string)) {
            PCClass pCClass = playerCharacter.getClassKeyed(string2);
            if (pCClass == null) {
                return false;
            }
            return pCClass.getLevel() >= n;
        }
        return playerCharacter.getTotalLevels() >= n;
    }

    public void setPropDesc(String string) {
        this.propDesc = string;
    }

    String getPropDesc() {
        return this.propDesc;
    }

    public String getText() {
        String string = this.getPropDesc() == null || "".equals(this.getPropDesc()) ? super.getText() : super.getText() + " (" + this.getPropDesc() + ")";
        return string;
    }
}

