/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import pcgen.cdom.enumeration.ListKey;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.bonus.BonusObj;
import pcgen.core.bonus.BonusUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StatList
implements Iterable<PCStat> {
    private List<PCStat> stats = new ArrayList<PCStat>();
    private PlayerCharacter ownerPC;

    public StatList(PlayerCharacter playerCharacter) {
        this.ownerPC = playerCharacter;
    }

    public int getBaseStatFor(String string) {
        Number number;
        int n = this.getIndexOfStatFor(string);
        if (n == -1) {
            return 0;
        }
        PlayerCharacter playerCharacter = this.ownerPC;
        PCStat pCStat = this.stats.get(n);
        if (!playerCharacter.hasUnlockedStat(pCStat) && (number = playerCharacter.getLockedStat(pCStat)) != null) {
            return number.intValue();
        }
        int n2 = playerCharacter.getVariableValue("BASE." + pCStat.getAbb(), "").intValue();
        if (n2 != 0) {
            return n2;
        }
        return pCStat.getBaseScore();
    }

    public List<BonusObj> getBonusListOfType(String string, String string2) {
        ArrayList<BonusObj> arrayList = new ArrayList<BonusObj>();
        for (PCStat pCStat : this.stats) {
            arrayList.addAll(BonusUtilities.getBonusFromList(pCStat.getSafeListFor(ListKey.BONUS), string, string2));
        }
        return arrayList;
    }

    public int getModForNumber(int n) {
        return this.getModForNumber(n, 1);
    }

    public int getModForNumber(int n, int n2) {
        PCStat pCStat = this.stats.get(n2);
        String string = pCStat.getStatMod();
        string = string.replaceAll(Pattern.quote("SCORE"), Integer.toString(n));
        return this.ownerPC.getVariableValue(string, "").intValue();
    }

    public int getStatModFor(String string) {
        int n = this.getIndexOfStatFor(string);
        if (n == -1) {
            return 0;
        }
        PCStat pCStat = this.stats.get(n);
        return this.ownerPC.getVariableValue(pCStat.getStatMod(), "STAT:" + pCStat.getAbb()).intValue();
    }

    public int size() {
        return this.stats.size();
    }

    public PCStat getStatAt(int n) {
        return this.stats.get(n);
    }

    @Override
    public Iterator<PCStat> iterator() {
        return this.stats.iterator();
    }

    public void clear() {
        this.stats.clear();
    }

    public void addStat(PCStat pCStat) {
        this.stats.add(pCStat);
    }

    public List<PCStat> getStatList() {
        return Collections.unmodifiableList(this.stats);
    }

    public int getTotalStatFor(String string) {
        Number number;
        int n = this.getBaseStatFor(string);
        int n2 = this.getIndexOfStatFor(string);
        if (n2 == -1) {
            return n;
        }
        PlayerCharacter playerCharacter = this.ownerPC;
        PCStat pCStat = this.stats.get(n2);
        if (!playerCharacter.hasUnlockedStat(pCStat) && (number = playerCharacter.getLockedStat(pCStat)) != null) {
            return number.intValue();
        }
        n = (int)((double)n + playerCharacter.getTotalBonusTo("STAT", pCStat.getAbb()));
        return n;
    }

    public int getIndexOfStatFor(String string) {
        if (string.startsWith("STAT")) {
            int n = Integer.parseInt(string.substring(4));
            if (n < 0 || n >= this.stats.size()) {
                return -1;
            }
            return n;
        }
        return SettingsHandler.getGame().getStatFromAbbrev(string);
    }

    public int getPartialStatFor(String string, boolean bl, boolean bl2) {
        int n = this.getBaseStatFor(string);
        int n2 = this.getIndexOfStatFor(string);
        if (n2 == -1) {
            return n;
        }
        PlayerCharacter playerCharacter = this.ownerPC;
        PCStat pCStat = this.stats.get(n2);
        Number number = playerCharacter.getLockedStat(pCStat);
        if (number != null) {
            return number.intValue();
        }
        return n += playerCharacter.getPartialStatBonusFor(pCStat.getAbb(), bl, bl2);
    }
}

