/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.analysis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import pcgen.cdom.base.AssociatedPrereqObject;
import pcgen.cdom.base.CDOMList;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.PrereqObject;
import pcgen.cdom.enumeration.AssociationKey;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SkillCost;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.cdom.list.ClassSkillList;
import pcgen.core.Ability;
import pcgen.core.CharacterDomain;
import pcgen.core.Equipment;
import pcgen.core.EquipmentModifier;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.Skill;

public final class SkillCostCalc {
    private static boolean isClassSkill(Skill skill, PCClass pCClass, PlayerCharacter playerCharacter) {
        List<CDOMReference<ClassSkillList>> list;
        List<CDOMReference<ClassSkillList>> list2;
        if (playerCharacter == null || pCClass == null) {
            return false;
        }
        String string = skill.getKeyName();
        if (SkillCostCalc.hasCSkill(playerCharacter, playerCharacter.getRace(), string)) {
            return true;
        }
        for (int i = 1; i <= pCClass.getLevel(); ++i) {
            PCClassLevel object42 = pCClass.getClassLevel(i);
            if (!SkillCostCalc.hasCSkill(playerCharacter, object42, string)) continue;
            return true;
        }
        if (pCClass.hasSkill(playerCharacter, string)) {
            return true;
        }
        if (SkillCostCalc.hasCSkill(playerCharacter, pCClass, string)) {
            return true;
        }
        if (pCClass.hasClassSkill(playerCharacter, string)) {
            return true;
        }
        if (pCClass.isMonster() && SkillCostCalc.hasMonsterClassSkill(playerCharacter, playerCharacter.getRace(), skill)) {
            return true;
        }
        for (CharacterDomain characterDomain : playerCharacter.getCharacterDomainList()) {
            if (characterDomain.getDomain() == null || !characterDomain.isFromPCClass(pCClass.getKeyName()) || !SkillCostCalc.hasCSkill(playerCharacter, characterDomain.getDomain(), string)) continue;
            return true;
        }
        if (playerCharacter.getDeity() != null && SkillCostCalc.hasCSkill(playerCharacter, playerCharacter.getDeity(), string)) {
            return true;
        }
        for (Ability ability : playerCharacter.getFullAbilitySet()) {
            if (!SkillCostCalc.hasCSkill(playerCharacter, ability, string)) continue;
            return true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            list2 = (Skill)iterator.next();
            if (!SkillCostCalc.hasCSkill(playerCharacter, (CDOMObject)((Object)list2), string)) continue;
            return true;
        }
        ArrayList<Equipment> arrayList2 = new ArrayList<Equipment>(playerCharacter.getEquipmentList());
        for (Equipment equipment : arrayList2) {
            if (!equipment.isEquipped()) continue;
            if (SkillCostCalc.hasCSkill(playerCharacter, equipment, string)) {
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                if (!SkillCostCalc.hasCSkill(playerCharacter, equipmentModifier, string)) continue;
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                if (!SkillCostCalc.hasCSkill(playerCharacter, equipmentModifier, string)) continue;
                return true;
            }
        }
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            if (!SkillCostCalc.hasCSkill(playerCharacter, pCTemplate, string)) continue;
            return true;
        }
        list2 = skill.getListFor(ListKey.PREVENTED_CLASSES);
        if (list2 != null) {
            for (Object object : list2) {
                String string2 = ((CDOMReference)object).getLSTformat();
                if (!string2.equalsIgnoreCase(pCClass.getKeyName()) && !string2.equalsIgnoreCase(pCClass.getSubClassKey())) continue;
                return false;
            }
        }
        if ((list = skill.getListFor(ListKey.CLASSES)) != null) {
            for (CDOMReference cDOMReference : list) {
                for (ClassSkillList classSkillList : pCClass.getClassSkillList(playerCharacter)) {
                    if (!cDOMReference.contains(classSkillList)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static SkillCost skillCostForPCClass(Skill skill, PCClass pCClass, PlayerCharacter playerCharacter) {
        if (SkillCostCalc.isClassSkill(skill, pCClass, playerCharacter)) {
            return SkillCost.CLASS;
        }
        if (skill.getSafe(ObjectKey.EXCLUSIVE).booleanValue() && !SkillCostCalc.isCrossClassSkill(skill, pCClass, playerCharacter)) {
            return SkillCost.EXCLUSIVE;
        }
        return SkillCost.CROSS_CLASS;
    }

    private static boolean isCrossClassSkill(Skill skill, PCClass pCClass, PlayerCharacter playerCharacter) {
        if (SkillCostCalc.isClassSkill(skill, pCClass, playerCharacter)) {
            return false;
        }
        if (playerCharacter == null || pCClass == null) {
            return false;
        }
        String string = skill.getKeyName();
        if (SkillCostCalc.hasCcSkill(playerCharacter, playerCharacter.getRace(), string)) {
            return true;
        }
        for (CharacterDomain object2 : playerCharacter.getCharacterDomainList()) {
            if (object2.getDomain() == null || !object2.isFromPCClass(pCClass.getKeyName()) || !SkillCostCalc.hasCcSkill(playerCharacter, object2.getDomain(), string)) continue;
            return true;
        }
        if (playerCharacter.getDeity() != null && SkillCostCalc.hasCcSkill(playerCharacter, playerCharacter.getDeity(), string)) {
            return true;
        }
        if (SkillCostCalc.hasCcSkill(playerCharacter, pCClass, string)) {
            return true;
        }
        for (int i = 1; i <= pCClass.getLevel(); ++i) {
            PCClassLevel pCClassLevel = pCClass.getClassLevel(i);
            if (!SkillCostCalc.hasCcSkill(playerCharacter, pCClassLevel, string)) continue;
            return true;
        }
        if (pCClass.isMonster() && SkillCostCalc.hasMonsterCCSkill(playerCharacter.getRace(), skill)) {
            return true;
        }
        for (Ability ability : playerCharacter.getFullAbilitySet()) {
            if (!SkillCostCalc.hasCcSkill(playerCharacter, ability, string)) continue;
            return true;
        }
        ArrayList<Skill> arrayList = new ArrayList<Skill>(playerCharacter.getSkillList());
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Skill skill2 = (Skill)iterator.next();
            if (!SkillCostCalc.hasCcSkill(playerCharacter, skill2, string)) continue;
            return true;
        }
        for (Equipment equipment : playerCharacter.getEquipmentList()) {
            if (!equipment.isEquipped()) continue;
            if (SkillCostCalc.hasCcSkill(playerCharacter, equipment, string)) {
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(true)) {
                if (!SkillCostCalc.hasCcSkill(playerCharacter, equipmentModifier, string)) continue;
                return true;
            }
            for (EquipmentModifier equipmentModifier : equipment.getEqModifierList(false)) {
                if (!SkillCostCalc.hasCcSkill(playerCharacter, equipmentModifier, string)) continue;
                return true;
            }
        }
        for (PCTemplate pCTemplate : playerCharacter.getTemplateList()) {
            if (!SkillCostCalc.hasCcSkill(playerCharacter, pCTemplate, string)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasMonsterCCSkill(Race race, Skill skill) {
        CDOMReference<ClassSkillList> cDOMReference = PCClass.MONSTER_SKILL_LIST;
        Collection collection = race.getListMods(cDOMReference);
        if (collection == null) {
            return false;
        }
        for (CDOMReference cDOMReference2 : collection) {
            for (AssociatedPrereqObject associatedPrereqObject : race.getListAssociations(cDOMReference, cDOMReference2)) {
                if (!SkillCost.CROSS_CLASS.equals((Object)associatedPrereqObject.getAssociation(AssociationKey.SKILL_COST)) || !cDOMReference2.contains(skill)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasMonsterClassSkill(PlayerCharacter playerCharacter, Race race, Skill skill) {
        Object object;
        Object object2;
        List<Skill> list = playerCharacter.getAssocList(race, AssociationListKey.MONCSKILL);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (Skill)object2.next();
                if (!((CDOMObject)object).getKeyName().equals(skill.getKeyName())) continue;
                return true;
            }
        }
        if ((object = race.getListMods(object2 = PCClass.MONSTER_SKILL_LIST)) == null) {
            return false;
        }
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            CDOMReference cDOMReference = iterator.next();
            for (AssociatedPrereqObject associatedPrereqObject : race.getListAssociations((CDOMReference<? extends CDOMList<? extends PrereqObject>>)object2, cDOMReference)) {
                if (!SkillCost.CLASS.equals((Object)associatedPrereqObject.getAssociation(AssociationKey.SKILL_COST)) || !cDOMReference.contains(skill)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCcSkill(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        List<CDOMReference<Skill>> list = cDOMObject.getListFor(ListKey.CCSKILL);
        List<Skill> list2 = playerCharacter.getAssocList(cDOMObject, AssociationListKey.CCSKILL);
        if (list != null && !list.isEmpty()) {
            for (CDOMReference object : list) {
                for (Skill skill : object.getContainedObjects()) {
                    if (!skill.getKeyName().equals(string)) continue;
                    return true;
                }
            }
        }
        if (list2 != null && !list2.isEmpty()) {
            for (Skill skill : list2) {
                if (!skill.getKeyName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasCSkill(PlayerCharacter playerCharacter, CDOMObject cDOMObject, String string) {
        Object object;
        Object object2;
        List<CDOMReference<Skill>> list = cDOMObject.getListFor(ListKey.CSKILL);
        if (list != null) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (CDOMReference)object2.next();
                for (Skill skill : ((CDOMReference)object).getContainedObjects()) {
                    if (!skill.getKeyName().equals(string)) continue;
                    return true;
                }
            }
        }
        if ((object2 = playerCharacter.getAssocList(cDOMObject, AssociationListKey.CSKILL)) != null) {
            object = object2.iterator();
            while (object.hasNext()) {
                Skill skill = (Skill)object.next();
                if (!skill.getKeyName().equals(string)) continue;
                return true;
            }
        }
        return false;
    }
}

