/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.character;

import java.util.ArrayList;
import java.util.List;
import pcgen.core.Ability;
import pcgen.core.Domain;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharacterSpell
implements Comparable<CharacterSpell> {
    private final List<SpellInfo> infoList = new ArrayList<SpellInfo>();
    private final PObject owner;
    private final Spell spell;
    private String fixedCasterLevel = null;
    private String fixedDC = null;

    public CharacterSpell(PObject pObject, Spell spell) {
        this.owner = pObject;
        this.spell = spell;
    }

    public int getInfoIndexFor(String string, int n, int n2) {
        boolean bl;
        if (this.infoList.isEmpty()) {
            return -1;
        }
        boolean bl2 = bl = n2 == 1;
        if (bl) {
            bl = this.isSpecialtySpell();
        }
        int n3 = 0;
        for (SpellInfo spellInfo : this.infoList) {
            if (!(!"".equals(string) && !string.equals(spellInfo.getBook()) || n != -1 && spellInfo.getActualLevel() != n || n2 != -1 && !bl)) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public List<SpellInfo> getInfoList() {
        return this.infoList;
    }

    public PObject getOwner() {
        return this.owner;
    }

    public boolean isSpecialtySpell() {
        boolean bl;
        if (this.spell == null) {
            bl = false;
        } else if (this.owner instanceof Domain) {
            bl = true;
        } else if (this.owner instanceof PCClass) {
            PCClass pCClass = (PCClass)this.owner;
            bl = pCClass.isSpecialtySpell(this.spell);
        } else {
            bl = false;
        }
        return bl;
    }

    public Spell getSpell() {
        return this.spell;
    }

    public SpellInfo getSpellInfoFor(String string, int n, int n2) {
        return this.getSpellInfoFor(string, n, n2, null);
    }

    public SpellInfo getSpellInfoFor(String string, int n, int n2, List<Ability> list) {
        boolean bl;
        if (this.infoList.isEmpty()) {
            return null;
        }
        boolean bl2 = bl = n2 == 1;
        if (bl) {
            bl = this.isSpecialtySpell();
        }
        for (SpellInfo spellInfo : this.infoList) {
            if (!"".equals(string) && !string.equals(spellInfo.getBook()) || n != -1 && spellInfo.getActualLevel() != n || n2 != -1 && !bl || list != null && (!list.isEmpty() || spellInfo.getFeatList() != null && !spellInfo.getFeatList().isEmpty()) && (spellInfo.getFeatList() == null || !list.toString().equals(spellInfo.getFeatList().toString()))) continue;
            return spellInfo;
        }
        return null;
    }

    public SpellInfo addInfo(int n, int n2, String string) {
        return this.addInfo(n, n2, string, null);
    }

    public SpellInfo addInfo(int n, int n2, String string, List<Ability> list) {
        SpellInfo spellInfo = new SpellInfo(this, n, n2, string);
        if (list != null) {
            spellInfo.addFeatsToList(list);
        }
        this.infoList.add(spellInfo);
        return spellInfo;
    }

    @Override
    public int compareTo(CharacterSpell characterSpell) {
        return this.spell.compareTo(characterSpell.spell);
    }

    public boolean equals(Object object) {
        return object != null && object instanceof CharacterSpell && ((CharacterSpell)object).getName().equals(this.getName());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public void removeSpellInfo(SpellInfo spellInfo) {
        if (spellInfo != null) {
            this.infoList.remove(spellInfo);
        }
    }

    public String toString() {
        String string = this.spell == null ? "" : this.spell.getDisplayName();
        return string;
    }

    private String getName() {
        StringBuffer stringBuffer = new StringBuffer(this.owner.toString());
        if (this.spell != null) {
            stringBuffer.append(':').append(this.spell.getDisplayName());
        }
        return stringBuffer.toString();
    }

    public String getFixedCasterLevel() {
        return this.fixedCasterLevel;
    }

    public void setFixedCasterLevel(String string) {
        this.fixedCasterLevel = string;
    }

    public String getFixedDC() {
        return this.fixedDC;
    }

    public void setFixedDC(String string) {
        this.fixedDC = string;
    }
}

