/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.chooser;

import java.util.List;
import java.util.StringTokenizer;
import pcgen.cdom.enumeration.AssociationListKey;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.core.chooser.AbstractBasicStringChoiceManager;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkillListChoiceManager
extends AbstractBasicStringChoiceManager {
    public SkillListChoiceManager(PObject pObject, String string, PlayerCharacter playerCharacter) {
        super(pObject, string, playerCharacter);
        this.setTitle("Skill Choice");
        List<String> list = this.getChoiceList();
        if (list == null || list.size() > 1) {
            throw new IllegalArgumentException("Choice List for SkillListChoiceManager must be 1 item");
        }
    }

    @Override
    public void getChoices(PlayerCharacter playerCharacter, List<String> list, List<String> list2) {
        String string = this.getChoiceList().get(0);
        if (string.length() > 0 && !"LIST".equals(string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                list.add(stringTokenizer.nextToken());
            }
        } else {
            for (Skill skill : Globals.getObjectsOfVisibility(Globals.getContext().ref.getConstructedCDOMObjects(Skill.class), Visibility.DISPLAY_ONLY)) {
                list.add(skill.getKeyName());
            }
        }
        list2.addAll(playerCharacter.getAssociationList(this.pobject));
        this.setPreChooserChoices(list2.size());
    }

    @Override
    protected void associateChoice(PlayerCharacter playerCharacter, String string) {
        super.associateChoice(playerCharacter, string);
        Skill skill = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Skill.class, string);
        playerCharacter.addAssoc(this.pobject, AssociationListKey.CSKILL, skill);
    }

    @Override
    protected void cleanUpAssociated(PlayerCharacter playerCharacter) {
        playerCharacter.removeAllAssocs(this.pobject, AssociationListKey.CSKILL);
        super.cleanUpAssociated(playerCharacter);
    }
}

