/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.base.util.NamedFormula;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.helper.EqModRef;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.Kit;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SizeAdjustment;
import pcgen.core.character.EquipSet;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KitGear
extends BaseKit {
    private Formula quantity;
    private Integer maxCost;
    private CDOMReference<Equipment> equip;
    private List<EqModRef> mods;
    private String theLocationStr = null;
    private Boolean sizeToPC;
    private SizeAdjustment size;
    private transient Formula actingQuantity;
    private transient Integer actingCost;
    private transient List<EqModRef> actingMods;
    private transient String actingLocation;
    private transient SizeAdjustment actingSize;
    private transient Equipment theEquipment = null;
    private transient int theQty = 0;
    private transient String theLocation = "";
    private transient BigDecimal theCost = BigDecimal.ZERO;
    private List<NamedFormula> lookupList;

    public void setLocation(String string) {
        this.theLocationStr = string;
    }

    public String getLocation() {
        return this.theLocationStr;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        if (this.quantity != null) {
            stringBuilder.append(this.quantity).append('x');
        }
        stringBuilder.append(this.equip == null ? "null" : this.equip.getLSTformat());
        if (this.mods != null) {
            stringBuilder.append(" (");
            boolean bl = false;
            for (EqModRef eqModRef : this.mods) {
                if (bl) {
                    stringBuilder.append('/');
                }
                bl = true;
                stringBuilder.append(eqModRef.getRef().getLSTformat());
                for (String string : eqModRef.getChoices()) {
                    stringBuilder.append("|").append(string);
                }
            }
            stringBuilder.append(')');
        }
        return stringBuilder.toString();
    }

    private void processLookups(Kit kit, PlayerCharacter playerCharacter) {
        Collection<NamedFormula> collection = this.getLookups();
        if (collection == null) {
            return;
        }
        for (NamedFormula namedFormula : collection) {
            KitTable kitTable = kit.getTable(namedFormula.getName());
            KitGear kitGear = kitTable.getEntry(playerCharacter, namedFormula.getFormula().resolve(playerCharacter, "").intValue());
            kitGear.processLookups(kit, playerCharacter);
            this.overlayGear(kitGear);
        }
    }

    private void overlayGear(KitGear kitGear) {
        if (kitGear.quantity != null) {
            this.actingQuantity = kitGear.quantity;
        }
        if (kitGear.maxCost != null) {
            this.actingCost = kitGear.maxCost;
        }
        if (kitGear.mods != null) {
            this.actingMods.addAll(kitGear.mods);
        }
        if (kitGear.theLocationStr != null) {
            this.actingLocation = kitGear.theLocationStr;
        }
        if (kitGear.size != null) {
            this.actingSize = kitGear.size;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        PObject pObject;
        Comparable<StringBuilder> bl2;
        Object object2;
        Serializable serializable;
        this.actingQuantity = this.quantity;
        this.actingCost = this.maxCost;
        this.actingMods = this.mods == null ? null : new ArrayList<EqModRef>(this.mods);
        this.actingLocation = this.theLocationStr;
        this.actingSize = this.size;
        this.theEquipment = null;
        this.theQty = 0;
        this.theLocation = "";
        this.theCost = BigDecimal.ZERO;
        this.processLookups(kit, playerCharacter);
        int n = kit.getBuyRate(playerCharacter);
        BigDecimal bigDecimal = playerCharacter.getGold();
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>(this.equip.getContainedObjects());
        if (this.actingCost != null) {
            serializable = new BigDecimal(Integer.toString(this.actingCost));
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                if (((Equipment)object2.next()).getCost(playerCharacter).compareTo((BigDecimal)serializable) <= 0) continue;
                object2.remove();
            }
        }
        if (arrayList.size() == 1) {
            this.theEquipment = (Equipment)arrayList.get(0);
        } else {
            serializable = new ArrayList(1);
            Globals.getChoiceFromList("Choose equipment", arrayList, serializable, 1);
            if (serializable.size() == 1) {
                this.theEquipment = (Equipment)serializable.get(0);
            }
        }
        this.theEquipment = this.theEquipment.clone();
        boolean bl = false;
        object2 = SettingsHandler.getGame().getSizeAdjustmentAtIndex(playerCharacter.sizeInt());
        if (this.actingSize == null) {
            if (this.theEquipment.isType("Natural") || this.sizeToPC != null && this.sizeToPC.booleanValue() || !this.theEquipment.isWeapon() && !this.theEquipment.isAmmunition()) {
                bl = Globals.canResizeHaveEffect(playerCharacter, this.theEquipment, null);
            }
        } else if (this.sizeToPC != null && this.sizeToPC.booleanValue()) {
            bl = Globals.canResizeHaveEffect(playerCharacter, this.theEquipment, null);
        } else {
            object2 = this.actingSize;
            bl = true;
        }
        if (bl) {
            this.theEquipment.resizeItem(playerCharacter, (SizeAdjustment)object2);
        } else {
            this.theEquipment.resizeItem(playerCharacter, this.theEquipment.getSafe(ObjectKey.SIZE));
        }
        if (this.actingMods != null) {
            for (EqModRef object3 : this.actingMods) {
                bl2 = new StringBuilder();
                pObject = object3.getRef().resolvesTo();
                ((StringBuilder)bl2).append(pObject.getKeyName());
                for (String string : object3.getChoices()) {
                    ((StringBuilder)bl2).append("|").append(KitGear.eval(playerCharacter, string));
                }
                this.theEquipment.addEqModifiers(((StringBuilder)bl2).toString(), true);
            }
        }
        if (bl || this.actingMods != null) {
            this.theEquipment.nameItemFromModifiers(playerCharacter);
        }
        this.theQty = this.actingQuantity == null ? 1 : this.actingQuantity.resolve(playerCharacter, "").intValue();
        int n2 = this.theQty;
        BigDecimal bigDecimal2 = this.theEquipment.getCost(playerCharacter);
        if (n != 0) {
            bl2 = new BigDecimal(Integer.toString(n)).multiply(new BigDecimal("0.01"));
            this.theCost = bigDecimal2.multiply(new BigDecimal(Integer.toString(this.theQty))).multiply((BigDecimal)bl2);
            while (this.theQty > 0 && this.theCost.compareTo(bigDecimal) > 0) {
                this.theCost = bigDecimal2.multiply(new BigDecimal(Integer.toString(--this.theQty))).multiply((BigDecimal)bl2);
            }
            playerCharacter.setGold(playerCharacter.getGold().subtract(this.theCost).toString());
        }
        boolean bl3 = false;
        if (this.theQty != n2) {
            bl3 = true;
        }
        if (bl3) {
            list.add("GEAR: Could not purchase " + (n2 - this.theQty) + " " + this.theEquipment.getName() + ". Not enough funds.");
        }
        if (this.theQty == 0) {
            return false;
        }
        pObject = this.theEquipment.clone();
        ((Equipment)pObject).setQty(new Float(this.theQty));
        playerCharacter.addEquipment((Equipment)pObject);
        Object object = null;
        if (this.actingLocation != null) {
            void var14_23;
            EquipSet equipSet;
            void var14_21;
            this.theLocation = this.actingLocation;
            if (!this.theLocation.equalsIgnoreCase("DEFAULT") && !this.theLocation.equalsIgnoreCase("Equipped")) {
                object = playerCharacter.getEquipmentNamed(this.theLocation);
            } else if (this.theLocation.equalsIgnoreCase("DEFAULT")) {
                this.theLocation = "";
            }
            Object var14_19 = null;
            if (object != null) {
                EquipSet equipSet2 = playerCharacter.getEquipSetForItem(playerCharacter.getEquipSetByIdPath("0.1"), (Equipment)object);
            }
            if (var14_21 == null) {
                EquipSet equipSet3 = playerCharacter.getEquipSetByIdPath("0.1");
            }
            if ((equipSet = playerCharacter.addEquipToTarget((EquipSet)var14_23, (Equipment)object, this.theLocation, (Equipment)pObject, new Float(-1.0f))) == null) {
                list.add("GEAR: Could not equip " + ((Equipment)pObject).getName() + " to " + this.theLocation);
            }
        }
        return true;
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        Equipment equipment = playerCharacter.getEquipmentNamed(this.theEquipment.getName());
        if (equipment == null) {
            this.theEquipment.setQty(new Float(this.theQty));
            playerCharacter.addEquipment(this.theEquipment);
            Globals.getContext().ref.importObject(this.theEquipment);
        } else {
            equipment.setQty(equipment.qty() + (double)this.theQty);
        }
        Equipment equipment2 = null;
        if (this.theLocation.length() != 0 && !this.theLocation.equalsIgnoreCase("Equipped")) {
            equipment2 = playerCharacter.getEquipmentNamed(this.theLocation);
        }
        EquipSet equipSet = equipment2 == null ? playerCharacter.getEquipSetByIdPath("0.1") : playerCharacter.getEquipSetForItem(playerCharacter.getEquipSetByIdPath("0.1"), equipment2);
        playerCharacter.addEquipToTarget(equipSet, equipment2, this.theLocation, this.theEquipment, new Float(this.theQty));
        playerCharacter.setGold(playerCharacter.getGold().subtract(this.theCost).toString());
    }

    @Override
    public String getObjectName() {
        return "Gear";
    }

    public void setQuantity(Formula formula) {
        this.quantity = formula;
    }

    public Formula getQuantity() {
        return this.quantity;
    }

    public void setMaxCost(Integer n) {
        this.maxCost = n;
    }

    public Integer getMaxCost() {
        return this.maxCost;
    }

    public void setEquipment(CDOMReference<Equipment> cDOMReference) {
        this.equip = cDOMReference;
    }

    public CDOMReference<Equipment> getEquipment() {
        return this.equip;
    }

    public void setSizeToPC(Boolean bl) {
        this.sizeToPC = bl;
    }

    public Boolean getSizeToPC() {
        return this.sizeToPC;
    }

    public void setSize(SizeAdjustment sizeAdjustment) {
        this.size = sizeAdjustment;
    }

    public SizeAdjustment getSize() {
        return this.size;
    }

    public void loadLookup(String string, Formula formula) {
        if (this.lookupList == null) {
            this.lookupList = new LinkedList<NamedFormula>();
        }
        this.lookupList.add(new NamedFormula(string, formula));
    }

    public Collection<NamedFormula> getLookups() {
        return this.lookupList;
    }

    public void addModRef(EqModRef eqModRef) {
        if (this.mods == null) {
            this.mods = new LinkedList<EqModRef>();
        }
        this.mods.add(eqModRef);
    }

    public boolean hasEqMods() {
        return this.mods != null && !this.mods.isEmpty();
    }

    public List<EqModRef> getEqMods() {
        return Collections.unmodifiableList(this.mods);
    }
}

