/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.kit;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pcgen.base.formula.Formula;
import pcgen.core.Kit;
import pcgen.core.PlayerCharacter;
import pcgen.core.kit.BaseKit;
import pcgen.core.kit.KitGear;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KitTable
extends BaseKit {
    private String tableName;
    private List<TableEntry> list = new ArrayList<TableEntry>();

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void addGear(KitGear kitGear, Formula formula, Formula formula2) {
        this.list.add(new TableEntry(kitGear, formula, formula2));
    }

    public List<TableEntry> getList() {
        return Collections.unmodifiableList(this.list);
    }

    @Override
    public void apply(PlayerCharacter playerCharacter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getObjectName() {
        return "Table";
    }

    @Override
    public boolean testApply(Kit kit, PlayerCharacter playerCharacter, List<String> list) {
        throw new UnsupportedOperationException();
    }

    public KitGear getEntry(PlayerCharacter playerCharacter, int n) {
        for (TableEntry tableEntry : this.list) {
            if (!tableEntry.isIn(playerCharacter, n)) continue;
            return tableEntry.gear;
        }
        return null;
    }

    public static class TableEntry {
        public final KitGear gear;
        public final Formula lowRange;
        public final Formula highRange;

        public TableEntry(KitGear kitGear, Formula formula, Formula formula2) {
            this.gear = kitGear;
            this.lowRange = formula;
            this.highRange = formula2;
        }

        public boolean isIn(PlayerCharacter playerCharacter, int n) {
            int n2 = this.lowRange.resolve(playerCharacter, "").intValue();
            int n3 = this.highRange.resolve(playerCharacter, "").intValue();
            return n >= n2 && n <= n3;
        }
    }
}

