/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Ability;
import pcgen.core.AbilityCategory;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.npcgen.SkillChoice;
import pcgen.core.spell.Spell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassData {
    private PCClass theClass = null;
    private WeightedCollection<String> theStatWeights = null;
    private WeightedCollection<SkillChoice> theSkillWeights = null;
    private Map<AbilityCategory, WeightedCollection<Ability>> theAbilityWeights = null;
    private WeightedCollection<Deity> theDeityWeights = null;
    private Map<String, WeightedCollection<Domain>> theDomainWeights = null;
    private Map<Integer, WeightedCollection<Spell>> theKnownSpellWeights = null;
    private Map<Integer, WeightedCollection<Spell>> thePreparedSpellWeights = null;
    private WeightedCollection<String> theSubClassWeights = null;

    public ClassData(PCClass pCClass) {
        this.theClass = pCClass;
    }

    public PCClass getPCClass() {
        return this.theClass;
    }

    public void addStat(String string, int n) {
        if (this.theStatWeights == null) {
            this.theStatWeights = new WeightedCollection();
        }
        this.theStatWeights.add(string, n);
    }

    public WeightedCollection<String> getStatWeights() {
        List<PCStat> list = SettingsHandler.getGame().getUnmodifiableStatList();
        for (PCStat pCStat : list) {
            if (this.theStatWeights != null && this.theStatWeights.contains(pCStat.getAbb())) continue;
            this.addStat(pCStat.getAbb(), 1);
        }
        return this.theStatWeights;
    }

    public void addSkill(String string, int n) {
        if (this.theSkillWeights == null) {
            this.theSkillWeights = new WeightedCollection();
        }
        for (SkillChoice skillChoice : this.theSkillWeights) {
            if (!skillChoice.hasSkill(string)) continue;
            return;
        }
        this.theSkillWeights.add(new SkillChoice(string), n);
    }

    public void removeSkill(String string) {
        if (this.theSkillWeights == null) {
            return;
        }
        this.theSkillWeights.remove(new SkillChoice(string));
    }

    public WeightedCollection<SkillChoice> getSkillWeights() {
        return this.theSkillWeights;
    }

    public void addAbility(AbilityCategory abilityCategory, Ability ability, int n) {
        WeightedCollection<Ability> weightedCollection;
        if (this.theAbilityWeights == null) {
            this.theAbilityWeights = new HashMap<AbilityCategory, WeightedCollection<Ability>>();
        }
        if ((weightedCollection = this.theAbilityWeights.get(abilityCategory)) == null) {
            weightedCollection = new WeightedCollection();
            this.theAbilityWeights.put(abilityCategory, weightedCollection);
        }
        if (!weightedCollection.contains(ability)) {
            weightedCollection.add(ability, n);
        }
    }

    public void removeAbility(AbilityCategory abilityCategory, Ability ability) {
        if (this.theAbilityWeights == null) {
            return;
        }
        WeightedCollection<Ability> weightedCollection = this.theAbilityWeights.get(abilityCategory);
        if (weightedCollection == null) {
            return;
        }
        weightedCollection.remove(ability);
    }

    public WeightedCollection<Ability> getAbilityWeights(AbilityCategory abilityCategory) {
        if (this.theAbilityWeights == null) {
            return null;
        }
        return this.theAbilityWeights.get(abilityCategory);
    }

    public void addDeity(Deity deity, int n) {
        if (this.theDeityWeights == null) {
            this.theDeityWeights = new WeightedCollection();
        }
        this.theDeityWeights.add(deity, n);
    }

    public WeightedCollection<Deity> getDeityWeights() {
        if (this.theDeityWeights == null) {
            for (Deity deity : Globals.getContext().ref.getConstructedCDOMObjects(Deity.class)) {
                this.addDeity(deity, 1);
            }
        }
        return this.theDeityWeights;
    }

    public void addDomain(String string, Domain domain, int n) {
        WeightedCollection<Domain> weightedCollection;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedCollection<Domain>>();
        }
        if ((weightedCollection = this.theDomainWeights.get(string)) == null) {
            weightedCollection = new WeightedCollection();
            this.theDomainWeights.put(string, weightedCollection);
        }
        weightedCollection.add(domain, n);
    }

    public WeightedCollection<Domain> getDomainWeights(String string) {
        WeightedCollection<Domain> weightedCollection;
        if (this.theDomainWeights == null) {
            this.theDomainWeights = new HashMap<String, WeightedCollection<Domain>>();
        }
        if ((weightedCollection = this.theDomainWeights.get(string)) == null) {
            weightedCollection = new WeightedCollection();
            Deity deity = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Deity.class, string);
            for (CDOMReference cDOMReference : deity.getSafeListMods(Deity.DOMAINLIST)) {
                weightedCollection.addAll(cDOMReference.getContainedObjects(), deity.getListAssociations(Deity.DOMAINLIST, cDOMReference).size());
            }
        }
        return weightedCollection;
    }

    public void addKnownSpell(int n, Spell spell, int n2) {
        WeightedCollection<Spell> weightedCollection;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((weightedCollection = this.theKnownSpellWeights.get(n)) == null) {
            weightedCollection = new WeightedCollection();
            this.theKnownSpellWeights.put(n, weightedCollection);
        }
        if (!weightedCollection.contains(spell)) {
            weightedCollection.add(spell, n2);
        }
    }

    public void removeKnownSpell(int n, Spell spell) {
        if (this.theKnownSpellWeights == null) {
            return;
        }
        WeightedCollection<Spell> weightedCollection = this.theKnownSpellWeights.get(n);
        if (weightedCollection != null) {
            weightedCollection.remove(spell);
        }
    }

    public WeightedCollection<Spell> getKnownSpellWeights(int n, PlayerCharacter playerCharacter) {
        WeightedCollection<Spell> weightedCollection;
        if (this.theKnownSpellWeights == null) {
            this.theKnownSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((weightedCollection = this.theKnownSpellWeights.get(n)) == null) {
            weightedCollection = new WeightedCollection();
            for (Spell spell : Globals.getSpellsIn(n, Collections.singletonList(this.theClass.get(ObjectKey.CLASS_SPELLLIST)), playerCharacter)) {
                weightedCollection.add(spell, 1);
            }
        }
        return weightedCollection;
    }

    public void addPreparedSpell(int n, Spell spell, int n2) {
        WeightedCollection<Spell> weightedCollection;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((weightedCollection = this.thePreparedSpellWeights.get(n)) == null) {
            weightedCollection = new WeightedCollection();
            this.thePreparedSpellWeights.put(n, weightedCollection);
        }
        if (!weightedCollection.contains(spell)) {
            weightedCollection.add(spell, n2);
        }
    }

    public void removePreparedSpell(int n, Spell spell) {
        if (this.thePreparedSpellWeights == null) {
            return;
        }
        WeightedCollection<Spell> weightedCollection = this.thePreparedSpellWeights.get(n);
        if (weightedCollection != null) {
            weightedCollection.remove(spell);
        }
    }

    public WeightedCollection<Spell> getPreparedSpellWeights(int n, PlayerCharacter playerCharacter) {
        WeightedCollection<Spell> weightedCollection;
        if (this.thePreparedSpellWeights == null) {
            this.thePreparedSpellWeights = new HashMap<Integer, WeightedCollection<Spell>>();
        }
        if ((weightedCollection = this.thePreparedSpellWeights.get(n)) == null) {
            weightedCollection = new WeightedCollection();
            for (Spell spell : Globals.getSpellsIn(n, Collections.singletonList(this.theClass.get(ObjectKey.CLASS_SPELLLIST)), playerCharacter)) {
                weightedCollection.add(spell, 1);
            }
        }
        return weightedCollection;
    }

    public void addSubClass(String string, int n) {
        if (this.theSubClassWeights == null) {
            this.theSubClassWeights = new WeightedCollection();
        }
        this.theSubClassWeights.add(string, n);
    }

    public WeightedCollection<String> getSubClassWeights() {
        if (this.theSubClassWeights == null && this.theClass != null) {
            for (SubClass subClass : this.theClass.getListFor(ListKey.SUB_CLASS)) {
                this.addSubClass(subClass.getKeyName(), 1);
            }
        }
        return this.theSubClassWeights;
    }
}

