/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.util.ArrayList;
import java.util.List;
import pcgen.base.util.WeightedCollection;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.core.Equipment;
import pcgen.core.Globals;
import pcgen.core.npcgen.EqmodItem;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.util.Logging;
import pcgen.util.PJEP;
import pcgen.util.PjepPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentItem {
    private Equipment theEquipment = null;
    private List<EqmodItem> theEqMods = null;
    private EquipmentTable theLookupTable = null;
    private WeightedCollection<String> theChoices = null;
    private String theVariableEquipment = null;
    private String theTimes = null;
    private String theQuantity = null;

    public List<Equipment> getEquipment() {
        ArrayList<Equipment> arrayList = new ArrayList<Equipment>();
        int n = 1;
        if (this.theTimes != null) {
            n = this.getJepValue(this.theTimes);
            Logging.debugPrint("Rolling " + n + " times");
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            if (this.theEquipment == null) {
                if (this.theLookupTable != null) {
                    Logging.debugPrint("Getting value from table: " + this.theLookupTable);
                    arrayList.addAll(this.theLookupTable.getEquipment());
                } else if (this.theChoices != null) {
                    object = this.theChoices.getRandomValue();
                    Logging.debugPrint("Selected " + (String)object + " as choice");
                    String n3 = this.theVariableEquipment.replaceFirst("%CHOICE", (String)object);
                    Logging.debugPrint("\tUsing " + n3 + " as the equipment");
                    Object object2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, n3);
                    object2 = ((Equipment)object2).clone();
                    int n2 = 1;
                    if (this.theQuantity != null) {
                        n2 = this.getJepValue(this.theQuantity);
                    }
                    ((Equipment)object2).setQty(n2);
                    arrayList.add((Equipment)object2);
                }
            } else {
                int n3;
                Logging.debugPrint("Selecting " + this.theEquipment);
                object = this.theEquipment.clone();
                boolean bl = true;
                if (this.theQuantity != null) {
                    n3 = this.getJepValue(this.theQuantity);
                    Logging.debugPrint("Adding " + n3 + " items");
                }
                ((Equipment)object).setQty(n3);
                arrayList.add((Equipment)object);
            }
            if (this.theEqMods == null) continue;
            for (Equipment equipment : arrayList) {
                for (EqmodItem eqmodItem : this.theEqMods) {
                    for (String string : eqmodItem.getEqMods()) {
                        Logging.debugPrint("Adding eqmod: " + string);
                        equipment.addEqModifiers(string, true);
                    }
                }
                equipment.resizeItem(null, equipment.getSafe(ObjectKey.SIZE));
                equipment.nameItemFromModifiers(null);
            }
        }
        return arrayList;
    }

    public void setEquipment(Equipment equipment) {
        this.theEquipment = equipment;
    }

    public void addEqMod(EqmodItem eqmodItem) {
        if (this.theEqMods == null) {
            this.theEqMods = new ArrayList<EqmodItem>();
        }
        this.theEqMods.add(eqmodItem);
    }

    public void setLookup(EquipmentTable equipmentTable) {
        this.theLookupTable = equipmentTable;
    }

    public void setVariableEquipment(String string, List<String> list) {
        this.theVariableEquipment = string;
        this.theChoices = new WeightedCollection<String>(list);
    }

    public void setTimes(String string) {
        if (string.indexOf(100) != -1) {
            this.theTimes = "roll(\"";
        }
        this.theTimes = this.theTimes + string;
        if (string.indexOf(100) != -1) {
            this.theTimes = this.theTimes + "\")";
        }
    }

    public void setQuantity(String string) {
        this.theQuantity = string;
    }

    private int getJepValue(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            PJEP pJEP = PjepPool.getInstance().aquire(this, string);
            pJEP.parseExpression(string);
            int n = 0;
            if (pJEP.hasError()) {
                Logging.errorPrint("Not a JEP expression: " + string);
            } else {
                n = (int)pJEP.getValue();
            }
            PjepPool.getInstance().release(pJEP);
            return n;
        }
    }
}

