/*
 * Decompiled with CFR 0.152.
 */
package pcgen.core.npcgen;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SystemCollections;
import pcgen.core.npcgen.EqmodItem;
import pcgen.core.npcgen.EqmodTable;
import pcgen.core.npcgen.EqmodTableEntry;
import pcgen.core.npcgen.EquipmentItem;
import pcgen.core.npcgen.EquipmentTable;
import pcgen.core.npcgen.EquipmentTableEntry;
import pcgen.core.npcgen.Table;
import pcgen.core.npcgen.TableEntry;
import pcgen.core.npcgen.TreasureGenerator;
import pcgen.util.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EquipmentTableParser {
    private SAXParser theParser;
    private GameMode theMode;
    private HashMap<EquipmentItem, String> theLinkTable = new HashMap();
    private HashMap<EqmodItem, String> theEqmodLinkTable = new HashMap();

    public EquipmentTableParser(GameMode gameMode) throws ParserConfigurationException, SAXException {
        this.theMode = gameMode;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(true);
        this.theParser = sAXParserFactory.newSAXParser();
    }

    public List<EquipmentTable> parse(File[] fileArray) throws SAXException, IOException {
        ArrayList<EquipmentTable> arrayList = new ArrayList<EquipmentTable>();
        for (File file : fileArray) {
            try {
                this.theParser.parse(file, (DefaultHandler)new EquipmentTableHandler(this.theMode, arrayList));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        for (EquipmentItem equipmentItem : this.theLinkTable.keySet()) {
            EquipmentTable equipmentTable = EquipmentTable.get(this.theLinkTable.get(equipmentItem));
            if (equipmentTable == null) {
                Logging.errorPrint("Could not find linked table " + this.theLinkTable.get(equipmentItem) + " for " + equipmentItem);
                continue;
            }
            equipmentItem.setLookup(equipmentTable);
        }
        for (EqmodItem eqmodItem : this.theEqmodLinkTable.keySet()) {
            EqmodTable eqmodTable = EqmodTable.get(this.theEqmodLinkTable.get(eqmodItem));
            if (eqmodTable == null) {
                Logging.errorPrint("Could not find linked table " + this.theEqmodLinkTable.get(eqmodItem) + " for " + eqmodItem);
                continue;
            }
            eqmodItem.setLookup(eqmodTable);
        }
        return arrayList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class EquipmentTableHandler
    extends DefaultHandler {
        private List<EquipmentTable> theList;
        private GameMode theGameMode = null;
        private boolean theValidFlag = false;
        private ParserState theState = ParserState.INIT;
        private Table theCurrentData = null;
        private TableEntry theCurrentEntry = null;
        private EquipmentItem theCurrentItem = null;

        public EquipmentTableHandler(GameMode gameMode, List<EquipmentTable> list) {
            this.theGameMode = gameMode;
            this.theList = list;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (this.theState == ParserState.INIT && "equipment_tables".equals(string3)) {
                if (attributes != null) {
                    String string4 = attributes.getValue("game_mode");
                    if (!SystemCollections.getGameModeNamed(string4).equals(this.theGameMode)) {
                        throw new IllegalArgumentException("Incorrect game mode");
                    }
                    this.theValidFlag = true;
                }
                return;
            }
            if (!this.theValidFlag) {
                throw new SAXException("Generators.Equipment.InvalidFileFormat");
            }
            if (this.theState == ParserState.INIT) {
                if ("table".equals(string3)) {
                    if (attributes != null) {
                        String string5 = attributes.getValue("name");
                        String string6 = attributes.getValue("id");
                        EquipmentTable equipmentTable = EquipmentTable.get(string6);
                        if (equipmentTable == null) {
                            equipmentTable = new EquipmentTable(string6);
                            equipmentTable.setName(string5);
                            EquipmentTable.addTable(equipmentTable);
                            this.theList.add(equipmentTable);
                        }
                        this.theCurrentData = equipmentTable;
                        this.theState = ParserState.EQTABLEDATA;
                    }
                } else if ("eqmod_table".equals(string3) && attributes != null) {
                    String string7 = attributes.getValue("name");
                    String string8 = attributes.getValue("id");
                    EqmodTable eqmodTable = EqmodTable.get(string8);
                    if (eqmodTable == null) {
                        eqmodTable = new EqmodTable(string8);
                        eqmodTable.setName(string7);
                        EqmodTable.addTable(eqmodTable);
                    }
                    this.theCurrentData = eqmodTable;
                    this.theState = ParserState.EQMODTABLEDATA;
                }
            } else if (this.theState == ParserState.EQTABLEDATA) {
                String string9;
                if ("entry".equals(string3) && attributes != null && (string9 = attributes.getValue("name")) != null) {
                    EquipmentTableEntry equipmentTableEntry = new EquipmentTableEntry(string9);
                    this.theCurrentEntry = equipmentTableEntry;
                    this.theState = ParserState.ENTRYDATA;
                    int n = this.getWeight(attributes);
                    this.theCurrentData.add(n, equipmentTableEntry);
                }
            } else if (this.theState == ParserState.EQMODTABLEDATA) {
                String string10;
                if ("entry".equals(string3) && attributes != null && (string10 = attributes.getValue("name")) != null) {
                    EqmodTableEntry eqmodTableEntry = new EqmodTableEntry(string10);
                    this.theCurrentEntry = eqmodTableEntry;
                    this.theState = ParserState.ENTRYDATA;
                    int n = this.getWeight(attributes);
                    this.theCurrentData.add(n, eqmodTableEntry);
                }
            } else if (this.theState == ParserState.ENTRYDATA) {
                if ("equipment".equals(string3)) {
                    if (attributes != null) {
                        String string11;
                        this.theCurrentItem = new EquipmentItem();
                        String string12 = attributes.getValue("rolls");
                        if (string12 != null) {
                            this.theCurrentItem.setTimes(string12);
                        }
                        if ((string11 = attributes.getValue("link")) != null) {
                            EquipmentTable equipmentTable = EquipmentTable.get(string11);
                            if (equipmentTable == null) {
                                EquipmentTableParser.this.theLinkTable.put(this.theCurrentItem, string11);
                            } else {
                                this.theCurrentItem.setLookup(equipmentTable);
                            }
                        } else {
                            String string13 = attributes.getValue("choose");
                            if (string13 != null) {
                                String[] stringArray = string13.split("\\|");
                                this.theCurrentItem.setVariableEquipment(attributes.getValue("value"), Arrays.asList(stringArray));
                            } else {
                                Object object;
                                String string14 = attributes.getValue("value");
                                if (string14 != null) {
                                    object = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string14);
                                    if (object == null) {
                                        Logging.errorPrint("Could not find equipment named: " + string14);
                                    }
                                    this.theCurrentItem.setEquipment((Equipment)object);
                                }
                                object = attributes.getValue("quantity");
                                this.theCurrentItem.setQuantity((String)object);
                            }
                        }
                        this.theCurrentEntry.addData(this.theCurrentItem);
                    }
                    this.theState = ParserState.EQUIPMENT;
                }
            } else if (this.theState == ParserState.EQUIPMENT && "eqmod".equals(string3) && attributes != null) {
                EqmodItem eqmodItem = new EqmodItem();
                String string15 = attributes.getValue("link");
                if (string15 != null) {
                    EqmodTable eqmodTable = EqmodTable.get(string15);
                    if (eqmodTable == null) {
                        EquipmentTableParser.this.theEqmodLinkTable.put(eqmodItem, string15);
                    } else {
                        eqmodItem.setLookup(eqmodTable);
                    }
                } else {
                    String string16;
                    String string17 = attributes.getValue("roll");
                    if (string17 != null) {
                        eqmodItem.setRollString(string17);
                    }
                    if ((string16 = attributes.getValue("value")) != null) {
                        eqmodItem.setEqmod(string16);
                    }
                }
                this.theCurrentItem.addEqMod(eqmodItem);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if ("equipment_tables".equals(string3)) {
                this.theState = ParserState.INIT;
            } else if ("table".equals(string3)) {
                this.theState = ParserState.INIT;
                TreasureGenerator.addTable(this.theGameMode, (EquipmentTable)this.theCurrentData);
            } else if ("eqmod_table".equals(string3)) {
                this.theState = ParserState.INIT;
            } else if ("entry".equals(string3)) {
                if (this.theCurrentData instanceof EquipmentTable) {
                    this.theState = ParserState.EQTABLEDATA;
                } else if (this.theCurrentData instanceof EqmodTable) {
                    this.theState = ParserState.EQMODTABLEDATA;
                }
            } else if ("equipment".equals(string3)) {
                this.theState = ParserState.ENTRYDATA;
            } else if ("eqmod".equals(string3)) {
                // empty if block
            }
        }

        private int getWeight(Attributes attributes) {
            int n = 1;
            String string = attributes.getValue("weight");
            if (string != null) {
                n = Integer.parseInt(string.trim());
            }
            return n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum ParserState {
        INIT,
        EQTABLEDATA,
        EQMODTABLEDATA,
        ENTRYDATA,
        EQUIPMENT;

    }
}

