/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import javax.swing.JFrame;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.gui.MainHP;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.Utility;
import pcgen.util.PropertyFactory;

final class HPFrame
extends JFrame {
    private MainHP mainHP = null;

    HPFrame() {
        this.setTitle(HPFrame.myGetTitle());
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Dimension dimension = Utility.getScreenSize(toolkit);
        int n = dimension.height;
        int n2 = dimension.width;
        this.setSize(n2 >> 1, n >> 1);
        this.setLocation(n2 >> 2, n >> 2);
        this.setDefaultCloseOperation(2);
        this.mainHP = new MainHP();
        Container container = this.getContentPane();
        container.add(this.mainHP);
        this.setVisible(true);
    }

    public void setCharacter(PlayerCharacter playerCharacter) {
        this.mainHP.setCharacter(playerCharacter);
    }

    public void setPSize() {
        if (this.mainHP != null) {
            this.mainHP.setPSize();
        }
    }

    private static String myGetTitle() {
        String string = PropertyFactory.getString("in_adjustHP");
        int n = string.indexOf("%s");
        if (n >= 0) {
            string = string.substring(0, n) + Globals.getGameModeHitPointText() + string.substring(n + 2);
        }
        return string;
    }
}

