/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.FakeWindowsLookAndFeel;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.SkinManager;
import pcgen.util.Logging;
import pcgen.util.SkinLFResourceChecker;

public final class UIFactory {
    private static String[][] lafData;
    private static final int NAME = 0;
    private static final int CLASSNAME = 1;
    private static final int TOOLTIP = 2;
    private static final int crossPlatformIndex = 1;
    private static final boolean windowsPlatform;

    public static void setLookAndFeel(int n) {
        UIFactory.internalSetLookAndFeel(n);
    }

    public static int getLookAndFeelCount() {
        return lafData.length;
    }

    public static String getLookAndFeelName(int n) {
        if (n == lafData.length) {
            return "Skinned";
        }
        return lafData[n][0];
    }

    public static String getLookAndFeelTooltip(int n) {
        if (n == lafData.length) {
            return "Sets the look to skinned";
        }
        return lafData[n][2];
    }

    public static boolean isWindowsUI() {
        String string = UIFactory.getLookAndFeelName(SettingsHandler.getLookAndFeel());
        return string.equals("Windows") || string.equals("System") && UIFactory.isWindowsPlatform();
    }

    public static int indexOfCrossPlatformLookAndFeel() {
        return 1;
    }

    public static void initLookAndFeel() {
        block7: {
            if (SettingsHandler.getLookAndFeel() < lafData.length) {
                UIFactory.internalSetLookAndFeel(SettingsHandler.getLookAndFeel());
            } else if (SettingsHandler.getLookAndFeel() == lafData.length) {
                try {
                    if (SkinLFResourceChecker.getMissingResourceCount() == 0) {
                        SkinManager.applySkin();
                        break block7;
                    }
                    Logging.errorPrint(SkinLFResourceChecker.getMissingResourceMessage());
                    UIFactory.internalSetLookAndFeel(lafData[1][1]);
                }
                catch (Exception exception) {
                    SettingsHandler.setLookAndFeel(0);
                    UIFactory.internalSetLookAndFeel(lafData[1][1]);
                    ShowMessageDelegate.showMessageDialog("There was a problem setting the skinned look and feel.\nThe look and feel has been reset to cross-platform.\nError: " + exception.toString(), "PCGen", MessageType.ERROR);
                }
            } else {
                SettingsHandler.setLookAndFeel(0);
                UIFactory.internalSetLookAndFeel(lafData[1][1]);
            }
        }
    }

    private static void refreshFullUI() {
        SwingUtilities.updateComponentTreeUI(Globals.getRootFrame());
    }

    private static void internalSetLookAndFeel(Object object) {
        try {
            if (object instanceof String) {
                UIManager.setLookAndFeel((String)object);
            } else if (object instanceof LookAndFeel) {
                UIManager.setLookAndFeel((LookAndFeel)object);
            } else if (object instanceof Integer) {
                UIManager.setLookAndFeel(lafData[(Integer)object][1]);
            }
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            if (lookAndFeel instanceof MetalLookAndFeel) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme());
            }
            PCGen_Frame1.getInst().getPcgenMenuBar().separateHelpMenu(!UIFactory.isWindowsUI());
        }
        catch (Exception exception) {
            Logging.errorPrint("Exception in UIFactory::internalSetLookAndFeel", exception);
        }
        UIFactory.refreshFullUI();
    }

    private static boolean isWindowsPlatform() {
        return windowsPlatform;
    }

    static {
        int n;
        windowsPlatform = System.getProperty("os.name").startsWith("Windows ");
        UIManager.installLookAndFeel("Kunststoff", "com.incors.plaf.kunststoff.KunststoffLookAndFeel");
        try {
            if (SkinLFResourceChecker.getMissingResourceCount() == 0) {
                SkinManager.loadLinuxSkin();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        lafData = new String[lookAndFeelInfoArray.length][3];
        UIFactory.lafData[0][0] = "System";
        UIFactory.lafData[0][1] = UIManager.getSystemLookAndFeelClassName();
        UIFactory.lafData[0][2] = "Sets the look to that of the System you are using";
        int n2 = 1;
        if (!lafData[0][1].equals(UIManager.getCrossPlatformLookAndFeelClassName())) {
            UIFactory.lafData[1][0] = "Java";
            UIFactory.lafData[1][1] = UIManager.getCrossPlatformLookAndFeelClassName();
            UIFactory.lafData[1][2] = "Sets the look to that of Java's cross platform look";
            ++n2;
        }
        for (n = 0; n < lookAndFeelInfoArray.length && n2 < lafData.length; ++n) {
            UIFactory.lafData[n2][1] = lookAndFeelInfoArray[n].getClassName();
            if (lafData[n2][1].equals(UIManager.getSystemLookAndFeelClassName()) || lafData[n2][1].equals(UIManager.getCrossPlatformLookAndFeelClassName())) continue;
            UIFactory.lafData[n2][0] = lookAndFeelInfoArray[n].getName();
            UIFactory.lafData[n2][2] = "Sets the look to " + lafData[n2][0] + " look";
            ++n2;
        }
        if (!UIFactory.isWindowsPlatform()) {
            for (n = 0; n < lookAndFeelInfoArray.length; ++n) {
                if (!lookAndFeelInfoArray[n].getClassName().endsWith("WindowsLookAndFeel")) continue;
                lookAndFeelInfoArray[n] = new UIManager.LookAndFeelInfo(lookAndFeelInfoArray[n].getName(), FakeWindowsLookAndFeel.class.getName());
                break;
            }
        }
        UIManager.setInstalledLookAndFeels(lookAndFeelInfoArray);
        if (!UIFactory.isWindowsPlatform()) {
            for (n = 0; n < lafData.length; ++n) {
                if (!lafData[n][1].endsWith("WindowsLookAndFeel")) continue;
                UIFactory.lafData[n][1] = FakeWindowsLookAndFeel.class.getName();
                break;
            }
        }
    }
}

