/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.base.Category;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.helper.Qualifier;
import pcgen.cdom.reference.CDOMSingleRef;
import pcgen.cdom.reference.CategorizedCDOMReference;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.rules.context.LoadContext;
import pcgen.util.PropertyFactory;
import pcgen.util.StringPClassUtil;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassBasePanel
extends BasePanel {
    private JCheckBox chkVisible;
    private JCheckBox modToSkills;
    private JTextField abbreviation;
    private JTextField exClass;
    private JTextField exchangeLevel;
    private JTextField qualify;
    private JTextField startSkillPoints;
    private JTextField txtDisplayName;
    private TypePanel pnlTemplateTypes;

    public ClassBasePanel() {
        this.initComponents();
    }

    public void setTypesAvailableList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        String string;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        pCClass.put(StringKey.OUTPUT_NAME, this.txtDisplayName.getText().trim());
        LoadContext loadContext = Globals.getContext();
        loadContext.ref.registerAbbreviation(pCClass, this.abbreviation.getText().trim());
        if (this.exchangeLevel.getText().trim().length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "EXCHANGELEVEL", this.exchangeLevel.getText().trim());
        }
        if ((string = this.startSkillPoints.getText().trim()).length() > 0) {
            Object[] objectArray = FormulaFactory.getFormulaFor(string);
            pCClass.put(FormulaKey.START_SKILL_POINTS, (Formula)objectArray);
        }
        pCClass.removeListFor(ListKey.QUALIFY);
        if (this.qualify.getText().trim().length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "QUALIFY", this.qualify.getText());
        }
        if (this.exClass.getText().trim().length() > 0) {
            loadContext.unconditionallyProcess(pCClass, "EXCLASS", this.exClass.getText().trim());
        }
        pCClass.put(ObjectKey.MOD_TO_SKILLS, this.modToSkills.getSelectedObjects() != null);
        pCClass.put(ObjectKey.VISIBILITY, this.chkVisible.getSelectedObjects() == null ? Visibility.HIDDEN : Visibility.DEFAULT);
        pObject.removeListFor(ListKey.TYPE);
        for (Object object : this.getTypesSelectedList()) {
            pObject.addToListFor(ListKey.TYPE, Type.getConstant(object.toString()));
        }
    }

    @Override
    public void updateView(PObject pObject) {
        String[] stringArray;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        ArrayList<Type> arrayList = new ArrayList<Type>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        for (PCClass object22 : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
            for (Type type : object22.getTrueTypeList(false)) {
                if (type.equals(Type.CUSTOM) || arrayList.contains(type)) continue;
                arrayList.add(type);
            }
        }
        for (Type type : pObject.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        PCClass pCClass = (PCClass)pObject;
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.txtDisplayName.setText(pCClass.getOutputName());
        this.abbreviation.setText(pCClass.getAbbrev());
        LoadContext loadContext = Globals.getContext();
        String[] stringArray2 = loadContext.unparseSubtoken(pCClass, "EXCHANGELEVEL");
        this.exchangeLevel.setText(stringArray2 == null ? "" : stringArray2[0]);
        Formula formula = pCClass.get(FormulaKey.START_SKILL_POINTS);
        this.startSkillPoints.setText(formula == null ? "" : formula.toString());
        List<Qualifier> list = pCClass.getListFor(ListKey.QUALIFY);
        if (list != null) {
            stringArray = new ArrayList();
            for (Qualifier qualifier : list) {
                String string = StringPClassUtil.getStringFor(qualifier.getQualifiedClass());
                CDOMSingleRef<? extends CDOMObject> cDOMSingleRef = qualifier.getQualifiedReference();
                if (cDOMSingleRef instanceof CategorizedCDOMReference) {
                    Category category = ((CategorizedCDOMReference)((Object)cDOMSingleRef)).getCDOMCategory();
                    string = string + '=' + category.toString();
                }
                stringArray.add(string + "|" + cDOMSingleRef.getLSTformat());
            }
            this.qualify.setText(StringUtil.join(stringArray, "|"));
        }
        this.exClass.setText((stringArray = loadContext.unparseSubtoken(pCClass, "EXCLASS")) == null ? "" : stringArray[0]);
        Boolean bl = pCClass.get(ObjectKey.MOD_TO_SKILLS);
        this.modToSkills.setSelected(bl == null ? true : bl);
        this.chkVisible.setSelected(pCClass.getSafe(ObjectKey.VISIBILITY).equals((Object)Visibility.DEFAULT));
    }

    private static GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        if (bl) {
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        }
        return gridBagConstraints;
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.txtDisplayName = new JTextField();
        this.abbreviation = new JTextField();
        this.qualify = new JTextField();
        this.exchangeLevel = new JTextField();
        this.startSkillPoints = new JTextField();
        this.exClass = new JTextField();
        this.modToSkills = new JCheckBox();
        this.chkVisible = new JCheckBox();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        JLabel jLabel = new JLabel("Display Name");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 0, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 0, true);
        gridBagConstraints.gridwidth = 5;
        this.add((Component)this.txtDisplayName, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.16;
        jLabel = new JLabel("ABB:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 1, true);
        this.add((Component)this.abbreviation, gridBagConstraints);
        jLabel = new JLabel("Ex-Class:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 1, true);
        this.add((Component)this.exClass, gridBagConstraints);
        jLabel = new JLabel("Exchange Level:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 1, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 1, true);
        this.add((Component)this.exchangeLevel, gridBagConstraints);
        gridBagConstraints.weightx = 0.0;
        jLabel = new JLabel("Has SubClass:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Mod To Skills:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 3, 2, true);
        this.add((Component)this.modToSkills, gridBagConstraints);
        jLabel = new JLabel("Starting Skill Points:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 2, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 2, true);
        this.add((Component)this.startSkillPoints, gridBagConstraints);
        jLabel = new JLabel("Qualify:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 0, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 1, 3, true);
        this.add((Component)this.qualify, gridBagConstraints);
        jLabel = new JLabel("Multi-Class Pre-Reqs:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 2, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel("Visible:");
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 4, 3, true);
        this.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = ClassBasePanel.buildConstraints(gridBagConstraints, 5, 3, true);
        this.add((Component)this.chkVisible, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

