/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import pcgen.base.formula.Formula;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.base.TransitionChoice;
import pcgen.cdom.content.SpellResistance;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.Region;
import pcgen.cdom.enumeration.VariableKey;
import pcgen.cdom.inst.PCClassLevel;
import pcgen.core.Campaign;
import pcgen.core.CustomData;
import pcgen.core.DamageReduction;
import pcgen.core.Description;
import pcgen.core.Domain;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.SpecialAbility;
import pcgen.core.bonus.BonusObj;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.PObjectUpdater;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.PCClassLoader;
import pcgen.rules.context.LoadContext;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class ClassLevelPanel
extends JPanel
implements PObjectUpdater {
    static final long serialVersionUID = 1485178774957708877L;
    private static List<LevelTag> levelTagList = new ArrayList<LevelTag>();
    private JButton addBtn = new JButton();
    private JButton delBtn = new JButton();
    private JComboBoxEx tagList = new JComboBoxEx();
    private JScrollPane levelPane;
    private JTableEx levelTable = new JTableEx();
    private JTextField level = new JTextField();
    private LevelModel levelModel = new LevelModel();
    private PCClass obj = null;
    private TableSorter sortedLevelModel = new TableSorter();

    public ClassLevelPanel() {
        this.initComponents();
    }

    public void updateData(PObject pObject) {
        if (!(pObject instanceof PCClass)) {
            Logging.errorPrint("Invalid PObject passed to ClassLevelPanel.updateData()!");
            return;
        }
        PCClass pCClass = (PCClass)pObject;
        try {
            Object object;
            Campaign campaign = new Campaign();
            campaign.setName("Custom");
            campaign.addToListFor(ListKey.DESCRIPTION, new Description("Custom data"));
            URI uRI = pCClass.getSourceURI();
            if (uRI == null) {
                object = CustomData.customClassFilePath(true);
                if (!((String)object).startsWith("/")) {
                    object = "/" + (String)object;
                }
                uRI = new URI("file", null, (String)object, null);
                pCClass.setSourceURI(uRI);
                pCClass.setSourceCampaign(campaign);
            }
            object = new CampaignSourceEntry(campaign, uRI);
            pCClass.clearClassLevels();
            for (LevelTag levelTag : levelTagList) {
                if (!levelTag.needsSaving()) continue;
                PCClassLoader pCClassLoader = new PCClassLoader();
                pCClassLoader.parseClassLevelLine(Globals.getContext(), pCClass, levelTag.getLevel(), (CampaignSourceEntry)object, levelTag.getTag() + ":" + levelTag.getValue());
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            Logging.errorPrint(uRISyntaxException.getLocalizedMessage());
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint(persistenceLayerException.getMessage());
        }
        pCClass.updateSpellCache(true);
    }

    public void updateView(PObject pObject) {
        Object object;
        Object object2;
        TransitionChoice<Region> transitionChoice;
        Object object3;
        if (!(pObject instanceof PCClass)) {
            return;
        }
        levelTagList.clear();
        this.obj = (PCClass)pObject;
        for (PCClassLevel object72 : this.obj.getClassLevelCollection()) {
            object3 = object72.getListMods(PCClass.ALLOWED_DOMAINS);
            int entry = object72.getSafe(IntegerKey.LEVEL);
            if (object3 != null) {
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    CDOMReference cDOMReference = iterator.next();
                    for (Domain domain : cDOMReference.getContainedObjects()) {
                        transitionChoice = domain.getKeyName();
                        LevelTag levelTag = new LevelTag(entry, 1, (String)((Object)transitionChoice));
                        levelTagList.add(levelTag);
                    }
                }
            }
            for (DamageReduction damageReduction : object72.getSafeListFor(ListKey.DAMAGE_REDUCTION)) {
                object2 = damageReduction.getReduction() + "/" + damageReduction.getBypass();
                LevelTag levelTag = new LevelTag(object72.getSafe(IntegerKey.LEVEL), 6, (String)object2);
                levelTagList.add(levelTag);
            }
            for (VariableKey variableKey : object72.getVariableKeys()) {
                object2 = new LevelTag(entry, 4, variableKey.toString() + '|' + this.obj.get(variableKey));
                levelTagList.add((LevelTag)object2);
            }
        }
        for (BonusObj bonusObj : this.obj.getSafeListFor(ListKey.BONUS)) {
            String entry;
            object3 = bonusObj.toString();
            if (((String)object3).startsWith(entry = String.valueOf(bonusObj.getPCLevel()))) {
                object3 = ((String)object3).substring(entry.length() + 1);
            }
            LevelTag levelTag = new LevelTag(bonusObj.getPCLevel(), 2, (String)object3);
            levelTagList.add(levelTag);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(-9).append('|');
        for (VariableKey transitionChoice2 : this.obj.getVariableKeys()) {
            LevelTag levelTag = new LevelTag(0, 4, transitionChoice2.toString() + '|' + this.obj.get(transitionChoice2));
            levelTagList.add(levelTag);
        }
        if (this.obj.hasCastList()) {
            for (Map.Entry<Integer, List<Formula>> pCClassLevel : this.obj.getCastProgression().entrySet()) {
                LevelTag levelTag = new LevelTag(pCClassLevel.getKey(), 3, StringUtil.join((Collection)pCClassLevel.getValue(), ","));
                levelTagList.add(levelTag);
            }
        }
        if (this.obj.hasKnownList()) {
            for (Map.Entry entry : this.obj.getKnownMap().entrySet()) {
                LevelTag levelTag = new LevelTag((Integer)entry.getKey(), 10, StringUtil.join((Collection)entry.getValue(), ","));
                levelTagList.add(levelTag);
            }
        }
        for (TransitionChoice transitionChoice2 : this.obj.getSafeListFor(ListKey.KIT_CHOICE)) {
            LevelTag levelTag = new LevelTag(1, 9, transitionChoice2.getCount() + "|" + transitionChoice2.getChoices().getLSTformat());
            levelTagList.add(levelTag);
        }
        for (PCClassLevel pCClassLevel : this.obj.getClassLevelCollection()) {
            List<SpecialAbility> list;
            Integer n = pCClassLevel.get(IntegerKey.LEVEL);
            String[] stringArray = Globals.getContext().unparseSubtoken(pCClassLevel, "SPELLS");
            if (stringArray != null) {
                for (String string : stringArray) {
                    object = new LevelTag(n, 14, string);
                    levelTagList.add((LevelTag)object);
                }
            }
            for (TransitionChoice transitionChoice3 : this.obj.getSafeListFor(ListKey.KIT_CHOICE)) {
                LevelTag levelTag = new LevelTag(n, 9, transitionChoice3.getCount() + "|" + transitionChoice3.getChoices().getLSTformat());
                levelTagList.add(levelTag);
            }
            object2 = this.obj.get(ObjectKey.SR);
            if (object2 != null) {
                levelTagList.add(new LevelTag(n, 15, ((SpellResistance)object2).getLSTformat()));
            }
            if ((list = this.obj.getListFor(ListKey.SAB)) != null && !list.isEmpty()) {
                for (SpecialAbility specialAbility : list) {
                    levelTagList.add(new LevelTag(n, 12, specialAbility.toString()));
                }
            }
            for (BonusObj bonusObj : pCClassLevel.getSafeListFor(ListKey.BONUS)) {
                String string;
                object = bonusObj.toString();
                if (((String)object).startsWith(string = n.toString())) {
                    object = ((String)object).substring(string.length() + 1);
                }
                LevelTag levelTag = new LevelTag(n, 2, (String)object);
                levelTagList.add(levelTag);
            }
            transitionChoice = pCClassLevel.get(ObjectKey.REGION_CHOICE);
            if (transitionChoice == null) continue;
            LevelTag levelTag = new LevelTag(n, 11, transitionChoice.getChoices().getLSTformat().replaceAll(",", "|"));
            levelTagList.add(levelTag);
        }
        object3 = Globals.getContext();
        for (PCClassLevel pCClassLevel : this.obj.getClassLevelCollection()) {
            String[] stringArray = ((LoadContext)object3).unparseSubtoken(pCClassLevel, "TEMPLATE");
            if (stringArray == null) continue;
            for (String string : stringArray) {
                object = new LevelTag(pCClassLevel.getSafe(IntegerKey.LEVEL), 16, string);
                levelTagList.add((LevelTag)object);
            }
        }
        for (PCClassLevel pCClassLevel : this.obj.getClassLevelCollection()) {
            Integer n = pCClassLevel.get(IntegerKey.UMULT);
            if (n == null) continue;
            object2 = new LevelTag(this.obj.getPCClassLevel(pCClassLevel), 18, n.toString());
            levelTagList.add((LevelTag)object2);
        }
        for (PCClassLevel pCClassLevel : this.obj.getClassLevelCollection()) {
            List<String> list = pCClassLevel.getListFor(ListKey.UNARMED_DAMAGE);
            if (list == null) continue;
            object2 = new LevelTag(this.obj.getPCClassLevel(pCClassLevel), 17, StringUtil.join(list, ","));
            levelTagList.add((LevelTag)object2);
        }
        this.levelModel.updateModel();
    }

    private void initComponents() {
        for (int i = 0; i < LevelTag.validTags.length; ++i) {
            this.tagList.addItem(LevelTag.validTags[i]);
        }
        this.tagList.setSelectedIndex(0);
        this.level.setText("1     ");
        this.setLayout(new BorderLayout());
        this.levelPane = new JScrollPane(this.levelTable);
        this.sortedLevelModel.setModel(this.levelModel);
        this.levelTable.setModel(this.sortedLevelModel);
        this.levelTable.setColAlign(0, 0);
        this.levelPane.setViewportView(this.levelTable);
        this.levelTable.setSelectionMode(0);
        this.sortedLevelModel.addMouseListenerToHeaderInTable(this.levelTable);
        this.levelTable.getColumnModel().getColumn(0).setPreferredWidth(5);
        this.levelTable.getColumnModel().getColumn(1).setPreferredWidth(10);
        this.add((Component)this.levelPane, "Center");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        JLabel jLabel = new JLabel("Level:");
        jPanel.add(jLabel);
        jPanel.add(this.level);
        jLabel = new JLabel("Tag:");
        jPanel.add(jLabel);
        jPanel.add(this.tagList);
        this.addBtn.setText(PropertyFactory.getString("in_add"));
        jPanel.add(this.addBtn);
        this.addBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ClassLevelPanel.this.tagList.getSelectedItem().toString();
                if (string.equals("CAST") || string.equals("KNOWN")) {
                    int n;
                    String[] stringArray = new String[]{"Level 0", "Level 1", "Level 2", "Level 3", "Level 4", "Level 5", "Level 6", "Level 7", "Level 8", "Level 9"};
                    String[] stringArray2 = new String[]{"", "", "", "", "", "", "", "", "", ""};
                    MatrixFrame matrixFrame = new MatrixFrame(stringArray, 10, stringArray2, string);
                    String string2 = "";
                    for (n = 0; n < 10; ++n) {
                        if (n > 0) {
                            string2 = string2 + ",";
                        }
                        string2 = string2 + matrixFrame.fields[n];
                    }
                    n = 0;
                    while (string2.endsWith(",") && n++ < 9) {
                        string2 = string2.substring(0, string2.length() - 1);
                    }
                    if (!string2.equals("")) {
                        LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, string2.trim(), true);
                        levelTagList.add(levelTag);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else if (string.equals("FEAT") || string.equals("VFEAT") || string.equals("FEATAUTO")) {
                    ListFrame listFrame = new ListFrame("Choices for " + string, Globals.getUnmodifiableAbilityList("FEAT"));
                    String string3 = listFrame.getSelectedList();
                    if (!string3.equals("")) {
                        LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, string3.trim(), true);
                        levelTagList.add(levelTag);
                        ClassLevelPanel.this.levelModel.updateModel();
                    }
                } else {
                    InputInterface inputInterface = InputFactory.getInputInstance();
                    Object object = inputInterface.showInputDialog(null, "Enter the value for " + string, "PCGen", MessageType.INFORMATION, null, "");
                    if (object == null) {
                        return;
                    }
                    LevelTag levelTag = new LevelTag(ClassLevelPanel.this.level.getText().trim(), string, object.toString().trim(), true);
                    levelTagList.add(levelTag);
                    ClassLevelPanel.this.levelModel.updateModel();
                }
            }
        });
        this.delBtn.setText(PropertyFactory.getString("in_remove"));
        jPanel.add(this.delBtn);
        this.delBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ClassLevelPanel.this.removeLevelTag();
            }
        });
        this.add((Component)jPanel, "South");
    }

    private void removeLevelTag() {
        int n = this.levelTable.getSelectedRow();
        if (n >= 0 && n < levelTagList.size()) {
            LevelTag levelTag = levelTagList.get(n = this.sortedLevelModel.getRowTranslated(n));
            if (!levelTag.needsSaving()) {
                if (this.obj == null) {
                    return;
                }
                boolean bl = false;
                if (!bl) {
                    Logging.errorPrint("This tag " + levelTag.getTag() + ":" + levelTag.getValue() + " needs to be hand-deleted from customClasses.lst");
                    ShowMessageDelegate.showMessageDialog("This tag " + levelTag.getTag() + ":" + levelTag.getValue() + " needs to be hand-deleted from customClasses.lst", "PCGen", MessageType.ERROR);
                    return;
                }
            }
            levelTagList.remove(n);
            this.levelModel.updateModel();
        }
    }

    private static final class LevelTag {
        static final String[] validTags = new String[]{"ADD", "ADDDOMAINS", "BONUS", "CAST", "DEFINE", "DOMAIN", "DR", "FEAT", "AUTO:FEAT", "KIT", "KNOWN", "REGION", "SAB", "SPECIALTYKNOWN", "SPELLS", "SR", "TEMPLATE", "UDAM", "UMULT", "VFEAT"};
        private static final int TAG_ADD = 0;
        private static final int TAG_ADDDOMAINS = 1;
        private static final int TAG_BONUS = 2;
        private static final int TAG_CAST = 3;
        private static final int TAG_DEFINE = 4;
        private static final int TAG_DOMAIN = 5;
        private static final int TAG_DR = 6;
        private static final int TAG_FEAT = 7;
        private static final int TAG_AUTOFEAT = 8;
        private static final int TAG_KIT = 9;
        private static final int TAG_KNOWN = 10;
        private static final int TAG_REGION = 11;
        private static final int TAG_SAB = 12;
        private static final int TAG_SPECIALTYKNOWN = 13;
        private static final int TAG_SPELLS = 14;
        private static final int TAG_SR = 15;
        private static final int TAG_TEMPLATE = 16;
        private static final int TAG_UDAM = 17;
        private static final int TAG_UMULT = 18;
        private static final int TAG_VFEAT = 19;
        private String value;
        private boolean needsSaving;
        private int level;
        private int tagVal;

        public LevelTag(String string, String string2, String string3, boolean bl) {
            int n = 0;
            if (string != null && string.length() > 0) {
                n = Integer.parseInt(string);
            }
            this.setData(n, this.parseTag(string2), string3, bl);
        }

        LevelTag(String string, int n, String string2) {
            int n2 = 0;
            if (string != null && string.length() > 0) {
                n2 = Integer.parseInt(string);
            }
            this.setData(n2, n, string2, true);
        }

        LevelTag(int n, int n2, String string) {
            this.setData(n, n2, string, true);
        }

        LevelTag(int n, String string, String string2, boolean bl) {
            this.setData(n, this.parseTag(string), string2, bl);
        }

        public int getLevel() {
            return this.level;
        }

        public String getTag() {
            if (this.tagVal >= 0) {
                return validTags[this.tagVal];
            }
            return "Unknown";
        }

        public int getTagVal() {
            return this.tagVal;
        }

        public String getValue() {
            return this.value;
        }

        public boolean needsSaving() {
            return this.needsSaving;
        }

        void setData(int n, int n2, String string, boolean bl) {
            if (n2 >= validTags.length) {
                n2 = -1;
            }
            this.level = n;
            this.tagVal = n2;
            this.value = string;
            this.needsSaving = bl;
        }

        private int parseTag(String string) {
            for (int i = 0; i < validTags.length; ++i) {
                if (!validTags[i].equalsIgnoreCase(string)) continue;
                return i;
            }
            return -1;
        }
    }

    private static final class LevelModel
    extends AbstractTableModel {
        static final long serialVersionUID = 1485178774957708877L;
        private final String[] colNames = new String[]{"Level", "Tag", "Value"};

        private LevelModel() {
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Integer.class;
            }
            return String.class;
        }

        public int getColumnCount() {
            return this.colNames.length;
        }

        public String getColumnName(int n) {
            return n >= 0 && n < this.colNames.length ? this.colNames[n] : "Out Of Bounds";
        }

        public int getRowCount() {
            return levelTagList.size();
        }

        public Object getValueAt(int n, int n2) {
            if (n >= 0 && n < levelTagList.size()) {
                LevelTag levelTag = (LevelTag)levelTagList.get(n);
                switch (n2) {
                    case 0: {
                        return levelTag.getLevel();
                    }
                    case 1: {
                        return levelTag.getTag();
                    }
                    case 2: {
                        return levelTag.getValue();
                    }
                }
                Logging.errorPrint("In ClassLevelPanel.LevelModel.getValueAt the column " + n2 + " is not supported.");
            }
            return null;
        }

        private void updateModel() {
            this.fireTableDataChanged();
        }
    }

    static final class MatrixFrame
    extends JDialog {
        public String[] fields;
        private String[] colNames;
        private JTextField[] textField;
        private String[] values;
        private int columns;

        public MatrixFrame(String[] stringArray, int n, String[] stringArray2, String string) {
            super(Globals.getRootFrame(), string, true);
            this.colNames = stringArray;
            this.columns = n;
            this.values = stringArray2;
            this.initComponents();
            this.setSize(new Dimension(60 * this.columns, 140));
            this.setVisible(true);
            this.pack();
        }

        private GridBagConstraints buildConstraints(GridBagConstraints gridBagConstraints, int n, int n2, boolean bl) {
            gridBagConstraints.gridx = n;
            gridBagConstraints.gridy = n2;
            if (bl) {
                gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            }
            return gridBagConstraints;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            this.textField = new JTextField[this.columns];
            for (int i = 0; i < this.columns; ++i) {
                JLabel jLabel = new JLabel(this.colNames[i]);
                gridBagConstraints = this.buildConstraints(gridBagConstraints, i, 0, true);
                this.getContentPane().add((Component)jLabel, gridBagConstraints);
                this.textField[i] = new JTextField(this.values[i]);
                gridBagConstraints = this.buildConstraints(gridBagConstraints, i, 1, true);
                this.getContentPane().add((Component)this.textField[i], gridBagConstraints);
            }
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 2, 2, true);
            this.getContentPane().add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatrixFrame.this.setVisible(false);
                    MatrixFrame.this.fields = new String[MatrixFrame.this.columns];
                    for (int i = 0; i < MatrixFrame.this.columns; ++i) {
                        MatrixFrame.this.fields[i] = MatrixFrame.this.textField[i].getText();
                    }
                }
            });
            jButton = new JButton(PropertyFactory.getString("in_cancel"));
            gridBagConstraints = this.buildConstraints(gridBagConstraints, this.columns - 1, 2, true);
            this.getContentPane().add((Component)jButton, gridBagConstraints);
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MatrixFrame.this.setVisible(false);
                    MatrixFrame.this.fields = new String[MatrixFrame.this.columns];
                    for (int i = 0; i < MatrixFrame.this.columns; ++i) {
                        MatrixFrame.this.fields[i] = "";
                    }
                }
            });
        }
    }

    static final class ListFrame
    extends JDialog {
        AvailableSelectedPanel asPanel = new AvailableSelectedPanel();

        public ListFrame(String string, List list) {
            super(Globals.getRootFrame(), string, true);
            this.initComponents();
            this.asPanel.setAvailableList(list, true);
            this.setSize(new Dimension(400, 400));
            this.setVisible(true);
            this.pack();
        }

        public String getSelectedList() {
            Object[] objectArray = this.asPanel.getSelectedList();
            if (objectArray.length == 0) {
                return "";
            }
            String string = objectArray[0].toString();
            for (int i = 1; i < objectArray.length; ++i) {
                string = string + "|" + objectArray[i].toString();
            }
            return string;
        }

        private void initComponents() {
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.asPanel, "Center");
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            this.getContentPane().add((Component)jButton, "South");
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ListFrame.this.setVisible(false);
                }
            });
        }
    }
}

