/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.cdom.base.CDOMReference;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.Description;
import pcgen.core.Globals;
import pcgen.core.PCAlignment;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.WeaponProf;
import pcgen.gui.editor.AvailableSelectedPanel;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.DescriptionPanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.rules.context.LoadContext;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DeityBasePanel
extends BasePanel {
    private AvailableSelectedPanel pnlFavoredWeapons;
    private DescriptionPanel pnlDescription;
    private JComboBoxEx cmbDeityAlignment;
    private JLabel lblDeityAlignment;
    private JLabel lblHolyItem;
    private JPanel pnlDeityAlignment;
    private JPanel pnlHolyItem;
    private JTextField txtHolyItem;

    DeityBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setDeityAlignment(PCAlignment pCAlignment) {
        if (pCAlignment != null && pCAlignment.isValidForDeity()) {
            this.cmbDeityAlignment.setSelectedItem(pCAlignment.getKeyName());
        }
    }

    public String getDeityAlignment() {
        int n;
        String string = (String)this.cmbDeityAlignment.getSelectedItem();
        if (string != null && (n = SettingsHandler.getGame().getIndexOfAlignment(string)) >= 0) {
            return SettingsHandler.getGame().getShortAlignmentAtIndex(n);
        }
        return null;
    }

    public void setDescIsPI(boolean bl) {
        this.pnlDescription.setDescIsPI(bl);
    }

    public boolean getDescIsPI() {
        return this.pnlDescription.getDescIsPI();
    }

    public void setDescriptionText(String string) {
        this.pnlDescription.setText(string);
    }

    public String getDescriptionText() {
        return this.pnlDescription.getText();
    }

    public void setFavoredWeaponsAvailableList(List<WeaponProf> list, boolean bl) {
        this.pnlFavoredWeapons.setAvailableList(list, bl);
    }

    public Object[] getFavoredWeaponsAvailableList() {
        return this.pnlFavoredWeapons.getAvailableList();
    }

    public void setFavoredWeaponsSelectedList(List<WeaponProf> list, boolean bl) {
        this.pnlFavoredWeapons.setSelectedList(list, bl);
    }

    public Object[] getFavoredWeaponsSelectedList() {
        return this.pnlFavoredWeapons.getSelectedList();
    }

    public void setHolyItemText(String string) {
        this.txtHolyItem.setText(string);
    }

    public String getHolyItemText() {
        return this.txtHolyItem.getText().trim();
    }

    @Override
    public void updateData(PObject pObject) {
        if (this.getHolyItemText() == null || this.getHolyItemText().trim().length() > 0) {
            pObject.put(StringKey.HOLY_ITEM, this.getHolyItemText());
        } else {
            pObject.remove(StringKey.HOLY_ITEM);
        }
        PCAlignment pCAlignment = SettingsHandler.getGame().getAlignment(this.getDeityAlignment());
        pObject.put(ObjectKey.ALIGNMENT, pCAlignment);
        LoadContext loadContext = Globals.getContext();
        String string = this.getDescriptionText();
        StringTokenizer stringTokenizer = new StringTokenizer(".CLEAR\t" + string, "\t");
        while (stringTokenizer.hasMoreTokens()) {
            loadContext.unconditionallyProcess(pObject, "DESC", stringTokenizer.nextToken());
        }
        pObject.put(ObjectKey.DESC_PI, this.getDescIsPI());
        pObject.removeListFor(ListKey.DEITYWEAPON);
        if (this.getFavoredWeaponsAvailableList().length == 0) {
            pObject.addToListFor(ListKey.DEITYWEAPON, Globals.getContext().ref.getCDOMAllReference(WeaponProf.class));
        } else {
            for (Object object : this.getFavoredWeaponsSelectedList()) {
                CDOMDirectSingleRef<WeaponProf> cDOMDirectSingleRef = CDOMDirectSingleRef.getRef(Globals.getContext().ref.silentlyGetConstructedCDOMObject(WeaponProf.class, object.toString()));
                pObject.addToListFor(ListKey.DEITYWEAPON, cDOMDirectSingleRef);
            }
        }
    }

    @Override
    public void updateView(PObject pObject) {
        this.setHolyItemText(pObject.get(StringKey.HOLY_ITEM));
        StringBuffer stringBuffer = new StringBuffer();
        for (Description cloneable2 : pObject.getSafeListFor(ListKey.DESCRIPTION)) {
            if (stringBuffer.length() != 0) {
                stringBuffer.append("\t");
            }
            stringBuffer.append(cloneable2.getPCCText());
        }
        this.setDescriptionText(stringBuffer.toString());
        this.setDescIsPI(pObject.getSafe(ObjectKey.DESC_PI));
        this.setDeityAlignment(pObject.get(ObjectKey.ALIGNMENT));
        ArrayList arrayList = new ArrayList();
        ArrayList<WeaponProf> arrayList2 = new ArrayList<WeaponProf>(Globals.getContext().ref.getConstructedCDOMObjects(WeaponProf.class));
        List<CDOMReference<WeaponProf>> list = pObject.getSafeListFor(ListKey.DEITYWEAPON);
        for (CDOMReference<WeaponProf> cDOMReference : list) {
            for (WeaponProf weaponProf : cDOMReference.getContainedObjects()) {
                arrayList.add(weaponProf);
                arrayList2.remove(weaponProf);
            }
        }
        this.setFavoredWeaponsAvailableList(arrayList2, true);
        this.setFavoredWeaponsSelectedList(arrayList, true);
    }

    private void initComponentContents() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (PCAlignment pCAlignment : SettingsHandler.getGame().getUnmodifiableAlignmentList()) {
            if (!pCAlignment.isValidForDeity()) continue;
            arrayList.add(pCAlignment.getKeyName());
        }
        this.cmbDeityAlignment.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.pnlHolyItem = new JPanel();
        this.lblHolyItem = new JLabel();
        this.txtHolyItem = new JTextField();
        this.pnlDeityAlignment = new JPanel();
        this.lblDeityAlignment = new JLabel();
        this.cmbDeityAlignment = new JComboBoxEx();
        this.pnlDescription = new DescriptionPanel();
        this.pnlFavoredWeapons = new AvailableSelectedPanel();
        this.setLayout(new GridBagLayout());
        this.pnlHolyItem.setLayout(new GridBagLayout());
        this.lblHolyItem.setLabelFor(this.txtHolyItem);
        this.lblHolyItem.setText(PropertyFactory.getString("in_demHolyItem"));
        this.lblHolyItem.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demHolyItem"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlHolyItem.add((Component)this.lblHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 1.0;
        this.pnlHolyItem.add((Component)this.txtHolyItem, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlHolyItem, gridBagConstraints);
        this.pnlDeityAlignment.setLayout(new GridBagLayout());
        this.lblDeityAlignment.setLabelFor(this.cmbDeityAlignment);
        this.lblDeityAlignment.setText(PropertyFactory.getString("in_demDeityAlign"));
        this.lblDeityAlignment.setDisplayedMnemonic(PropertyFactory.getMnemonic("in_mn_demDeityAlign"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.lblDeityAlignment, gridBagConstraints);
        this.cmbDeityAlignment.setPreferredSize(new Dimension(180, 25));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.pnlDeityAlignment.add((Component)this.cmbDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlDeityAlignment, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlDescription, gridBagConstraints);
        this.pnlFavoredWeapons.setHeader(PropertyFactory.getString("in_demFavWea"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlFavoredWeapons, gridBagConstraints);
    }
}

