/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.content.ChallengeRating;
import pcgen.cdom.content.LevelCommandFactory;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.RaceType;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.formula.FixedSizeFormula;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.Race;
import pcgen.core.SizeAdjustment;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.rules.context.LoadContext;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RaceBasePanel
extends BasePanel {
    private static final String[] sizeTitles = new String[]{"Fine", "Diminutive", "Tiny", "Small", "Medium", "Large", "Huge", "Gargantuan", "Colossal"};
    private static final String[] sizeAbbrev = new String[]{"F", "D", "T", "S", "M", "L", "H", "G", "C"};
    private static final String[] crValues = new String[]{"1/10", "1/8", "1/6", "1/4", "1/3", "1/2", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20"};
    private JComboBoxEx cmbBonusFeats;
    private JComboBoxEx cmbBonusSkillPoints;
    private JComboBoxEx cmbCR;
    private JComboBoxEx cmbHands;
    private JComboBoxEx cmbLegs;
    private JComboBoxEx cmbMonsterClass;
    private JComboBoxEx cmbMonsterLevel;
    private JComboBoxEx cmbRaceType;
    private JComboBoxEx cmbReach;
    private JComboBoxEx cmbSize;
    private JComboBoxEx cmbSkillMult;
    private JPanel pnlTemplateMisc;
    private JTextField txtDisplayName;
    private JTextField txtHitDiceAdvancement;
    private JTextField txtLevelAdj;
    private TypePanel pnlTemplateTypes;

    public RaceBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setBonusFeats(int n) {
        if (n >= 0 && n < this.cmbBonusFeats.getItemCount()) {
            this.cmbBonusFeats.setSelectedIndex(n);
        }
    }

    public int getBonusFeats() {
        return this.cmbBonusFeats.getSelectedIndex();
    }

    public void setBonusSkillPoints(int n) {
        if (n >= 0 && n < this.cmbBonusSkillPoints.getItemCount()) {
            this.cmbBonusSkillPoints.setSelectedIndex(n);
        }
    }

    public int getBonusSkillPoints() {
        return this.cmbBonusSkillPoints.getSelectedIndex();
    }

    public void setCR(ChallengeRating challengeRating) {
        if (challengeRating != null) {
            this.cmbCR.setSelectedItem(challengeRating.getRating().toString());
        }
    }

    public ChallengeRating getCR() {
        String string = null;
        try {
            string = this.cmbCR.getSelectedItem().toString();
            if (string == null) {
                return null;
            }
            return new ChallengeRating(string);
        }
        catch (NumberFormatException numberFormatException) {
            Logging.errorPrint("Couldn't figure out what CR " + string + " means, returning CR of 0.");
            return null;
        }
    }

    public void setDisplayName(String string) {
        this.txtDisplayName.setText(string);
    }

    public String getDisplayName() {
        return this.txtDisplayName.getText();
    }

    public void setHands(int n) {
        if (n >= 0 && n < this.cmbHands.getItemCount()) {
            this.cmbHands.setSelectedIndex(n);
        }
    }

    public int getHands() {
        return this.cmbHands.getSelectedIndex();
    }

    public void setHitDiceAdvancement(Race race) {
        LoadContext loadContext = Globals.getContext();
        String[] stringArray = loadContext.unparseSubtoken(race, "HITDICE");
        if (stringArray != null) {
            if (stringArray.length == 1) {
                this.txtHitDiceAdvancement.setText(stringArray[0]);
            } else {
                Logging.errorPrint("Found more than one HITDICEADVANCEMENT in " + race.getDisplayName());
            }
        }
    }

    public void setLegs(int n) {
        if (n >= 0 && n < this.cmbLegs.getItemCount()) {
            this.cmbLegs.setSelectedIndex(n);
        }
    }

    public int getLegs() {
        return this.cmbLegs.getSelectedIndex();
    }

    public void setLevelAdjustment(String string) {
        this.txtLevelAdj.setText(string);
    }

    public Formula getLevelAdjustment() {
        return FormulaFactory.getFormulaFor(this.txtLevelAdj.getText());
    }

    public void setMonsterClass(String string) {
        if (string == null || string.length() == 0) {
            this.cmbMonsterClass.setSelectedItem("(None)");
        } else {
            this.cmbMonsterClass.setSelectedItem(string);
        }
    }

    public String getMonsterClass() {
        return (String)this.cmbMonsterClass.getSelectedItem();
    }

    public void setMonsterClassList(List<String> list) {
        this.cmbMonsterClass.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
    }

    public void setMonsterLevel(int n) {
        if (n >= 0 && n < this.cmbMonsterLevel.getItemCount()) {
            this.cmbMonsterLevel.setSelectedIndex(n);
        }
    }

    public int getMonsterLevel() {
        return this.cmbMonsterLevel.getSelectedIndex();
    }

    public void setRaceSize(Formula formula) {
        this.cmbSize.setSelectedIndex(0);
        if (formula == null) {
            return;
        }
        String string = formula.toString();
        for (int i = 0; i < sizeAbbrev.length; ++i) {
            if (!sizeAbbrev[i].equals(string)) continue;
            this.cmbSize.setSelectedIndex(i);
            break;
        }
    }

    public SizeAdjustment getRaceSize() {
        int n = this.cmbSize.getSelectedIndex();
        if (n >= 0 && n < sizeAbbrev.length) {
            String string = sizeAbbrev[n];
            return Globals.getContext().ref.getAbbreviatedObject(SizeAdjustment.class, string);
        }
        return null;
    }

    public void setRaceType(String string) {
        this.cmbRaceType.setSelectedItem(string);
    }

    public String getRaceType() {
        return (String)this.cmbRaceType.getSelectedItem();
    }

    public void setReach(int n) {
        this.cmbReach.setSelectedItem(String.valueOf(n));
    }

    public int getReach() {
        return Integer.parseInt((String)this.cmbReach.getSelectedItem());
    }

    public void setSkillMultiplier(int n) {
        if (n >= 0 && n < this.cmbSkillMult.getItemCount()) {
            this.cmbSkillMult.setSelectedIndex(n);
        }
    }

    public int getSkillMultiplier() {
        return this.cmbSkillMult.getSelectedIndex();
    }

    public void setTypesAvailableList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    @Override
    public void updateData(PObject pObject) {
        Race race = (Race)pObject;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("FEAT|POOL|").append(this.getBonusFeats());
        BonusObj bonusObj = Bonus.newBonus(stringBuffer.toString());
        race.addToListFor(ListKey.BONUS, bonusObj);
        if (this.getBonusSkillPoints() > 0) {
            race.put(IntegerKey.SKILL_POINTS_PER_LEVEL, this.getBonusSkillPoints());
        } else {
            race.remove(IntegerKey.SKILL_POINTS_PER_LEVEL);
        }
        race.put(ObjectKey.CHALLENGE_RATING, this.getCR());
        if (this.getDisplayName() != null && this.getDisplayName().trim().length() > 0) {
            race.setDisplayName(this.getDisplayName());
        }
        race.put(IntegerKey.CREATURE_HANDS, this.getHands());
        LoadContext loadContext = Globals.getContext();
        if (this.txtHitDiceAdvancement.getText().trim().length() > 0) {
            loadContext.unconditionallyProcess(race, "HITDICEADVANCEMENT", this.txtHitDiceAdvancement.getText());
        }
        race.put(IntegerKey.LEGS, this.getLegs());
        race.put(FormulaKey.LEVEL_ADJUSTMENT, this.getLevelAdjustment());
        loadContext.unconditionallyProcess(race, "MONSTERCLASS", this.getMonsterClass() + ":" + this.getMonsterLevel());
        race.put(FormulaKey.SIZE, (Formula)new FixedSizeFormula(this.getRaceSize()));
        race.put(IntegerKey.REACH, this.getReach());
        race.put(IntegerKey.INITIAL_SKILL_MULT, this.getSkillMultiplier());
        race.put(ObjectKey.RACETYPE, RaceType.getConstant((String)this.cmbRaceType.getSelectedItem()));
        pObject.removeListFor(ListKey.TYPE);
        for (Object object : this.getTypesSelectedList()) {
            pObject.addToListFor(ListKey.TYPE, Type.getConstant(object.toString()));
        }
    }

    @Override
    public void updateView(PObject pObject) {
        Race race = (Race)pObject;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        for (Race comparable2 : Globals.getContext().ref.getConstructedCDOMObjects(Race.class)) {
            for (Type type : comparable2.getTrueTypeList(false)) {
                if (type.equals(Type.CUSTOM) || arrayList.contains(type)) continue;
                arrayList.add(type);
            }
        }
        for (Type type : race.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        Collection<RaceType> collection = RaceType.getAllConstants();
        RaceType[] raceTypeArray2 = new RaceType[collection.size()];
        raceTypeArray2 = collection.toArray(raceTypeArray2);
        String[] stringArray = new String[raceTypeArray2.length];
        for (int i = 0; i < raceTypeArray2.length; ++i) {
            stringArray[i] = raceTypeArray2[i].toString();
        }
        this.cmbRaceType.setModel(new DefaultComboBoxModel<String>(stringArray));
        RaceType raceType = race.get(ObjectKey.RACETYPE);
        if (raceType != null) {
            this.cmbRaceType.setSelectedItem(raceType.toString());
        }
        ArrayList<String> arrayList3 = new ArrayList<String>();
        arrayList3.add("(None)");
        for (PCClass pCClass : Globals.getContext().ref.getConstructedCDOMObjects(PCClass.class)) {
            if (!pCClass.isMonster()) continue;
            arrayList3.add(pCClass.getKeyName());
        }
        this.setMonsterClassList(arrayList3);
        this.setBonusFeats(0);
        this.setBonusSkillPoints(race.getSafe(IntegerKey.SKILL_POINTS_PER_LEVEL));
        this.setCR(race.get(ObjectKey.CHALLENGE_RATING));
        this.setDisplayName(race.getDisplayName());
        this.setHands(race.getSafe(IntegerKey.CREATURE_HANDS));
        this.setHitDiceAdvancement(race);
        this.setLegs(race.getSafe(IntegerKey.LEGS));
        this.setLevelAdjustment(race.getSafe(FormulaKey.LEVEL_ADJUSTMENT).toString());
        LevelCommandFactory levelCommandFactory = race.get(ObjectKey.MONSTER_CLASS);
        if (levelCommandFactory != null) {
            this.setMonsterClass(levelCommandFactory.getPCClass().getKeyName());
            this.setMonsterLevel(levelCommandFactory.getLevelCount().resolve(null, "").intValue());
        }
        this.setRaceSize(race.get(FormulaKey.SIZE));
        this.setReach(race.getSafe(IntegerKey.REACH));
        this.setSkillMultiplier(race.getSafe(IntegerKey.INITIAL_SKILL_MULT));
    }

    private static GridBagConstraints buildConstraints(int n, int n2) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.1;
        return gridBagConstraints;
    }

    private void initComponentContents() {
        int n;
        this.cmbSize.setModel(new DefaultComboBoxModel<String>(sizeTitles));
        String[] stringArray = new String[20];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n);
        }
        this.cmbBonusSkillPoints.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbBonusFeats.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbLegs.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbHands.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbSkillMult.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[10];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n * 5);
        }
        this.cmbReach.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[40];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n);
        }
        this.cmbMonsterLevel.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbCR.setModel(new DefaultComboBoxModel<String>(crValues));
    }

    private void initComponents() {
        this.cmbBonusSkillPoints = new JComboBoxEx();
        this.cmbBonusFeats = new JComboBoxEx();
        this.cmbCR = new JComboBoxEx();
        this.txtDisplayName = new JTextField();
        this.cmbHands = new JComboBoxEx();
        this.txtHitDiceAdvancement = new JTextField();
        this.cmbLegs = new JComboBoxEx();
        this.txtLevelAdj = new JTextField();
        this.cmbMonsterClass = new JComboBoxEx();
        this.cmbMonsterLevel = new JComboBoxEx();
        this.cmbRaceType = new JComboBoxEx();
        this.cmbReach = new JComboBoxEx();
        this.cmbSize = new JComboBoxEx();
        this.cmbSkillMult = new JComboBoxEx();
        this.pnlTemplateMisc = new JPanel();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlTemplateMisc.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Display Name");
        GridBagConstraints gridBagConstraints = RaceBasePanel.buildConstraints(0, 0);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 0);
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtDisplayName, gridBagConstraints);
        jLabel = new JLabel("Hands");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 1);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbHands, gridBagConstraints);
        jLabel = new JLabel("Legs");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 1);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 1);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbLegs, gridBagConstraints);
        jLabel = new JLabel("Reach");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 2);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbReach, gridBagConstraints);
        jLabel = new JLabel("Skill Multiplier");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 2);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 2);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSkillMult, gridBagConstraints);
        jLabel = new JLabel("Bonus Skill Pts / Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 3);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusSkillPoints, gridBagConstraints);
        jLabel = new JLabel("Bonus Starting Feats");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 3);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 3);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusFeats, gridBagConstraints);
        jLabel = new JLabel("CR");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 4);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        this.cmbCR.setEditable(true);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbCR, gridBagConstraints);
        jLabel = new JLabel("Level Adjustment");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 4);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 4);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtLevelAdj, gridBagConstraints);
        jLabel = new JLabel("Size");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 5);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSize, gridBagConstraints);
        jLabel = new JLabel("Hit Dice Advancement");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 5);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtHitDiceAdvancement, gridBagConstraints);
        jLabel = new JLabel("Monster Class");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 6);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterClass, gridBagConstraints);
        jLabel = new JLabel("Monster Level");
        gridBagConstraints = RaceBasePanel.buildConstraints(2, 6);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = RaceBasePanel.buildConstraints(3, 6);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbMonsterLevel, gridBagConstraints);
        jLabel = new JLabel("Race Type");
        gridBagConstraints = RaceBasePanel.buildConstraints(0, 7);
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        this.cmbRaceType.setEditable(true);
        gridBagConstraints = RaceBasePanel.buildConstraints(1, 7);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbRaceType, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlTemplateMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

