/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.editor;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import pcgen.base.formula.Formula;
import pcgen.cdom.base.FormulaFactory;
import pcgen.cdom.enumeration.FormulaKey;
import pcgen.cdom.enumeration.Gender;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SubRace;
import pcgen.cdom.enumeration.SubRegion;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.formula.FixedSizeFormula;
import pcgen.core.Globals;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.SizeAdjustment;
import pcgen.gui.editor.BasePanel;
import pcgen.gui.editor.TypePanel;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Visibility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TemplateBasePanel
extends BasePanel {
    private static final String[] genderLockValues = new String[]{"None", "Male", "Female", "Neuter"};
    private static final String[] visibleValues = new String[]{"No", "Yes", "Export", "Display"};
    private static final String[] sizeTitles = new String[]{"(no change)", "Fine", "Diminutive", "Tiny", "Small", "Medium", "Large", "Huge", "Gargantuan", "Colossal"};
    private static final String[] sizeAbbrev = new String[]{"", "F", "D", "T", "S", "M", "L", "H", "G", "C"};
    private JCheckBox chkRemovable;
    private JComboBoxEx cmbBonusSkillPoints;
    private JComboBoxEx cmbGenderLock;
    private JComboBoxEx cmbNonProficiencyPenalty;
    private JComboBoxEx cmbSize;
    private JComboBoxEx cmbVisible;
    private JPanel pnlTemplateMisc;
    private JTextField txtCR;
    private JTextField txtLevelAdj;
    private JTextField txtSubRace;
    private JTextField txtSubRegion;
    private TypePanel pnlTemplateTypes;

    public TemplateBasePanel() {
        this.initComponents();
        this.initComponentContents();
    }

    public void setBonusSkillPoints(int n) {
        if (n >= 0 && n < this.cmbBonusSkillPoints.getItemCount()) {
            this.cmbBonusSkillPoints.setSelectedIndex(n);
        }
    }

    public int getBonusSkillPoints() {
        return this.cmbBonusSkillPoints.getSelectedIndex();
    }

    public void setCR(float f) {
        this.txtCR.setText(String.valueOf(f));
    }

    public float getCR() {
        return Float.parseFloat(this.txtCR.getText());
    }

    public void setGenderLock(String string) {
        if (string.length() == 0) {
            this.cmbGenderLock.setSelectedItem("None");
        } else {
            for (int i = genderLockValues.length - 1; i >= 0; --i) {
                if (!genderLockValues[i].equals(string)) continue;
                this.cmbGenderLock.setSelectedItem(genderLockValues[i]);
                break;
            }
        }
    }

    public String getGenderLock() {
        return (String)this.cmbGenderLock.getSelectedItem();
    }

    public void setIsRemovable(boolean bl) {
        this.chkRemovable.setSelected(bl);
    }

    public boolean getIsRemovable() {
        return this.chkRemovable.isSelected();
    }

    public void setLevelAdjustment(Formula formula) {
        this.txtLevelAdj.setText(formula == null ? "" : formula.toString());
    }

    public String getLevelAdjustment() {
        return this.txtLevelAdj.getText();
    }

    public void setNonProficiencyPenalty(int n) {
        int n2 = n > 0 ? 0 : -n + 1;
        if (n2 >= this.cmbNonProficiencyPenalty.getItemCount()) {
            n2 = -1;
        }
        this.cmbNonProficiencyPenalty.setSelectedIndex(n2);
    }

    public int getNonProficiencyPenalty() {
        int n = this.cmbNonProficiencyPenalty.getSelectedIndex();
        n = n == 0 ? 1 : -(n - 1);
        return n;
    }

    public void setSubRace(String string) {
        if ("None".equals(string) || string == null || "".equals(string)) {
            this.txtSubRace.setText("");
        } else {
            this.txtSubRace.setText(string);
        }
    }

    public String getSubRace() {
        if (this.txtSubRace.getText() == null || this.txtSubRace.getText().trim().length() == 0) {
            return "None";
        }
        return this.txtSubRace.getText();
    }

    public void setSubRegion(String string) {
        if ("None".equals(string) || string == null || "".equals(string)) {
            this.txtSubRegion.setText("");
        } else {
            this.txtSubRegion.setText(string);
        }
    }

    public String getSubRegion() {
        if (this.txtSubRegion.getText() == null || this.txtSubRegion.getText().trim().length() == 0) {
            return "None";
        }
        return this.txtSubRegion.getText();
    }

    public void setTemplateSize(Formula formula) {
        this.cmbSize.setSelectedIndex(0);
        if (formula == null) {
            return;
        }
        for (int i = 0; i < sizeAbbrev.length; ++i) {
            if (!sizeAbbrev[i].equals(formula.toString())) continue;
            this.cmbSize.setSelectedIndex(i);
            break;
        }
    }

    public String getTemplateSize() {
        int n = this.cmbSize.getSelectedIndex();
        if (n >= 0 && n < sizeAbbrev.length) {
            return sizeAbbrev[n];
        }
        return "";
    }

    public void setTypesAvailableList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setAvailableList(list, bl);
    }

    public void setTypesSelectedList(List<Type> list, boolean bl) {
        this.pnlTemplateTypes.setSelectedList(list, bl);
    }

    public Object[] getTypesSelectedList() {
        return this.pnlTemplateTypes.getSelectedList();
    }

    public void setVisible(Visibility visibility) {
        this.cmbVisible.setSelectedIndex(visibility.ordinal());
    }

    public Visibility getVisible() {
        return Visibility.values()[this.cmbVisible.getSelectedIndex()];
    }

    @Override
    public void updateData(PObject pObject) {
        Object object;
        PCTemplate pCTemplate = (PCTemplate)pObject;
        pCTemplate.put(ObjectKey.REMOVABLE, this.getIsRemovable());
        try {
            object = Gender.valueOf(this.getGenderLock());
            pCTemplate.put(ObjectKey.GENDER_LOCK, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        pCTemplate.put(ObjectKey.VISIBILITY, this.getVisible());
        object = this.getSubRegion();
        if (((String)object).equals(pCTemplate.getDisplayName())) {
            pCTemplate.put(ObjectKey.USETEMPLATENAMEFORSUBREGION, true);
            pCTemplate.put(ObjectKey.SUBREGION, null);
        } else {
            pCTemplate.put(ObjectKey.USETEMPLATENAMEFORSUBREGION, null);
            pCTemplate.put(ObjectKey.SUBREGION, SubRegion.getConstant((String)object));
        }
        String string = this.getSubRace();
        if (string.equals(pCTemplate.getDisplayName())) {
            pCTemplate.put(ObjectKey.USETEMPLATENAMEFORSUBRACE, true);
            pCTemplate.put(ObjectKey.SUBRACE, null);
        } else {
            pCTemplate.put(ObjectKey.USETEMPLATENAMEFORSUBRACE, null);
            pCTemplate.put(ObjectKey.SUBRACE, SubRace.getConstant(string));
        }
        if (this.getBonusSkillPoints() != 0) {
            pCTemplate.put(IntegerKey.BONUS_CLASS_SKILL_POINTS, this.getBonusSkillPoints());
        }
        pCTemplate.put(ObjectKey.CR_MODIFIER, new BigDecimal(this.getCR()));
        if (this.getLevelAdjustment() != null && this.getLevelAdjustment().length() > 0) {
            pCTemplate.put(FormulaKey.LEVEL_ADJUSTMENT, FormulaFactory.getFormulaFor(this.getLevelAdjustment()));
        }
        pCTemplate.put(IntegerKey.NONPP, this.getNonProficiencyPenalty());
        String string2 = this.getTemplateSize();
        SizeAdjustment sizeAdjustment = Globals.getContext().ref.getAbbreviatedObject(SizeAdjustment.class, string2);
        Formula formula = null;
        if (sizeAdjustment == null) {
            if (string2 != null && string2.length() > 0) {
                formula = FormulaFactory.getFormulaFor(string2);
            }
        } else {
            formula = new FixedSizeFormula(sizeAdjustment);
        }
        if (formula != null) {
            pCTemplate.put(FormulaKey.SIZE, formula);
        }
        pObject.removeListFor(ListKey.TYPE);
        for (Object object2 : this.getTypesSelectedList()) {
            pObject.addToListFor(ListKey.TYPE, Type.getConstant(object2.toString()));
        }
    }

    @Override
    public void updateView(PObject pObject) {
        PCTemplate pCTemplate = (PCTemplate)pObject;
        ArrayList<Type> arrayList = new ArrayList<Type>();
        ArrayList<Type> arrayList2 = new ArrayList<Type>();
        for (PCTemplate comparable : Globals.getContext().ref.getConstructedCDOMObjects(PCTemplate.class)) {
            for (Type type : comparable.getTrueTypeList(false)) {
                if (type.equals(Type.CUSTOM) || arrayList.contains(type)) continue;
                arrayList.add(type);
            }
        }
        for (Type type : pCTemplate.getTrueTypeList(false)) {
            if (type.equals(Type.CUSTOM)) continue;
            arrayList2.add(type);
            arrayList.remove(type);
        }
        this.setTypesAvailableList(arrayList, true);
        this.setTypesSelectedList(arrayList2, true);
        this.setIsRemovable(pCTemplate.isRemovable());
        Gender gender = pCTemplate.get(ObjectKey.GENDER_LOCK);
        if (gender == null) {
            this.setGenderLock("None");
        } else {
            this.setGenderLock(gender.toString());
        }
        this.setVisible(pCTemplate.getSafe(ObjectKey.VISIBILITY));
        this.setSubRegion(pCTemplate.getSubRegion());
        this.setSubRace(pCTemplate.getSubRace());
        this.setBonusSkillPoints(pCTemplate.getSafe(IntegerKey.BONUS_CLASS_SKILL_POINTS));
        this.setNonProficiencyPenalty(pCTemplate.getSafe(IntegerKey.NONPP));
        this.setCR(pCTemplate.getCR(-1, -1));
        this.setLevelAdjustment(pCTemplate.get(FormulaKey.LEVEL_ADJUSTMENT));
        this.setTemplateSize(pCTemplate.get(FormulaKey.SIZE));
    }

    private void initComponentContents() {
        int n;
        this.cmbGenderLock.setModel(new DefaultComboBoxModel<String>(genderLockValues));
        this.cmbVisible.setModel(new DefaultComboBoxModel<String>(visibleValues));
        String[] stringArray = new String[20];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = String.valueOf(n);
        }
        this.cmbBonusSkillPoints.setModel(new DefaultComboBoxModel<String>(stringArray));
        stringArray = new String[11];
        stringArray[0] = "(no change)";
        for (n = 0; n < stringArray.length - 1; ++n) {
            stringArray[n + 1] = String.valueOf(-n);
        }
        this.cmbNonProficiencyPenalty.setModel(new DefaultComboBoxModel<String>(stringArray));
        this.cmbSize.setModel(new DefaultComboBoxModel<String>(sizeTitles));
    }

    private void initComponents() {
        this.pnlTemplateMisc = new JPanel();
        this.chkRemovable = new JCheckBox();
        this.cmbGenderLock = new JComboBoxEx();
        this.cmbBonusSkillPoints = new JComboBoxEx();
        this.cmbNonProficiencyPenalty = new JComboBoxEx();
        this.cmbVisible = new JComboBoxEx();
        this.txtCR = new JTextField();
        this.txtLevelAdj = new JTextField();
        this.cmbSize = new JComboBoxEx();
        this.txtSubRegion = new JTextField();
        this.txtSubRace = new JTextField();
        this.pnlTemplateTypes = new TypePanel(PropertyFactory.getString("in_demEnterNewType"));
        this.setLayout(new GridBagLayout());
        this.pnlTemplateMisc.setLayout(new GridBagLayout());
        JLabel jLabel = new JLabel("Visible");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbVisible, gridBagConstraints);
        jLabel = new JLabel("Removable");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.chkRemovable, gridBagConstraints);
        jLabel = new JLabel("Gender Locked");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbGenderLock, gridBagConstraints);
        jLabel = new JLabel("Wpn Non Prof Penalty");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbNonProficiencyPenalty, gridBagConstraints);
        jLabel = new JLabel("Bonus Skill Pts / Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbBonusSkillPoints, gridBagConstraints);
        jLabel = new JLabel("CR");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtCR, gridBagConstraints);
        jLabel = new JLabel("Level Adjustment");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtLevelAdj, gridBagConstraints);
        jLabel = new JLabel("Size");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.cmbSize, gridBagConstraints);
        jLabel = new JLabel("Sub Race");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtSubRace, gridBagConstraints);
        jLabel = new JLabel("Sub Region");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 0.1;
        this.pnlTemplateMisc.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        gridBagConstraints.weightx = 0.4;
        this.pnlTemplateMisc.add((Component)this.txtSubRegion, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pnlTemplateMisc, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.pnlTemplateTypes, gridBagConstraints);
    }
}

