/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.PropertyFactory;

public class FlippingSplitPane
extends JSplitPane {
    static final long serialVersionUID = -6343545558990369582L;
    private static final ImageIcon CENTER_ICON = Utilities.getImageIcon("resources/MediaStop16.gif");
    private static final ImageIcon FLIP_ICON = Utilities.getImageIcon("resources/Refresh16.gif");
    private static final ImageIcon RESET_ICON = Utilities.getImageIcon("resources/Redo16.gif");
    private static final ImageIcon LOCK_ICON = Utilities.getImageIcon("resources/Bookmarks16.gif");
    private boolean locked = false;
    private boolean wasContinuousLayout = false;

    public FlippingSplitPane() {
        this.setupExtensions();
    }

    public FlippingSplitPane(int n) {
        super(n);
        this.setupExtensions();
    }

    public FlippingSplitPane(int n, boolean bl) {
        super(n, bl);
        this.setupExtensions();
    }

    public FlippingSplitPane(int n, Component component, Component component2) {
        super(n, component, component2);
        this.setupExtensions();
    }

    public FlippingSplitPane(int n, boolean bl, Component component, Component component2) {
        super(n, bl, component, component2);
        this.setupExtensions();
    }

    public void setContinuousLayout(boolean bl) {
        if (bl == this.isContinuousLayout()) {
            return;
        }
        super.setContinuousLayout(bl);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getLeftComponent(), bl);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getRightComponent(), bl);
    }

    public void setDividerLocation(int n) {
        if (this.isLocked()) {
            super.setDividerLocation(this.getLastDividerLocation());
        } else {
            super.setDividerLocation(n);
        }
    }

    public void setOneTouchExpandable(boolean bl) {
        if (bl == this.isOneTouchExpandable()) {
            return;
        }
        super.setOneTouchExpandable(bl);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getLeftComponent(), bl);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getRightComponent(), bl);
    }

    public void setOrientation(int n) {
        if (n == this.getOrientation()) {
            return;
        }
        super.setOrientation(n);
        int n2 = FlippingSplitPane.invertOrientation(n);
        FlippingSplitPane.maybeSetOrientationComponent(this.getLeftComponent(), n2);
        FlippingSplitPane.maybeSetOrientationComponent(this.getRightComponent(), n2);
    }

    public void resetToPreferredSizes() {
        this.fixedResetToPreferredSizes();
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getLeftComponent());
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getRightComponent());
    }

    private static void maybeCenterDividerLocationsComponent(Component component) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).centerDividerLocations();
        }
    }

    private void centerDividerLocations() {
        this.setDividerLocation(0.5);
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getLeftComponent());
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getRightComponent());
    }

    private static void maybeResetToPreferredSizesComponent(Component component) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).resetToPreferredSizes();
        }
    }

    private void fixedResetToPreferredSizes() {
        this.setDividerLocation((this.getMinimumDividerLocation() + this.getMaximumDividerLocation()) / 2);
    }

    private static int invertOrientation(int n) {
        return n == 1 ? 0 : 1;
    }

    private static void maybeFlipComponent(Component component) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).flipOrientation();
        }
    }

    private void flipOrientation() {
        super.setOrientation(FlippingSplitPane.invertOrientation(this.getOrientation()));
        FlippingSplitPane.maybeFlipComponent(this.getLeftComponent());
        FlippingSplitPane.maybeFlipComponent(this.getRightComponent());
        this.resetToPreferredSizes();
    }

    private static void maybeSetContinuousLayoutComponent(Component component, boolean bl) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).setContinuousLayout(bl);
        }
    }

    private static void maybeSetOneTouchExpandableComponent(Component component, boolean bl) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).setOneTouchExpandable(bl);
        }
    }

    private static void maybeSetOrientationComponent(Component component, int n) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).setOrientation(n);
        }
    }

    private boolean isLocked() {
        return this.locked;
    }

    private static void maybeSetLockedComponent(Component component, boolean bl) {
        if (component instanceof FlippingSplitPane) {
            ((FlippingSplitPane)component).setLocked(bl);
        }
    }

    private void setLocked(boolean bl) {
        if (bl == this.isLocked()) {
            return;
        }
        this.locked = bl;
        if (this.locked) {
            this.wasContinuousLayout = this.isContinuousLayout();
            this.setContinuousLayout(true);
        } else {
            this.setContinuousLayout(this.wasContinuousLayout);
        }
        FlippingSplitPane.maybeSetLockedComponent(this.getLeftComponent(), this.isLocked());
        FlippingSplitPane.maybeSetLockedComponent(this.getRightComponent(), this.isLocked());
    }

    private void setupExtensions() {
        SplitPaneUI splitPaneUI = this.getUI();
        if (splitPaneUI instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)splitPaneUI).getDivider().addMouseListener(new PopupListener());
        }
        this.setResizeWeight(0.5);
    }

    private static void addPopupMenuItems(JPopupMenu jPopupMenu, MouseEvent mouseEvent) {
    }

    private class ResetMenuItem
    extends JMenuItem {
        ResetMenuItem() {
            super(PropertyFactory.getString("in_reset"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_reset"));
            this.setIcon(RESET_ICON);
            this.addActionListener(new ResetActionListener());
        }
    }

    private class ResetActionListener
    implements ActionListener {
        private ResetActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.resetToPreferredSizes();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (Utilities.isRightMouseButton(mouseEvent)) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                JPopupMenu jPopupMenu = new JPopupMenu();
                if (!FlippingSplitPane.this.isLocked()) {
                    jPopupMenu.add(new CenterMenuItem());
                    jPopupMenu.add(new FlipMenuItem());
                    jPopupMenu.add(new ResetMenuItem());
                    jPopupMenu.addSeparator();
                }
                jPopupMenu.add(new LockMenuItem());
                if (!FlippingSplitPane.this.isLocked()) {
                    jPopupMenu.addSeparator();
                    jPopupMenu.add(new OptionsMenu());
                }
                FlippingSplitPane.addPopupMenuItems(jPopupMenu, mouseEvent);
                jPopupMenu.show(mouseEvent.getComponent(), n, n2);
            } else if (Utilities.isShiftLeftMouseButton(mouseEvent) && !FlippingSplitPane.this.isLocked()) {
                FlippingSplitPane.this.flipOrientation();
            }
        }
    }

    private class OptionsMenu
    extends JMenu {
        OptionsMenu() {
            super(PropertyFactory.getString("in_options"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_options"));
            this.add(new OneTouchExpandableMenuItem());
            this.add(new ContinuousLayoutMenuItem());
        }
    }

    private class OneTouchExpandableMenuItem
    extends JCheckBoxMenuItem {
        OneTouchExpandableMenuItem() {
            super(PropertyFactory.getString("in_oneTouchExp"));
            boolean bl = FlippingSplitPane.this.isOneTouchExpandable();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_oneTouchExp"));
            this.setSelected(bl);
            this.addActionListener(new OneTouchExpandableActionListener(!bl));
        }
    }

    private class OneTouchExpandableActionListener
    implements ActionListener {
        private boolean aOneTouchExpandable;

        OneTouchExpandableActionListener(boolean bl) {
            this.aOneTouchExpandable = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.setOneTouchExpandable(this.aOneTouchExpandable);
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem() {
            boolean bl = !FlippingSplitPane.this.isLocked();
            this.setText(bl ? PropertyFactory.getString("in_lock") : PropertyFactory.getString("in_unlock"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(LOCK_ICON);
            this.addActionListener(new LockActionListener(bl));
        }
    }

    private class LockActionListener
    implements ActionListener {
        private boolean aLocked;

        LockActionListener(boolean bl) {
            this.aLocked = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.setLocked(this.aLocked);
        }
    }

    private class FlipMenuItem
    extends JMenuItem {
        FlipMenuItem() {
            super(PropertyFactory.getString("in_flip"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_flip"));
            this.setIcon(FLIP_ICON);
            this.addActionListener(new FlipActionListener());
        }
    }

    private class FlipActionListener
    implements ActionListener {
        private FlipActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.flipOrientation();
        }
    }

    private class ContinuousLayoutMenuItem
    extends JCheckBoxMenuItem {
        ContinuousLayoutMenuItem() {
            super(PropertyFactory.getString("in_smothRes"));
            boolean bl = FlippingSplitPane.this.isContinuousLayout();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_smothRes"));
            this.setSelected(bl);
            this.addActionListener(new ContinuousLayoutActionListener(!bl));
        }
    }

    private class ContinuousLayoutActionListener
    implements ActionListener {
        boolean aContinuousLayout;

        ContinuousLayoutActionListener(boolean bl) {
            this.aContinuousLayout = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.setContinuousLayout(this.aContinuousLayout);
        }
    }

    private class CenterMenuItem
    extends JMenuItem {
        CenterMenuItem() {
            super(PropertyFactory.getString("in_center"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_center"));
            this.setIcon(CENTER_ICON);
            this.addActionListener(new CenterActionListener());
        }
    }

    private class CenterActionListener
    implements ActionListener {
        private CenterActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            FlippingSplitPane.this.centerDividerLocations();
        }
    }
}

