/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.base.CDOMObject;
import pcgen.cdom.content.CampaignURL;
import pcgen.cdom.enumeration.IntegerKey;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PersistenceObserver;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.sources.PCCCreator;
import pcgen.gui.sources.SourceSelectionUtils;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.persistence.lst.CampaignSourceEntry;
import pcgen.persistence.lst.SponsorLoader;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainSource
extends FilterAdapterPanel {
    public static final String SOURCE_MATERIALS_TAB = "Select and load source materials";
    static final long serialVersionUID = -2654080650560664447L;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_BOOKTYPE = 1;
    private static final int COL_LOADED = 2;
    private static final int VIEW_PRODUCT = 0;
    private static final int VIEW_PUBLISH = 1;
    private static final int VIEW_PUBSET = 2;
    private static final int VIEW_PUBFMTSET = 3;
    private static int viewMode = 3;
    private static int viewSelectMode = 0;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECT = 1;
    private final JLabel avaLabel = new JLabel();
    private final JLabel selLabel = new JLabel();
    private transient CampaignModel availableModel = null;
    private transient CampaignModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton leftButton;
    private JButton loadButton = new JButton();
    private JButton refreshButton = new JButton();
    private JButton removeAllButton;
    private JButton rightButton;
    private JButton unloadAllButton = new JButton();
    private JButton websiteButton;
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel;
    private JPanel bLeftPane;
    private JPanel center = new JPanel();
    private JPanel jPanel1n = new JPanel();
    private JPanel jPanel1s = new JPanel();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private List<Campaign> selectedCampaigns = new ArrayList<Campaign>();
    private PObjectNode lastSelection = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private boolean sourcesLoaded = false;
    private final JLabel lblQFilter = new JLabel("Filter:");
    private JTextField textQFilter = new JTextField();
    private JButton clearQFilterButton = new JButton("Clear");
    private static Integer saveViewMode = null;
    private boolean sourceBuilderMode;
    private int selRow;

    public MainSource(boolean bl) {
        this.setName(Tab.SOURCES.toString());
        this.sourceBuilderMode = bl;
        try {
            this.initComponents();
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog("Error in MainSource whilst initialising:\n " + exception.toString() + "\n" + "PCGen may not operate correctly as a result of this error. ", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Error initialising MainSource: " + exception.toString(), exception);
        }
        this.initActionListeners();
        if (!bl) {
            FilterFactory.restoreFilterSettings(this);
        }
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    public void changedGameMode() {
        this.selectedCampaigns.clear();
        this.unloadAllCampaigns_actionPerformed();
        List<URI> list = PersistenceManager.getInstance().getChosenCampaignSourcefiles();
        if (!list.isEmpty()) {
            this.selectCampaignsByURI(list);
        } else {
            this.selectDefaultCampaigns();
        }
    }

    private void selectDefaultCampaigns() {
        GameMode gameMode = SettingsHandler.getGame();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!gameMode.getDefaultDataSetList().isEmpty()) {
            arrayList.addAll(gameMode.getDefaultDataSetList());
        }
        for (String string : arrayList) {
            Campaign campaign = Globals.getCampaignKeyed(string);
            if (campaign == null || this.selectedCampaigns.contains(campaign)) continue;
            this.selectedCampaigns.add(campaign);
        }
        Collections.sort(this.selectedCampaigns);
        this.updateModels();
        this.rememberSourceChanges();
    }

    @Override
    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    public void refreshCampaigns() {
        PersistenceManager.getInstance().refreshCampaigns();
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>();
        for (Campaign campaign : this.selectedCampaigns) {
            Campaign campaign2 = Globals.getCampaignKeyed(campaign.getKeyName());
            if (campaign2 == null) continue;
            arrayList.add(campaign2);
        }
        this.selectedCampaigns.clear();
        this.selectedCampaigns.addAll(arrayList);
        this.updateModels();
    }

    @Override
    public void refreshFiltering() {
        this.updateModels();
        this.selectCampaignsByURI(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
    }

    private void clearQFilter() {
        this.availableModel.clearQFilter();
        if (saveViewMode != null) {
            viewMode = saveViewMode;
            saveViewMode = null;
        }
        this.textQFilter.setText("");
        this.availableModel.resetModel(viewMode, true, false);
        this.clearQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.updateAvailableModel();
    }

    private void setQFilter() {
        String string = this.textQFilter.getText();
        if (string.length() == 0) {
            this.clearQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveViewMode == null) {
            saveViewMode = viewMode;
        }
        viewMode = 0;
        this.availableModel.resetModel(viewMode, true, false);
        this.clearQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.updateAvailableModel();
    }

    public void updateLoadedCampaignsUI() {
        this.selectedCampaigns.clear();
        for (Campaign campaign : Globals.getCampaignList()) {
            if (!campaign.isLoaded()) continue;
            this.selectedCampaigns.add(campaign);
        }
        this.updateModels();
        if (this.getParent() != null && Globals.displayListsHappy()) {
            PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getRealParentFrame(this);
            pCGen_Frame1.enableLstEditors(true);
        }
    }

    private void setInfoLabelText(PObjectNode pObjectNode) {
        this.lastSelection = pObjectNode;
        if (pObjectNode != null) {
            if (pObjectNode.getItem() instanceof Campaign) {
                Campaign campaign = (Campaign)pObjectNode.getItem();
                String string = campaign.get(StringKey.SOURCE_WEB);
                this.websiteButton.setEnabled(string != null);
                this.infoLabel.setText(MainSource.buildInfoLabel(campaign));
            } else {
                this.websiteButton.setEnabled(false);
                PObjectNode pObjectNode2 = pObjectNode;
                String string = pObjectNode2.getItem().toString();
                while (pObjectNode2.getParent() != this.availableTable.getTree().getModel().getRoot() && pObjectNode2.getParent() != this.selectedTable.getTree().getModel().getRoot()) {
                    pObjectNode2 = pObjectNode2.getParent();
                    string = pObjectNode2.getItem().toString() + "." + string;
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<html><b>").append(string).append("</b><br>");
                if (Globals.getSponsor(string) != null) {
                    Map<String, String> map = Globals.getSponsor(string);
                    stringBuffer.append("<img src='").append(SponsorLoader.getConvertedSponsorPath(map.get("IMAGELARGE"))).append("'><br>");
                }
                stringBuffer.append("</html>");
                this.infoLabel.setText(stringBuffer.toString());
            }
        }
    }

    public static String buildInfoLabel(Campaign campaign) {
        Object object;
        Object object2;
        String string;
        List<CampaignURL> list;
        List<CampaignURL> list2;
        List<CampaignURL> list3;
        Object object3;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<html><b>").append(campaign.getDisplayName()).append("</b><br>");
        if (campaign.getSizeOfListFor(ListKey.FILE_COVER) > 0) {
            object3 = campaign.getSafeListFor(ListKey.FILE_COVER).get(0);
            stringBuffer.append("<img src=\"").append(((CampaignSourceEntry)object3).getURI()).append("\"> ");
        }
        if (campaign.getSizeOfListFor(ListKey.FILE_LOGO) > 0) {
            object3 = campaign.getSafeListFor(ListKey.FILE_LOGO).get(0);
            stringBuffer.append("<img src=\"").append(((CampaignSourceEntry)object3).getURI()).append("\">");
        }
        if (campaign.getSizeOfListFor(ListKey.FILE_COVER) > 0 || campaign.getSizeOfListFor(ListKey.FILE_LOGO) > 0) {
            stringBuffer.append("<br>");
        }
        if (((String)(object3 = campaign.getDefaultSourceString())).length() == 0) {
            object3 = SourceFormat.getFormattedString(campaign, SourceFormat.LONG, true);
        }
        stringBuffer.append("<b>SOURCE</b>: ");
        stringBuffer.append((String)object3);
        stringBuffer.append(" <b>by</b> ");
        stringBuffer.append(campaign.getSafe(StringKey.PUB_NAME_LONG));
        stringBuffer.append("<br>\n");
        String string2 = campaign.get(StringKey.DESCRIPTION);
        if (string2 != null) {
            stringBuffer.append("<b>DESCRIPTION</b>: ");
            stringBuffer.append(string2);
            stringBuffer.append("<br>\n");
        }
        if (!(list3 = MainSource.getUrlListForKind(campaign, CampaignURL.URLKind.WEBSITE)).isEmpty()) {
            stringBuffer.append("<b>WEBSITE</b>: ");
            stringBuffer.append(MainSource.buildURLListString(list3));
            stringBuffer.append("<br>\n");
        }
        if (campaign.getType().length() > 0) {
            stringBuffer.append("<b>TYPE</b>: ").append(campaign.getType()).append("&nbsp; ");
        }
        stringBuffer.append("<b>RANK</b>: ").append(campaign.getSafe(IntegerKey.CAMPAIGN_RANK));
        if (StringUtil.join(campaign.getSafeListFor(ListKey.GAME_MODE), ", ").length() > 0) {
            stringBuffer.append("&nbsp; <b>GAME MODE</b>: ").append(StringUtil.join(campaign.getSafeListFor(ListKey.GAME_MODE), ", "));
        }
        if (!(list2 = MainSource.getUrlListForKind(campaign, CampaignURL.URLKind.PURCHASE)).isEmpty()) {
            stringBuffer.append("<br><b>PURCHASE</b>: ");
            stringBuffer.append(MainSource.buildURLListString(list2));
            stringBuffer.append("\n");
        }
        if (!(list = MainSource.getUrlListForKind(campaign, CampaignURL.URLKind.SURVEY)).isEmpty()) {
            stringBuffer.append("<br><b>SURVEY</b>: ");
            stringBuffer.append(MainSource.buildURLListString(list));
            stringBuffer.append("\n");
        }
        if ((string = PrerequisiteUtilities.preReqHTMLStringsForList(null, null, campaign.getPrerequisiteList(), false)).length() > 0) {
            stringBuffer.append(PropertyFactory.getFormattedString("in_InfoRequirements", string));
            stringBuffer.append("\n");
        }
        boolean bl = false;
        List<String> list4 = campaign.getListFor(ListKey.INFO_TEXT);
        if (list4 != null) {
            if (!bl) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append("<b>INFORMATION</b>:<br>");
            object2 = list4.iterator();
            while (object2.hasNext()) {
                object = (String)object2.next();
                stringBuffer.append((String)object).append("<br>");
            }
        }
        if ((object2 = campaign.getListFor(ListKey.SECTION_15)) != null) {
            if (!bl) {
                stringBuffer.append("<br>");
            }
            stringBuffer.append("<b>COPYRIGHT</b>:<br>");
            object = object2.iterator();
            while (object.hasNext()) {
                String string3 = (String)object.next();
                stringBuffer.append(string3).append("<br>");
            }
        }
        stringBuffer.append("</html>");
        return stringBuffer.toString();
    }

    private static String buildURLListString(List<CampaignURL> list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = true;
        for (CampaignURL campaignURL : list) {
            if (bl) {
                bl = false;
            } else {
                stringBuffer.append(" | ");
            }
            stringBuffer.append("<a href=\"").append(campaignURL.getUri().toString());
            stringBuffer.append("\">").append(campaignURL.getUrlDesc());
            stringBuffer.append("</a>");
        }
        return stringBuffer.toString();
    }

    private int getSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new CampaignModel(viewMode, true);
        } else {
            this.availableModel.resetModel(viewMode, true, false);
        }
    }

    private void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new CampaignModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(viewSelectMode, false, false);
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = MainSource.this.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = MainSource.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null || !(object instanceof PObjectNode)) {
                        ShowMessageDelegate.showMessageDialog("No campaign selected. Try again.", "PCGen", MessageType.ERROR);
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)object);
                    MainSource.this.rightButton.setEnabled(true);
                    MainSource.this.leftButton.setEnabled(false);
                }
            }
        });
        final JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1 && treePath != null) {
                        jTree.setSelectionPath(treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainSource.this.doCampaign(true);
                            }
                        });
                    }
                }
            }
        };
        jTree.addMouseListener(mouseAdapter);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    int n = MainSource.this.getSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = MainSource.this.selectedTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object == null || !(object instanceof PObjectNode)) {
                        MainSource.this.lastSelection = null;
                        MainSource.this.infoLabel.setText();
                        return;
                    }
                    MainSource.this.setInfoLabelText((PObjectNode)object);
                    MainSource.this.leftButton.setEnabled(true);
                    MainSource.this.rightButton.setEnabled(false);
                }
            }
        });
        mouseAdapter = new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                int n = jTree2.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                TreePath treePath = jTree2.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    if (mouseEvent.getClickCount() == 1) {
                        jTree2.setSelectionPath(treePath);
                    } else if (mouseEvent.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                MainSource.this.doCampaign(false);
                            }
                        });
                    }
                }
            }
        };
        jTree2.addMouseListener(mouseAdapter);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private JScrollPane addColumnManagerButton(JTable jTable, TableColumnManagerModel tableColumnManagerModel) {
        JScrollPane jScrollPane = new JScrollPane(jTable, 22, 30);
        JButton jButton = new JButton();
        jScrollPane.setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(jTable, jButton, tableColumnManagerModel);
        return jScrollPane;
    }

    private void doCampaign(boolean bl) {
        if (this.lastSelection == null) {
            return;
        }
        if (this.lastSelection.getItem() instanceof Campaign) {
            Campaign campaign = (Campaign)this.lastSelection.getItem();
            if (bl) {
                if (!this.selectedCampaigns.contains(campaign) && PrereqHandler.passesAll(campaign.getPrerequisiteList(), null, (CDOMObject)null)) {
                    this.selectedCampaigns.add(campaign);
                }
            } else {
                this.selectedCampaigns.remove(campaign);
            }
        } else {
            this.selectAllLeaves(this.lastSelection, bl);
        }
        Collections.sort(this.selectedCampaigns);
        this.updateModels();
        if (bl) {
            this.selectedTable.expandByPObjectName(this.lastSelection.getItem().toString());
        }
        this.rememberSourceChanges();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(SOURCE_MATERIALS_TAB);
        if (!this.hasBeenSized) {
            this.hasBeenSized = true;
            this.splitPane.setDividerSize(10);
            this.splitPane.setDividerLocation(0.5);
            this.bsplit.setDividerSize(10);
            this.bsplit.setDividerLocation(0.75);
            this.asplit.setDividerSize(10);
            this.asplit.setDividerLocation(0.5);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new CampaignPopupListener(jTreeTable, new CampaignPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                MainSource.this.formComponentShown();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(true);
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(false);
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.textQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                MainSource.this.setQFilter();
            }
        });
        this.clearQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.clearQFilter();
            }
        });
        this.infoLabel.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        BrowserLauncher.openURL(hyperlinkEvent.getURL());
                    }
                    catch (IOException iOException) {
                        Logging.errorPrint("Failed to open URL " + hyperlinkEvent.getURL() + " due to ", iOException);
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_Src_browser", hyperlinkEvent.getURL().toString()), "PCGen", MessageType.ERROR);
                    }
                }
            }
        });
    }

    private void initComponents() {
        JButton jButton;
        this.viewComboBox.addItem("Name Only");
        this.viewComboBox.addItem("Company");
        this.viewComboBox.addItem("Company/Setting");
        this.viewComboBox.addItem("Comp/Fmt/Setting");
        Utility.setDescription(this.viewComboBox, "You can change how the Sources in the Tables are listed.");
        viewMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.availableListMode", 3);
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem("Name Only");
        this.viewSelectComboBox.addItem("Company");
        this.viewSelectComboBox.addItem("Company/Setting");
        this.viewSelectComboBox.addItem("Company/Format/Setting");
        viewSelectMode = SettingsHandler.getPCGenOption("pcgen.options.sourceTab.selectedListMode", 0);
        Utility.setDescription(this.viewSelectComboBox, "You can change how the Sources in the Tables are listed.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        this.avaLabel.setText(PropertyFactory.getString("in_available"));
        jPanel.add((Component)InfoTabUtils.createFilterPane(this.avaLabel, this.viewComboBox, this.lblQFilter, this.textQFilter, this.clearQFilterButton), "North");
        JScrollPane jScrollPane = this.addColumnManagerButton(this.availableTable, this.availableModel);
        jPanel.add((Component)jScrollPane, "Center");
        this.rightButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        jPanel.add((Component)this.buildModSpellPanel(this.rightButton, "Click to add the source"), "South");
        jPanel2.setLayout(new BorderLayout());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new FlowLayout(0, 5, 1));
        this.selLabel.setText(PropertyFactory.getString("in_selected"));
        jPanel3.add(this.selLabel);
        jPanel3.add(this.viewSelectComboBox);
        jPanel2.add((Component)jPanel3, "North");
        jScrollPane = this.addColumnManagerButton(this.selectedTable, this.selectedModel);
        jPanel2.add((Component)jScrollPane, "Center");
        this.leftButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        jPanel2.add((Component)this.buildModSpellPanel(this.leftButton, "Click to remove the source"), "South");
        this.bLeftPane = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        Border border = null;
        TitledBorder titledBorder = BorderFactory.createTitledBorder(border, "Source Info");
        titledBorder.setTitleJustification(2);
        this.infoLabel = new JLabelPane();
        JScrollPane jScrollPane2 = new JScrollPane(this.infoLabel);
        jScrollPane2.setBorder(titledBorder);
        this.bLeftPane.add((Component)jScrollPane2, "Center");
        this.infoLabel.setBackground(this.bLeftPane.getBackground());
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.jPanel1n, "North");
        jPanel4.add((Component)this.jPanel1s, "Center");
        this.jPanel1n.setLayout(flowLayout);
        flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        this.jPanel1s.setLayout(flowLayout);
        if (!this.sourceBuilderMode) {
            this.loadButton.setText("Load");
            this.loadButton.setMnemonic(76);
            this.loadButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainSource.this.loadCampaigns_actionPerformed();
                }
            });
            this.jPanel1n.add(this.loadButton);
            this.loadButton.setToolTipText("This loads all the sources listed in the above table");
            this.unloadAllButton.setText("Unload All");
            this.unloadAllButton.setMnemonic(85);
            this.unloadAllButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    MainSource.this.unloadAllCampaigns_actionPerformed();
                }
            });
            this.jPanel1n.add(this.unloadAllButton);
            jButton = new JButton(PropertyFactory.getString("in_Src_basic_source"));
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PCGen_Frame1.getInst().switchSourceSelectMeans(false);
                }
            });
            jButton.setToolTipText(PropertyFactory.getString("in_Src_basic_sourceTip"));
            this.jPanel1s.add(jButton);
        }
        this.removeAllButton = new JButton("Remove All");
        this.removeAllButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        });
        this.removeAllButton.setToolTipText("Remove all sources from the above table");
        this.jPanel1n.add(this.removeAllButton);
        this.refreshButton.setText("Refresh");
        this.refreshButton.setToolTipText("Refresh the list of sources");
        this.refreshButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.refreshCampaigns();
            }
        });
        this.jPanel1s.add(this.refreshButton);
        this.websiteButton = new JButton("Website");
        this.websiteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(false, true);
            }
        });
        this.websiteButton.setToolTipText("Go to the selected product's website");
        this.websiteButton.setEnabled(false);
        this.jPanel1s.add(this.websiteButton);
        jButton = new JButton("Customise");
        JPanel jPanel5 = this;
        jButton.addActionListener(new ActionListener((MainSource)jPanel5){
            final /* synthetic */ MainSource val$t;
            {
                this.val$t = mainSource2;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                new PCCCreator(this.val$t);
            }
        });
        jButton.setToolTipText("Customise your own source to ease your loading process");
        this.jPanel1s.add(jButton);
        this.asplit = new FlippingSplitPane(1, this.bLeftPane, jPanel4);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        jPanel5.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, jPanel5);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.selectCampaignsByURI(PersistenceManager.getInstance().getChosenCampaignSourcefiles());
        if (SettingsHandler.isLoadCampaignsAtStart() && this.selectedCampaigns.size() > 0) {
            this.loadCampaigns();
        }
        if (this.selectedCampaigns.size() == 0) {
            this.selectDefaultCampaigns();
        }
    }

    private JPanel buildModSpellPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private void launchProductWebsite(boolean bl, boolean bl2) {
        JTreeTable jTreeTable = bl ? this.availableTable : this.selectedTable;
        PObjectNode pObjectNode = (PObjectNode)jTreeTable.getTree().getLastSelectedPathComponent();
        if (pObjectNode != null) {
            if (pObjectNode.getItem() instanceof Campaign) {
                String string;
                Campaign campaign = (Campaign)pObjectNode.getItem();
                String string2 = string = bl2 ? campaign.get(StringKey.SOURCE_WEB) : campaign.getSafe(StringKey.HELP);
                if (string != null && !string.equals("")) {
                    try {
                        BrowserLauncher.openURL(string);
                    }
                    catch (IOException iOException) {
                        Logging.errorPrint("Could not open browser to " + string, iOException);
                        ShowMessageDelegate.showMessageDialog("Could not open browser to " + string, "PCGen", MessageType.ERROR);
                    }
                } else {
                    String string3 = bl2 ? "web" : "help";
                    ShowMessageDelegate.showMessageDialog("No " + string3 + " information found for Source: " + campaign.getDisplayName(), "PCGen", MessageType.WARNING);
                }
            }
        } else {
            ShowMessageDelegate.showMessageDialog("Please select a source.", "PCGen", MessageType.ERROR);
        }
    }

    private void loadCampaigns() {
        if (this.selectedCampaigns.size() < 1) {
            return;
        }
        for (Campaign object2 : this.selectedCampaigns) {
            if (PrereqHandler.passesAll(object2.getPrerequisiteList(), null, (CDOMObject)null)) continue;
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_Src_Bad_Combo_Load", object2.getDisplayName()), PropertyFactory.getString("in_error"), MessageType.ERROR);
            return;
        }
        PersistenceObserver persistenceObserver = new PersistenceObserver();
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        try {
            persistenceManager.addObserver(persistenceObserver);
            Logging.registerHandler(persistenceObserver.getHandler());
            persistenceManager.loadCampaigns(this.selectedCampaigns);
            Logging.removeHandler(persistenceObserver.getHandler());
            persistenceManager.deleteObserver(persistenceObserver);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            ShowMessageDelegate.showMessageDialog(persistenceLayerException.getMessage(), "PCGen", MessageType.WARNING);
            this.unloadAllCampaigns_actionPerformed();
        }
    }

    private void loadCampaigns_actionPerformed() {
        final String string = this.showLoadingSources();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                MainSource.this.loadCampaigns();
                return "";
            }

            public void finished() {
                if (MainSource.this.getParent() != null && Globals.displayListsHappy()) {
                    PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getRealParentFrame(MainSource.this);
                    pCGen_Frame1.enableLstEditors(true);
                }
                MainSource.this.updateModels();
                MainSource.this.showSourcesLoaded(string);
                if (Globals.getRootFrame() != null) {
                    PCGen_Frame1.getInst().refreshCharInfoTabs();
                }
            }
        };
        swingWorker.start();
    }

    public String showLoadingSources() {
        this.sourcesLoaded = true;
        this.loadButton.setEnabled(false);
        this.refreshButton.setEnabled(false);
        this.refreshButton.setToolTipText("Can't refresh while sources are loaded.");
        String string = PCGen_Frame1.getMessageAreaText();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("Loading Sources...");
        return string;
    }

    public void showSourcesLoaded(String string) {
        PCGen_Frame1.enableDisableMenuItems();
        PCGen_Frame1.setMessageAreaTextWithoutSaving(string);
        PCGen_Frame1.restoreFilterSettings(null);
    }

    private void rememberSourceChanges() {
        ArrayList<URI> arrayList = new ArrayList<URI>(this.selectedCampaigns.size());
        for (Campaign campaign : this.selectedCampaigns) {
            arrayList.add(campaign.getSourceURI());
        }
        PersistenceManager.getInstance().setChosenCampaignSourcefiles(arrayList);
    }

    public void resetUI() {
        this.infoLabel.setBackground(this.bLeftPane.getBackground());
    }

    private void selectAllLeaves(PObjectNode pObjectNode, boolean bl) {
        for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
            PObjectNode pObjectNode2 = pObjectNode.getChild(i);
            if (pObjectNode2.isLeaf() && pObjectNode2.getItem() instanceof Campaign) {
                Campaign campaign = (Campaign)pObjectNode2.getItem();
                if (campaign == null) continue;
                if (bl) {
                    if (this.selectedCampaigns.contains(campaign) || !PrereqHandler.passesAll(campaign.getPrerequisiteList(), null, (CDOMObject)null)) continue;
                    this.selectedCampaigns.add(campaign);
                    continue;
                }
                this.selectedCampaigns.remove(campaign);
                continue;
            }
            this.selectAllLeaves(pObjectNode2, bl);
        }
    }

    private void selectAll_actionPerformed(boolean bl) {
        if (bl) {
            this.selectAllLeaves((PObjectNode)this.availableTable.getTree().getModel().getRoot(), true);
        } else {
            this.selectedCampaigns.clear();
            this.unloadAllCampaigns_actionPerformed();
        }
        this.updateModels();
        this.rememberSourceChanges();
    }

    private void selectCampaignsByURI(Collection<URI> collection) {
        for (URI uRI : collection) {
            Campaign campaign = Globals.getCampaignByURI(uRI);
            if (campaign == null || this.selectedCampaigns.contains(campaign)) continue;
            this.selectedCampaigns.add(campaign);
            this.updateModels();
        }
    }

    private void unloadAllCampaigns_actionPerformed() {
        SourceSelectionUtils.unloadSources();
    }

    public void campaignsUnloaded() {
        this.sourcesLoaded = false;
        this.refreshButton.setEnabled(true);
        this.refreshButton.setToolTipText("Refresh the list of sources");
        this.updateModels();
    }

    private void updateAvailableModel() {
        List<String> list = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(list);
    }

    private void updateModels() {
        this.updateAvailableModel();
        this.updateSelectedModel();
        if (this.selectedTable.getTree().getRowCount() == 0) {
            this.loadButton.setEnabled(false);
            this.unloadAllButton.setEnabled(false);
            this.removeAllButton.setEnabled(false);
        } else {
            this.loadButton.setEnabled(!this.sourcesLoaded);
            this.unloadAllButton.setEnabled(true);
            this.removeAllButton.setEnabled(true);
        }
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != viewMode) {
            viewMode = n;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.availableListMode", viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int n = this.viewSelectComboBox.getSelectedIndex();
        if (n != viewSelectMode) {
            viewSelectMode = n;
            SettingsHandler.setPCGenOption("pcgen.options.sourceTab.selectedListMode", viewSelectMode);
            this.updateSelectedModel();
        }
    }

    public static List<CampaignURL> getUrlListForKind(Campaign campaign, CampaignURL.URLKind uRLKind) {
        ArrayList<CampaignURL> arrayList = new ArrayList<CampaignURL>();
        for (CampaignURL campaignURL : campaign.getSafeListFor(ListKey.CAMPAIGN_URL)) {
            if (campaignURL.getUrlKind() != uRLKind) continue;
            arrayList.add(campaignURL);
        }
        return arrayList;
    }

    private class CampaignPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -2654080650560664447L;

        CampaignPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == MainSource.this.availableTable) {
                this.add(this.createAddMenuItem("Select", "shortcut EQUALS"));
                this.add(this.createAddAllMenuItem("Select All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", true));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", true));
            } else {
                this.add(this.createRemoveMenuItem("Remove", "shortcut MINUS"));
                this.add(this.createRemoveAllMenuItem("Remove All", "alt A"));
                this.add(this.createWebMenuItem("Product Website...", "alt W", false));
                this.add(this.createHelpFileMenuItem("Product Help...", "alt H", false));
            }
        }

        private JMenuItem createAddAllMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddAllCampaignActionListener(), "selectall", '\u0000', string2, "Select All Source material to load", "Add16.gif", true);
        }

        private JMenuItem createAddMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new AddCampaignActionListener(), "select", '\u0000', string2, "Select Source material to load", "Add16.gif", true);
        }

        private JMenuItem createRemoveAllMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveAllCampaignActionListener(), "deselectall", '\u0000', string2, "Remove All Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, String string2) {
            return Utility.createMenuItem(string, new RemoveCampaignActionListener(), "deselect", '\u0000', string2, "Remove Source material from loading", "Remove16.gif", true);
        }

        private JMenuItem createHelpFileMenuItem(String string, String string2, boolean bl) {
            return Utility.createMenuItem(string, new HelpfileActionListener(bl), "helpfile", '\u0000', string2, "Launch browser to product's helpfile", "Bookmarks16.gif", true);
        }

        private JMenuItem createWebMenuItem(String string, String string2, boolean bl) {
            return Utility.createMenuItem(string, new WebActionListener(bl), "website", '\u0000', string2, "Launch browser to product's website", "Bookmarks16.gif", true);
        }

        private class WebActionListener
        implements ActionListener {
            boolean available = true;

            WebActionListener(boolean bl) {
                this.available = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(this.available, true);
            }
        }

        private class HelpfileActionListener
        implements ActionListener {
            boolean available = true;

            HelpfileActionListener(boolean bl) {
                this.available = bl;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.launchProductWebsite(this.available, false);
            }
        }

        private class RemoveCampaignActionListener
        implements ActionListener {
            private RemoveCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(false);
            }
        }

        private class RemoveAllCampaignActionListener
        implements ActionListener {
            private RemoveAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(false);
            }
        }

        private class AddCampaignActionListener
        implements ActionListener {
            private AddCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.doCampaign(true);
            }
        }

        private class AddAllCampaignActionListener
        implements ActionListener {
            private AddAllCampaignActionListener() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                MainSource.this.selectAll_actionPerformed(true);
            }
        }
    }

    private class CampaignPopupListener
    extends MouseAdapter {
        private CampaignPopupMenu menu;
        private JTree tree;

        CampaignPopupListener(JTreeTable jTreeTable, CampaignPopupMenu campaignPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = campaignPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    MainSource.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < CampaignPopupListener.this.menu.getComponentCount(); ++i) {
                            JMenuItem jMenuItem = (JMenuItem)CampaignPopupListener.this.menu.getComponent(i);
                            KeyStroke keyStroke2 = jMenuItem.getAccelerator();
                            if (keyStroke2 == null || !keyStroke.equals(keyStroke2)) continue;
                            MainSource.this.selPath = CampaignPopupListener.this.tree.getSelectionPath();
                            jMenuItem.doClick(2);
                            return;
                        }
                    }
                    MainSource.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    MainSource.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                MainSource.this.selRow = this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (MainSource.this.selRow == -1) {
                    return;
                }
                MainSource.this.selPath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (MainSource.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(MainSource.this.selPath);
                this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class CampaignModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        int modelType;
        final String prefix;
        private String[] names;
        private int[] widths;
        private List<Boolean> displayList;

        public CampaignModel(int n, boolean bl) {
            super(null);
            this.modelType = 0;
            this.names = new String[]{"Source Material", "Book Type", "Loaded"};
            this.widths = new int[]{250, 120, 60};
            if (!bl) {
                this.modelType = 1;
            }
            this.prefix = "source." + (bl ? "avail" : "select");
            int n2 = 1;
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            if (bl) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
            }
            this.resetModel(n, bl, true);
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (n == 0) {
                return TreeTableModel.class;
            }
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        public void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        @Override
        public final Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            try {
                PObjectNode pObjectNode = (PObjectNode)object;
                Campaign campaign = null;
                if (pObjectNode != null && pObjectNode.getItem() instanceof Campaign) {
                    campaign = (Campaign)pObjectNode.getItem();
                }
                switch (n) {
                    case 0: {
                        if (pObjectNode != null) {
                            return pObjectNode.toString();
                        }
                        Logging.errorPrint("Somehow we have no active node when doing getValueAt in MainSource.");
                        return "";
                    }
                    case 1: {
                        if (campaign != null) {
                            return campaign.getSafe(StringKey.BOOK_TYPE);
                        }
                        break;
                    }
                    case 2: {
                        if (campaign != null) {
                            if (campaign.isLoaded()) {
                                return "Y";
                            }
                            return "N";
                        }
                        break;
                    }
                    default: {
                        Logging.errorPrint("In MainSource.CampaignModel.getValueAt the column " + n + " is not handled.");
                        break;
                    }
                }
            }
            catch (Exception exception) {
                Logging.errorPrint("Failed to get value for column " + n + " of " + object, exception);
            }
            return null;
        }

        public void resetModel(int n, boolean bl, boolean bl2) {
            PObjectNode pObjectNode;
            List<String> list = Globals.getAllowedGameModes();
            List list2 = bl ? Globals.getCampaignList() : MainSource.this.selectedCampaigns;
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    pObjectNode = new PObjectNode();
                    TreeMap<Object, Object> treeMap = new TreeMap<Object, Object>();
                    for (Object object : list2) {
                        Object object2;
                        if (!((Campaign)object).isGameMode(list) || !this.shouldDisplayThis((Campaign)object) || !(bl ^ MainSource.this.selectedCampaigns.contains(object))) continue;
                        String string = ((CDOMObject)object).get(StringKey.DATA_PRODUCER);
                        if (string != null) {
                            Object object3;
                            if (!treeMap.containsKey(string)) {
                                object2 = new PObjectNode(string);
                                treeMap.put(string, object2);
                            }
                            object2 = ((CDOMObject)object).get(StringKey.DATA_FORMAT);
                            if (n == 1) {
                                object3 = new PObjectNode(object);
                                ((PObjectNode)treeMap.get(string)).addChild((PObjectNode)object3);
                                continue;
                            }
                            if (object2 != null) {
                                Object object4;
                                object3 = string + "." + (String)object2;
                                if (n == 3 && !treeMap.containsKey(object3)) {
                                    object4 = new PObjectNode(object2);
                                    treeMap.put(object3, object4);
                                    ((PObjectNode)treeMap.get(string)).addChild((PObjectNode)object4);
                                }
                                if ((object4 = ((CDOMObject)object).get(StringKey.CAMPAIGN_SETTING)) != null) {
                                    PObjectNode pObjectNode2;
                                    String string2;
                                    if (n == 3) {
                                        string2 = (String)object3 + "." + (String)object4;
                                        if (!treeMap.containsKey(string2)) {
                                            pObjectNode2 = new PObjectNode(object4);
                                            treeMap.put(string2, pObjectNode2);
                                            ((PObjectNode)treeMap.get(object3)).addChild(pObjectNode2);
                                        }
                                        ((PObjectNode)treeMap.get(string2)).addChild(new PObjectNode(object));
                                        continue;
                                    }
                                    string2 = string + "." + (String)object4;
                                    if (!treeMap.containsKey(string2)) {
                                        pObjectNode2 = new PObjectNode(object4);
                                        treeMap.put(string2, pObjectNode2);
                                        ((PObjectNode)treeMap.get(string)).addChild(pObjectNode2);
                                    }
                                    ((PObjectNode)treeMap.get(string2)).addChild(new PObjectNode(object));
                                    continue;
                                }
                                if (n == 3) {
                                    ((PObjectNode)treeMap.get(object3)).addChild(new PObjectNode(object));
                                    continue;
                                }
                                ((PObjectNode)treeMap.get(string)).addChild(new PObjectNode(object));
                                continue;
                            }
                            ((PObjectNode)treeMap.get(string)).addChild(new PObjectNode(object));
                            continue;
                        }
                        object2 = "Other";
                        if (!treeMap.containsKey(object2)) {
                            treeMap.put(object2, new PObjectNode(object2));
                        }
                        ((PObjectNode)treeMap.get(object2)).addChild(new PObjectNode(object));
                    }
                    for (Object object : treeMap.keySet()) {
                        if (((String)object).indexOf(46) != -1) continue;
                        pObjectNode.addChild((PObjectNode)treeMap.get(object));
                    }
                    this.setRoot(pObjectNode);
                    break;
                }
                case 0: {
                    this.setRoot(new PObjectNode());
                    String string = this.getQFilter();
                    for (Campaign campaign : list2) {
                        PObjectNode pObjectNode3 = (PObjectNode)super.getRoot();
                        if (!this.shouldDisplayThis(campaign) || !campaign.isGameMode(list) || bl && MainSource.this.selectedCampaigns.contains(campaign) || string != null && campaign.getKeyName().toLowerCase().indexOf(string) < 0 && campaign.getType().toLowerCase().indexOf(string) < 0) continue;
                        PObjectNode pObjectNode4 = new PObjectNode();
                        pObjectNode4.setParent(pObjectNode3);
                        pObjectNode4.setItem(campaign);
                        PrereqHandler.passesAll(campaign.getPrerequisiteList(), null, campaign);
                        pObjectNode3.addChild(pObjectNode4);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint("In MainSource.CampaignlModel.resetModel the mode " + n + " is not handled.");
                }
            }
            pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Campaign campaign) {
            if (campaign.getDisplayName().length() == 0) {
                return false;
            }
            return this.modelType == 1 || MainSource.this.accept(null, campaign);
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.names.length; ++i) {
                arrayList.add(this.names[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption(this.prefix + "." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption(this.prefix + "." + string, bl);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.modelType + "." + this.names[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption(this.prefix + ".sizecol." + this.names[n], this.widths[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption(this.prefix + ".sizecol." + this.names[n], n2);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
            int n2 = tableColumn.getModelIndex();
            switch (n2) {
                case 2: {
                    tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                    break;
                }
            }
        }
    }
}

