/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import pcgen.core.SettingsHandler;
import pcgen.gui.sources.MainSource;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.io.PCGFile;
import pcgen.util.Logging;

final class PCCCreator
extends JFrame {
    static final long serialVersionUID = 923830359956243549L;
    private JPanel mainPanel = new JPanel(new BorderLayout());
    private MainSource mSrc;
    private Map<String, String> lstTypes = new HashMap<String, String>();
    private SourceNode root;

    public PCCCreator(MainSource mainSource) {
        this.mSrc = mainSource;
        IconUtilitities.maybeSetIcon(this, "PCGenApp.png");
        this.buildTree();
        JButton jButton = new JButton("Write .pcc file");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PCCCreator.this.writePCCFile();
            }
        });
        this.mainPanel.add((Component)jButton, "South");
        this.getContentPane().add(this.mainPanel);
        this.setSize(400, 400);
        this.setDefaultCloseOperation(2);
        this.setTitle("Select Sources to include");
        this.setVisible(true);
    }

    private boolean buildSubTree(SourceNode sourceNode, File file, boolean bl) {
        boolean bl2 = false;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            SourceNode sourceNode2 = new SourceNode(fileArray[i]);
            boolean bl3 = false;
            if (fileArray[i].isDirectory()) {
                bl3 = this.buildSubTree(sourceNode2, fileArray[i], bl) || bl3;
            } else if (!bl && PCGFile.isPCGenListFile(fileArray[i])) {
                bl3 = true;
            } else if (!bl && PCGFile.isPCGenPartyFile(fileArray[i])) {
                this.extractLSTTypes(fileArray[i]);
            } else if (PCGFile.isPCGenCampaignFile(fileArray[i])) {
                bl3 = bl;
                this.extractLSTTypes(fileArray[i]);
            }
            if (bl3) {
                sourceNode.add(sourceNode2);
            }
            bl2 |= bl3;
        }
        return bl2;
    }

    private void buildTree() {
        this.root = new SourceNode(SettingsHandler.getPccFilesLocation());
        this.root.nodeName = "All Source Materials";
        SourceNode sourceNode = new SourceNode(SettingsHandler.getPccFilesLocation());
        sourceNode.nodeName = "Campaigns/Data Sets";
        this.root.add(sourceNode);
        SourceNode sourceNode2 = new SourceNode(SettingsHandler.getPccFilesLocation());
        sourceNode2.nodeName = "Data Files";
        this.root.add(sourceNode2);
        this.buildSubTree(sourceNode, sourceNode.nodeFile, true);
        this.buildSubTree(sourceNode2, sourceNode2.nodeFile, false);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(this.root);
        JTree jTree = new JTree(defaultTreeModel);
        jTree.setShowsRootHandles(true);
        jTree.setEditable(true);
        jTree.setSelectionModel(null);
        jTree.setRowHeight(-1);
        jTree.setCellRenderer(new SourceNodeTreeCellEditorAndRenderer());
        jTree.setCellEditor(new SourceNodeTreeCellEditorAndRenderer());
        JScrollPane jScrollPane = new JScrollPane(jTree);
        jScrollPane.setPreferredSize(new Dimension(400, 800));
        this.mainPanel.add((Component)jScrollPane, "Center");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void extractLSTTypes(File var1_1) {
        block25: {
            var2_2 = null;
            if (PCGFile.isPCGenCampaignFile(var1_1)) {
                var3_3 = var1_1.getName();
                this.lstTypes.put(var3_3, "PCC");
            }
            try {
                var2_2 = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(var1_1), "UTF-8"));
                block20: while (true) {
                    if ((var3_3 = var2_2.readLine()) == null) {
                        return;
                    }
                    var4_10 = var3_3.indexOf(":");
                    if (var3_3.startsWith("LSTEXCLUDE") || var3_3.startsWith("PCC") || var3_3.startsWith("CAMPAIGN") || var3_3.startsWith("GAME") || var3_3.startsWith("RANK") || var3_3.startsWith("SOURCE") || var3_3.startsWith("#") || var3_3.startsWith("GENRE") || var3_3.startsWith("BOOKTYPE") || var3_3.startsWith("SETTING") || var3_3.startsWith("TYPE") || var3_3.startsWith("PUBNAME") || var3_3.startsWith("ISD20") || var3_3.startsWith("ISOGL") || var3_3.startsWith("COPYRIGHT") || var4_10 < 0) continue;
                    var5_12 = var3_3.substring(0, var4_10);
                    while (true) {
                        if (var4_10 != 0 && var4_10 < var3_3.length()) ** break;
                        continue block20;
                        var6_13 = var3_3.indexOf("|", var4_10);
                        var7_14 = var6_13 == -1 ? var3_3.substring(var4_10 + 1) : var3_3.substring(var4_10 + 1, var6_13);
                        var7_14 = new File(var7_14).getName();
                        this.lstTypes.put(var7_14, var5_12);
                        var4_10 = var6_13 + 1;
                    }
                    break;
                }
                catch (FileNotFoundException var3_4) {
                    Logging.errorPrint("Could not find pcc file " + var1_1.toString(), var3_4);
                    break block25;
                }
                catch (UnsupportedEncodingException var3_6) {
                    Logging.errorPrint("The pcc file's encoding is not supported.", var3_6);
                    break block25;
                }
                catch (IOException var3_8) {
                    Logging.errorPrint("Excepti", var3_8);
                }
            }
            finally {
                if (var2_2 != null) {
                    try {
                        var2_2.close();
                    }
                    catch (IOException var3_7) {
                        Logging.errorPrint("Failed to close pcc file reader in PCCCreator.extractLSTTypes", var3_7);
                    }
                }
            }
        }
    }

    private void recurseNodes(PrintStream printStream, SourceNode sourceNode, boolean bl) {
        if (!bl && sourceNode.getSelectedState() == 0) {
            return;
        }
        Enumeration<TreeNode> enumeration = sourceNode.children();
        while (enumeration.hasMoreElements()) {
            SourceNode sourceNode2 = (SourceNode)enumeration.nextElement();
            if (sourceNode2.isLeaf()) {
                String string = this.lstTypes.get(sourceNode2.nodeName);
                String string2 = sourceNode2.nodeFile.getPath();
                String string3 = string2.substring(string2.indexOf(File.separator + "data" + File.separator) + 6);
                if (string == null) {
                    string = "# *** UNKNOWN TYPE, FIX ME ***";
                }
                if (!bl && sourceNode2.getSelectedState() != 1) continue;
                printStream.println(string + ":" + string3);
                continue;
            }
            this.recurseNodes(printStream, sourceNode2, bl || sourceNode2.getSelectedState() == 1);
        }
    }

    private void writePCCFile() {
        String string = JOptionPane.showInputDialog(this, (Object)"Enter PCC filename");
        if (string == null) {
            return;
        }
        if (!PCGFile.isPCGenCampaignFile(new File(string))) {
            string = string + ".pcc";
        }
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(new File(this.root.nodeFile, string));
            PrintStream printStream = new PrintStream(fileOutputStream);
            printStream.println("CAMPAIGN: Custom Source Materials (" + string + ")");
            printStream.println("GAMEMODE:" + SettingsHandler.getGame().getName());
            printStream.println("TYPE:Custom");
            printStream.println("RANK:5");
            printStream.println("SOURCELONG:Custom - " + string);
            printStream.println("SOURCESHORT:Custom");
            printStream.println("SOURCEWEB:");
            printStream.println("");
            this.recurseNodes(printStream, this.root, this.root.getSelectedState() == 1);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            Logging.errorPrint("", iOException);
        }
        this.mSrc.refreshCampaigns();
    }

    static final class NodePanel
    extends JPanel {
        SourceNode node;

        public NodePanel(SourceNode sourceNode) {
            this.node = sourceNode;
        }
    }

    static final class SourceNodeTreeCellEditorAndRenderer
    extends DefaultCellEditor
    implements TreeCellRenderer,
    TreeCellEditor {
        public SourceNodeTreeCellEditorAndRenderer() {
            super(new JComboBoxEx());
        }

        public Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
            SourceNode sourceNode = (SourceNode)object;
            return sourceNode.getPanel(jTree.getModel(), this.getState(sourceNode, bl3));
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            SourceNode sourceNode = (SourceNode)object;
            return sourceNode.getPanel(jTree.getModel(), this.getState(sourceNode, bl3));
        }

        private int getState(SourceNode sourceNode, boolean bl) {
            if (sourceNode.getParent() == null) {
                return 2;
            }
            int n = ((SourceNode)sourceNode.getParent()).combo.getSelectedIndex();
            if (bl) {
                return n == 1 ? 1 : 0;
            }
            return n;
        }
    }

    static final class SourceNode
    extends DefaultMutableTreeNode {
        public static final int NONE = 0;
        public static final int ALL = 1;
        public static final int MIXED = 2;
        public File nodeFile;
        public JLabel label;
        public JPanel panel;
        public String nodeName;
        JComboBoxEx combo;

        public SourceNode(File file) {
            super(file);
            this.nodeFile = file;
            this.nodeName = file.getName();
        }

        public JPanel getPanel(final TreeModel treeModel, int n) {
            if (this.panel == null) {
                this.panel = new NodePanel(this);
                this.label = new JLabel(this.nodeName);
                this.combo = new JComboBoxEx(){

                    protected void fireItemStateChanged(ItemEvent itemEvent) {
                        super.fireItemStateChanged(itemEvent);
                        if (this.getParent() != null) {
                            ((NodePanel)this.getParent()).node.processSelect((DefaultTreeModel)treeModel);
                        }
                    }
                };
                if (this.nodeFile.isDirectory()) {
                    this.combo.addItem("Include None");
                    this.combo.addItem("Include All");
                    this.combo.addItem("Mixed");
                    if (this.isRoot()) {
                        this.combo.setSelectedIndex(2);
                    } else {
                        this.combo.setSelectedIndex(n);
                    }
                } else {
                    this.combo.addItem("Exclude");
                    this.combo.addItem("Include");
                    this.combo.setSelectedIndex(n);
                }
                this.panel.setOpaque(false);
                this.panel.add(this.combo);
                this.panel.add(this.label);
            }
            this.combo.setEnabled(true);
            this.label.setForeground(this.getSelectedState() == 2 ? Color.black : (this.getSelectedState() == 1 ? Color.decode("#006600") : Color.gray));
            return this.panel;
        }

        protected void processSelect(DefaultTreeModel defaultTreeModel) {
            defaultTreeModel.nodeChanged(this);
            int n = this.getSelectedState();
            if (n == 2) {
                return;
            }
            boolean bl = n == 1;
            for (SourceNode sourceNode = (SourceNode)this.getParent(); sourceNode != null; sourceNode = (SourceNode)sourceNode.getParent()) {
                if (bl && sourceNode.getSelectedState() == 0) {
                    sourceNode.combo.setSelectedIndex(2);
                    defaultTreeModel.nodeChanged(sourceNode);
                    continue;
                }
                if (bl || sourceNode.getSelectedState() != 1) continue;
                sourceNode.combo.setSelectedIndex(2);
                defaultTreeModel.nodeChanged(sourceNode);
            }
            Enumeration<TreeNode> enumeration = this.breadthFirstEnumeration();
            while (enumeration.hasMoreElements()) {
                SourceNode sourceNode = (SourceNode)enumeration.nextElement();
                if (sourceNode == this || sourceNode == null || sourceNode.combo == null) continue;
                if (bl) {
                    sourceNode.combo.setSelectedIndex(1);
                    defaultTreeModel.nodeChanged(sourceNode);
                    continue;
                }
                if (bl) continue;
                sourceNode.combo.setSelectedIndex(0);
                defaultTreeModel.nodeChanged(sourceNode);
            }
        }

        public int getSelectedState() {
            if (this.combo != null) {
                return this.combo.getSelectedIndex();
            }
            if (this.isLeaf()) {
                return 1;
            }
            return 0;
        }

        public String toString() {
            return this.nodeName;
        }
    }
}

