/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.commons.lang.ArrayUtils;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.ListKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.StringKey;
import pcgen.core.Campaign;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.sources.CreateSourceDialog;
import pcgen.gui.sources.SourceSelectionUtils;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.persistence.PersistenceManager;
import pcgen.util.PropertyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceSelectionDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    static final String ACTION_CANCEL = "cancel";
    private static final String ACTION_LOAD = "load";
    private static final String ACTION_HIDE = "hide";
    private static final String ACTION_UNHIDE = "unhide";
    private static final String ACTION_ADD = "add";
    private static final String ACTION_ADVANCED = "advanced";
    private static final String ACTION_MODIFY = "modify";
    private static final String ACTION_DELETE = "delete";
    private JList sourceList;
    private DefaultListModel sourceModel;
    private Map<String, List<String>> nameToSourceMap = new HashMap<String, List<String>>();
    private Map<String, String> nameToGameModeMap = new HashMap<String, String>();
    private String lastLoadedCollection;
    private JButton deleteButton;
    private JButton modifyButton;

    public SourceSelectionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.setTitle(PropertyFactory.getString("in_qsrc_title"));
        this.initComponents();
        this.setLocationRelativeTo(frame);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_qsrc_intro"));
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0);
        this.getContentPane().add((Component)jLabel, gridBagConstraints);
        this.sourceList = new JList();
        this.sourceModel = new DefaultListModel();
        List<String> list = this.getSourceNames();
        for (String object2 : list) {
            this.sourceModel.addElement(object2);
        }
        this.sourceList.setModel(this.sourceModel);
        this.sourceList.setSelectionMode(0);
        this.sourceList.setLayoutOrientation(1);
        this.sourceList.setVisibleRowCount(2);
        this.sourceList.setCellRenderer(new SourceListCellRenderer());
        JScrollPane jScrollPane = new JScrollPane(this.sourceList);
        jScrollPane.setPreferredSize(new Dimension(480, 260));
        if (this.lastLoadedCollection != null && this.lastLoadedCollection.length() > 0) {
            this.sourceList.setSelectedValue(this.lastLoadedCollection, true);
        }
        Utility.buildRelativeConstraints(gridBagConstraints, 2, 5, 100.0, 100.0, 1, 17);
        this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
        JButton jButton = new JButton(PropertyFactory.getString("in_add"));
        jButton.setActionCommand(ACTION_ADD);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.getContentPane().add((Component)jButton, gridBagConstraints);
        this.modifyButton = new JButton(PropertyFactory.getString("in_modify"));
        this.modifyButton.setActionCommand(ACTION_MODIFY);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 17);
        this.getContentPane().add((Component)this.modifyButton, gridBagConstraints);
        JButton jButton2 = new JButton(PropertyFactory.getString("in_hide"));
        jButton2.setActionCommand(ACTION_HIDE);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 11);
        this.getContentPane().add((Component)jButton2, gridBagConstraints);
        JButton jButton3 = new JButton(PropertyFactory.getString("in_unhide"));
        jButton3.setActionCommand(ACTION_UNHIDE);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 11);
        this.getContentPane().add((Component)jButton3, gridBagConstraints);
        this.deleteButton = new JButton(PropertyFactory.getString("in_delete"));
        this.deleteButton.setActionCommand(ACTION_DELETE);
        Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 0.0, 0.0, 2, 11);
        this.getContentPane().add((Component)this.deleteButton, gridBagConstraints);
        JButton jButton4 = new JButton(PropertyFactory.getString("in_qsrc_advanced"));
        jButton4.setActionCommand(ACTION_ADVANCED);
        this.getRootPane().setDefaultButton(jButton4);
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0, 0, 17);
        this.getContentPane().add((Component)jButton4, gridBagConstraints);
        JButton jButton5 = new JButton(PropertyFactory.getString("in_load"));
        jButton5.setActionCommand(ACTION_LOAD);
        this.getRootPane().setDefaultButton(jButton5);
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0, 0, 13);
        this.getContentPane().add((Component)jButton5, gridBagConstraints);
        JButton jButton6 = new JButton(PropertyFactory.getString("in_cancel"));
        jButton6.setActionCommand(ACTION_CANCEL);
        Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0);
        this.getContentPane().add((Component)jButton6, gridBagConstraints);
        jButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        jButton2.addActionListener(this);
        jButton3.addActionListener(this);
        jButton4.addActionListener(this);
        jButton5.addActionListener(this);
        jButton6.addActionListener(this);
        this.sourceList.addListSelectionListener(this);
        this.valueChanged(null);
        this.sourceList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                SourceSelectionDialog.this.sourceListMouseClicked(mouseEvent);
            }
        });
        this.pack();
    }

    private List<String> getSourceNames() {
        String[] stringArray;
        Object object;
        String string;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.nameToSourceMap.clear();
        this.nameToGameModeMap.clear();
        for (Campaign object32 : Globals.getCampaignList()) {
            if (!object32.getSafe(ObjectKey.SHOW_IN_MENU).booleanValue()) continue;
            string = object32.getDisplayName();
            arrayList.add(string);
            this.nameToGameModeMap.put(string, object32.getSafeListFor(ListKey.GAME_MODE).get(0));
            object = new ArrayList();
            object.add(object32.getKeyName());
            this.nameToSourceMap.put(string, (List<String>)object);
        }
        for (GameMode gameMode : SystemCollections.getUnmodifiableGameModeList()) {
            string = gameMode.getDefaultSourceTitle();
            if (SettingsHandler.getGame().equals(gameMode) && string == null && !gameMode.getDefaultDataSetList().isEmpty()) {
                string = PropertyFactory.getFormattedString("in_qsrc_game_default", gameMode.getDisplayName());
            }
            if (string == null || "".equals(string)) continue;
            arrayList.add(string);
            this.nameToGameModeMap.put(string, gameMode.getName());
            this.nameToSourceMap.put(string, gameMode.getDefaultDataSetList());
        }
        List<URI> list = PersistenceManager.getInstance().getChosenCampaignSourcefiles();
        if (!list.isEmpty()) {
            String string2 = SettingsHandler.getGame().getName();
            boolean bl = false;
            for (Object object2 : arrayList) {
                if (!this.isSameCollection((String)object2, string2, list)) continue;
                bl = true;
                this.lastLoadedCollection = object2;
            }
            if (!bl) {
                Object object2;
                object = PropertyFactory.getFormattedString("in_qsrc_last_loaded", string2);
                arrayList.add(object);
                this.nameToGameModeMap.put((String)object, string2);
                object2 = this.convertToNames(list);
                this.nameToSourceMap.put((String)object, (List<String>)object2);
            }
        }
        String string3 = SettingsHandler.getHiddenSources();
        String[] stringArray2 = string3.split("\\|");
        for (String string4 : stringArray2) {
            arrayList.remove(string4);
        }
        object = new ArrayList();
        String string5 = SettingsHandler.getQuickLaunchSources();
        for (String string6 : stringArray = string5.split("\\|")) {
            if (!arrayList.contains(string6)) continue;
            arrayList.remove(string6);
            object.add(string6);
        }
        Collections.sort(arrayList);
        for (String string7 : arrayList) {
            object.add(string7);
        }
        String string8 = StringUtil.join(object, "|");
        SettingsHandler.setQuickLaunchSources(string8);
        return object;
    }

    private boolean isSameCollection(String string, String string2, List<URI> list) {
        if (!string2.equals(this.nameToGameModeMap.get(string))) {
            return false;
        }
        List<String> list2 = this.nameToSourceMap.get(string);
        if (list.size() != list2.size()) {
            return false;
        }
        for (URI uRI : list) {
            Campaign campaign = Globals.getCampaignByURI(uRI);
            if (campaign != null && list2.contains(OutputNameFormatting.piString(campaign, true))) continue;
            return false;
        }
        return true;
    }

    private List<String> convertToNames(List<URI> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (URI uRI : list) {
            String string = uRI.getPath();
            arrayList.add(SourceSelectionUtils.convertPathToDataPath(string));
        }
        return arrayList;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (ACTION_LOAD.equals(actionEvent.getActionCommand())) {
            this.loadButtonAction();
        } else if (ACTION_CANCEL.equals(actionEvent.getActionCommand())) {
            this.cancelButtonAction();
        } else if (ACTION_ADD.equals(actionEvent.getActionCommand())) {
            this.addButtonAction();
        } else if (ACTION_HIDE.equals(actionEvent.getActionCommand())) {
            this.hideButtonAction();
        } else if (ACTION_UNHIDE.equals(actionEvent.getActionCommand())) {
            this.unhideButtonAction();
        } else if (ACTION_ADVANCED.equals(actionEvent.getActionCommand())) {
            this.advancedButtonAction();
        } else if (ACTION_DELETE.equals(actionEvent.getActionCommand())) {
            this.deleteButtonAction();
        } else if (ACTION_MODIFY.equals(actionEvent.getActionCommand())) {
            // empty if block
        }
    }

    private void addButtonAction() {
        GameModeDialog gameModeDialog = new GameModeDialog((Frame)this.getParent(), true);
        gameModeDialog.setVisible(true);
        String string = gameModeDialog.getGameModeKey();
        SourceSelectionUtils.unloadSources();
        if (!Globals.isInGameMode(string)) {
            SourceSelectionUtils.changeGameMode(string);
        }
        CreateSourceDialog createSourceDialog = new CreateSourceDialog((Frame)this.getParent(), true);
        createSourceDialog.setVisible(true);
        SourceSelectionUtils.refreshSources();
        this.sourceModel.clear();
        List<String> list = this.getSourceNames();
        for (String string2 : list) {
            this.sourceModel.addElement(string2);
        }
    }

    private void advancedButtonAction() {
        PCGen_Frame1.getInst().switchSourceSelectMeans(true);
        this.setVisible(false);
        this.dispose();
    }

    private void sourceListMouseClicked(MouseEvent mouseEvent) {
        if (this.sourceList.getSelectedIndex() >= 0 && mouseEvent.getClickCount() == 2) {
            this.loadButtonAction();
        }
    }

    public void loadButtonAction() {
        if (this.sourceList.getSelectedIndex() < 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_qsrc_err_none_selected"), PropertyFactory.getString("in_qsrc_title"), MessageType.ERROR);
            return;
        }
        String string = (String)this.sourceList.getSelectedValue();
        String string2 = this.nameToGameModeMap.get(string);
        List<String> list = this.nameToSourceMap.get(string);
        SourceSelectionUtils.unloadSources();
        if (!Globals.isInGameMode(string2)) {
            SourceSelectionUtils.changeGameMode(string2);
        }
        ArrayList<Campaign> arrayList = new ArrayList<Campaign>();
        for (String string3 : list) {
            Campaign campaign = Globals.getCampaignKeyed(string3);
            arrayList.add(campaign);
        }
        SourceSelectionUtils.loadSources(arrayList);
        this.setVisible(false);
        this.dispose();
    }

    public void cancelButtonAction() {
        this.setVisible(false);
        this.dispose();
    }

    private void deleteButtonAction() {
        int n = this.sourceList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string = (String)this.sourceList.getSelectedValue();
        List<String> list = this.nameToSourceMap.get(string);
        if (list.size() == 1) {
            Campaign campaign = Globals.getCampaignKeyed(list.get(0));
            URI uRI = campaign.getSourceURI();
            File file = new File(uRI);
            if (!file.delete()) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_qsrc_err_delete", file.getAbsolutePath()), PropertyFactory.getString("in_qsrc_title"), MessageType.ERROR);
                return;
            }
            this.sourceModel.remove(n);
            if (n < this.sourceModel.getSize()) {
                this.sourceList.setSelectedIndex(n);
            }
            this.rebuildQuickSourcePrefsString();
        }
    }

    private void hideButtonAction() {
        String string;
        int n = this.sourceList.getSelectedIndex();
        if (n < 0) {
            return;
        }
        String string2 = (String)this.sourceList.getSelectedValue();
        this.sourceModel.remove(n);
        if (n < this.sourceModel.getSize()) {
            this.sourceList.setSelectedIndex(n);
        }
        if ((string = SettingsHandler.getHiddenSources()).length() > 0) {
            string = string + "|";
        }
        string = string + string2;
        SettingsHandler.setHiddenSources(string);
        this.rebuildQuickSourcePrefsString();
    }

    void rebuildQuickSourcePrefsString() {
        String string = "";
        for (int i = 0; i < this.sourceModel.getSize(); ++i) {
            String string2 = (String)this.sourceModel.get(i);
            string = string + (i > 0 ? "|" : "") + string2;
        }
        SettingsHandler.setQuickLaunchSources(string);
    }

    private void unhideButtonAction() {
        UnhideDialog unhideDialog = new UnhideDialog((Frame)this.getParent(), true, this.sourceModel);
        unhideDialog.setVisible(true);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        String string;
        List<String> list;
        boolean bl = false;
        if (this.sourceList.getSelectedIndex() >= 0 && (list = this.nameToSourceMap.get(string = (String)this.sourceList.getSelectedValue())).size() == 1) {
            Campaign campaign = Globals.getCampaignKeyed(list.get(0));
            String string2 = campaign.get(StringKey.DATA_PRODUCER);
            bl = "Custom".equalsIgnoreCase(string2);
        }
        this.deleteButton.setEnabled(bl);
        this.modifyButton.setEnabled(false);
    }

    private static class GameModeDialog
    extends JDialog
    implements ActionListener {
        private static final String ACTION_OK = "OK";
        JComboBoxEx gameModeCombo;
        String gameModeKey = "";

        public GameModeDialog(Frame frame, boolean bl) {
            super(frame, bl);
            this.setTitle(PropertyFactory.getString("in_cs_title"));
            this.initComponents();
            this.setLocationRelativeTo(frame);
        }

        private void initComponents() {
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            JLabel jLabel = new JLabel(PropertyFactory.getString("in_qsrc_gameModeIntro"));
            Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 2, 17);
            this.getContentPane().add((Component)jLabel, gridBagConstraints);
            List<GameMode> list = SystemCollections.getUnmodifiableGameModeList();
            Object[] objectArray = new String[list.size()];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = list.get(i).getDisplayName();
            }
            this.gameModeCombo = new JComboBoxEx(objectArray);
            this.gameModeCombo.setSelectedItem(SettingsHandler.getGame().getDisplayName());
            Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 1, 17);
            this.getContentPane().add((Component)this.gameModeCombo, gridBagConstraints);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            jButton.setActionCommand(ACTION_OK);
            this.getRootPane().setDefaultButton(jButton);
            jPanel.add(jButton);
            JButton jButton2 = new JButton(PropertyFactory.getString("in_cancel"));
            jButton2.setActionCommand(SourceSelectionDialog.ACTION_CANCEL);
            jPanel.add(jButton2);
            Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0, 0, 13);
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            jButton.addActionListener(this);
            jButton2.addActionListener(this);
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ACTION_OK.equals(actionEvent.getActionCommand())) {
                String string = (String)this.gameModeCombo.getSelectedItem();
                for (GameMode gameMode : SystemCollections.getUnmodifiableGameModeList()) {
                    if (!gameMode.getDisplayName().equals(string)) continue;
                    this.gameModeKey = gameMode.getName();
                }
            }
            this.setVisible(false);
            this.dispose();
        }

        public String getGameModeKey() {
            return this.gameModeKey;
        }
    }

    private class UnhideDialog
    extends JDialog
    implements ActionListener {
        private static final String ACTION_OK = "OK";
        DefaultListModel sourcesList;
        JList hiddenList;

        public UnhideDialog(Frame frame, boolean bl, DefaultListModel defaultListModel) {
            super(frame, bl);
            this.setTitle(PropertyFactory.getString("in_qsrc_unhide_title"));
            this.sourcesList = defaultListModel;
            this.initComponents();
            this.setLocationRelativeTo(frame);
        }

        private void initComponents() {
            this.setDefaultCloseOperation(2);
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(4, 4, 4, 4);
            this.hiddenList = new JList();
            this.hiddenList.setModel(new AbstractListModel(){
                String[] strings = this.getHiddenSourceNames();

                public int getSize() {
                    return this.strings.length;
                }

                public Object getElementAt(int n) {
                    return this.strings[n];
                }

                private String[] getHiddenSourceNames() {
                    String string = SettingsHandler.getHiddenSources();
                    Object[] objectArray = string.split("\\|");
                    Arrays.sort(objectArray);
                    return objectArray;
                }
            });
            this.hiddenList.setSelectionMode(2);
            JScrollPane jScrollPane = new JScrollPane(this.hiddenList);
            Utility.buildRelativeConstraints(gridBagConstraints, 0, 1, 100.0, 100.0, 1, 17);
            this.getContentPane().add((Component)jScrollPane, gridBagConstraints);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new FlowLayout());
            JButton jButton = new JButton(PropertyFactory.getString("in_ok"));
            jButton.setActionCommand(ACTION_OK);
            this.getRootPane().setDefaultButton(jButton);
            jPanel.add(jButton);
            JButton jButton2 = new JButton(PropertyFactory.getString("in_cancel"));
            jButton2.setActionCommand(SourceSelectionDialog.ACTION_CANCEL);
            jPanel.add(jButton2);
            Utility.buildRelativeConstraints(gridBagConstraints, 1, 1, 0.0, 0.0, 0, 13);
            this.getContentPane().add((Component)jPanel, gridBagConstraints);
            jButton.addActionListener(this);
            jButton2.addActionListener(this);
            this.pack();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ACTION_OK.equals(actionEvent.getActionCommand())) {
                Object[] objectArray;
                String string = SettingsHandler.getHiddenSources();
                Object[] objectArray2 = string.split("\\|");
                for (Object object : objectArray = this.hiddenList.getSelectedValues()) {
                    objectArray2 = (String[])ArrayUtils.removeElement(objectArray2, object);
                    SourceSelectionDialog.this.sourceModel.addElement(object);
                }
                String string2 = StringUtil.join((String[])objectArray2, "|");
                SettingsHandler.setHiddenSources(string2);
                SourceSelectionDialog.this.rebuildQuickSourcePrefsString();
            }
            this.setVisible(false);
            this.dispose();
        }
    }

    private static class SourceListCellRenderer
    extends JToggleButton
    implements ListCellRenderer {
        public SourceListCellRenderer() {
            this.setHorizontalAlignment(0);
            this.setVerticalAlignment(1);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText("<HTML>" + String.valueOf(object) + "</HTML>");
            this.setPreferredSize(new Dimension(120, 120));
            this.setContentAreaFilled(bl);
            this.setSelected(bl);
            return this;
        }
    }
}

