/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.sources;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import pcgen.core.Campaign;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PersistenceObserver;
import pcgen.gui.sources.InfoPanel;
import pcgen.persistence.PersistenceLayerException;
import pcgen.persistence.PersistenceManager;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.SwingWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SourceSelectionUtils {
    public static void changeGameMode(String string) {
        SettingsHandler.setGame(string);
        Globals.createEmptyRace();
        PCGen_Frame1.getInst().getPcgenMenuBar().getGameModeMenu().updateMenu();
        PCGen_Frame1.getInst().getMainSource().changedGameMode();
        InfoPanel infoPanel = PCGen_Frame1.getInst().getInfoPanel();
        if (infoPanel != null) {
            infoPanel.refreshDisplay();
        }
    }

    public static boolean unloadSources() {
        PCGen_Frame1 pCGen_Frame1 = PCGen_Frame1.getInst();
        if (Logging.isDebugMode()) {
            ShowMessageDelegate.showMessageDialog("PCs are not closed in debug mode.  Please be aware that they may not function correctly until campaign data is loaded again.", "PCGen", MessageType.WARNING);
        } else {
            pCGen_Frame1.closeAllPCs();
            if (PCGen_Frame1.getBaseTabbedPane().getTabCount() > PCGen_Frame1.FIRST_CHAR_TAB) {
                ShowMessageDelegate.showMessageDialog("Can't unload campaigns until all PC's are closed.", "PCGen", MessageType.INFORMATION);
                return false;
            }
            PCGen_Frame1.setCharacterPane(null);
        }
        Globals.emptyLists();
        PersistenceManager.getInstance().emptyLists();
        for (Campaign campaign : Globals.getCampaignList()) {
            campaign.setIsLoaded(false);
        }
        pCGen_Frame1.enableLstEditors(false);
        PCGen_Frame1.enableDisableMenuItems();
        PCGen_Frame1.getInst().getMainSource().campaignsUnloaded();
        return true;
    }

    public static boolean loadSources(final List<Campaign> list) {
        PCGen_Frame1.getInst().closeAllPCs();
        if (PCGen_Frame1.getBaseTabbedPane().getTabCount() > PCGen_Frame1.FIRST_CHAR_TAB) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_campaignChangeError"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        SwingWorker swingWorker = new SwingWorker(){
            String oldStatus;

            public Object construct() {
                this.oldStatus = SourceSelectionUtils.doCampaignLoad(list);
                return "";
            }

            public void finished() {
                SourceSelectionUtils.showCampaignsLoaded(this.oldStatus);
            }
        };
        swingWorker.start();
        return true;
    }

    private static String doCampaignLoad(List<Campaign> list) {
        Globals.emptyLists();
        PersistenceManager persistenceManager = PersistenceManager.getInstance();
        persistenceManager.emptyLists();
        persistenceManager.setChosenCampaignSourcefiles(new ArrayList<URI>());
        for (Campaign object2 : Globals.getCampaignList()) {
            object2.setIsLoaded(false);
        }
        String string = PCGen_Frame1.getInst().getMainSource().showLoadingSources();
        PersistenceObserver persistenceObserver = new PersistenceObserver();
        persistenceManager.addObserver(persistenceObserver);
        Logging.registerHandler(persistenceObserver.getHandler());
        try {
            persistenceManager.loadCampaigns(list);
        }
        catch (PersistenceLayerException persistenceLayerException) {
            Logging.errorPrint("Failed to load campaigns", persistenceLayerException);
            ShowMessageDelegate.showMessageDialog(persistenceLayerException.getMessage(), "PCGen", MessageType.WARNING);
        }
        Logging.removeHandler(persistenceObserver.getHandler());
        persistenceManager.deleteObserver(persistenceObserver);
        return string;
    }

    private static void showCampaignsLoaded(String string) {
        PCGen_Frame1 pCGen_Frame1;
        PCGen_Frame1.getInst().getMainSource().updateLoadedCampaignsUI();
        PCGen_Frame1.getInst().getMainSource().showSourcesLoaded(string);
        InfoPanel infoPanel = PCGen_Frame1.getInst().getInfoPanel();
        if (infoPanel != null) {
            infoPanel.refreshDisplay();
        }
        if ((pCGen_Frame1 = PCGen_Frame1.getInst()) != null && Globals.displayListsHappy()) {
            pCGen_Frame1.enableNew(true);
            pCGen_Frame1.enableLstEditors(true);
        }
    }

    public static void refreshSources() {
        PCGen_Frame1.getInst().getMainSource().refreshCampaigns();
    }

    public static String sanitiseFilename(String string, String string2) {
        String string3 = string.replaceAll("[^A-Za-z0-9\\.-]", "_");
        if (string2 != null && string2.length() > 0 && !string3.toLowerCase().endsWith(string2.toLowerCase())) {
            string3 = string3 + string2;
        }
        return string3;
    }

    public static String convertPathToDataPath(String string) {
        String string2;
        String string3;
        String string4 = new File(string).toURI().getPath();
        if (string4.startsWith(string3 = SettingsHandler.getPccFilesLocation().toURI().getPath())) {
            return "@" + string4.substring(string3.length() - 1);
        }
        if (SettingsHandler.getPcgenVendorDataDir() != null && string4.startsWith(string2 = SettingsHandler.getPcgenVendorDataDir().toURI().getPath())) {
            return "&" + string4.substring(string2.length() - 1);
        }
        return string;
    }
}

