/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pcgen.core.GameMode;
import pcgen.core.SettingsHandler;
import pcgen.gui.tabs.InfoCharacterSheet;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

class CharacterSheetSelectionPanel
extends JPanel
implements ItemListener {
    private InfoCharacterSheet theParent;
    private JComboBox theCombo;
    private String theSheetDir;
    private GameMode theGameMode = null;
    private boolean initialized = false;

    CharacterSheetSelectionPanel(InfoCharacterSheet infoCharacterSheet) {
        this.theParent = infoCharacterSheet;
        this.theGameMode = SettingsHandler.getGame();
        this.theSheetDir = SettingsHandler.getPcgenPreviewDir() + File.separator + SettingsHandler.getGame().getPreviewDir();
        this.initComponents();
    }

    private void initComponents() {
        JLabel jLabel = new JLabel(PropertyFactory.getString("in_character_sheet"));
        this.add(jLabel);
        this.theCombo = new JComboBox();
        this.theCombo.addItemListener(this);
        this.add(this.theCombo);
        this.buildCombo();
        this.initialized = true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.initialized) {
            return;
        }
        JComboBox jComboBox = (JComboBox)itemEvent.getSource();
        if (itemEvent.getStateChange() == 1) {
            String string = (String)jComboBox.getSelectedItem();
            SettingsHandler.setPCGenOption("InfoCharacterSheet." + SettingsHandler.getGame().getName() + ".CurrentSheet", string);
            File file = new File(this.theSheetDir + File.separator + string);
            this.theParent.setSheet(file);
        }
    }

    public void refresh() {
        if (SettingsHandler.getGame() != this.theGameMode) {
            this.theSheetDir = SettingsHandler.getPcgenPreviewDir() + File.separator + SettingsHandler.getGame().getPreviewDir();
            this.buildCombo();
        }
    }

    private void buildCombo() {
        File file = new File(this.theSheetDir);
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            Logging.errorPrint("Could not find preview sheet directory " + this.theSheetDir);
            return;
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory() || fileArray[i].isHidden()) continue;
            this.theCombo.addItem(fileArray[i].getName());
        }
        String string = SettingsHandler.getPCGenOption("InfoCharacterSheet." + SettingsHandler.getGame().getName() + ".CurrentSheet", SettingsHandler.getGame().getDefaultPreviewSheet());
        File file2 = new File(this.theSheetDir + File.separator + string);
        this.theCombo.setSelectedItem(file2.getName());
        this.theParent.setSheet(file2);
    }
}

