/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.base.lang.StringUtil;
import pcgen.cdom.enumeration.MapKey;
import pcgen.cdom.enumeration.ObjectKey;
import pcgen.cdom.enumeration.SourceFormat;
import pcgen.cdom.enumeration.StringKey;
import pcgen.cdom.enumeration.Type;
import pcgen.cdom.reference.CDOMDirectSingleRef;
import pcgen.core.AbilityCategory;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.analysis.OutputNameFormatting;
import pcgen.core.character.EquipSet;
import pcgen.core.character.WieldCategory;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.PrerequisiteUtilities;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.EQFrame;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.TableColumnManager;
import pcgen.gui.TableColumnManagerModel;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.tabs.InfoTabUtils;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.ClickHandler;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.InfoLabelTextBuilder;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableMouseAdapter;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.Utility;
import pcgen.util.BigDecimalHelper;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.enumeration.Tab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class InfoGear
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -2320970658737297916L;
    private static final Tab tab = Tab.GEAR;
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static int viewMode = 1;
    private static int viewSelectMode = 2;
    private static Integer saveAvailableViewMode = null;
    private static Integer saveSelectedViewMode = null;
    private static final int COL_NAME = 0;
    private static final int COL_COST = 1;
    private static final int COL_WEIGHT = 2;
    private static final int COL_QTY = 3;
    private static final int COL_INDEX = 4;
    private static final int COL_SRC = 5;
    private static Object typeSubtypeRoot;
    private static Object typeRoot;
    private static Object allTypeRoot;
    private static Object sourceRoot;
    private BuyGearActionListener buyOneListener = new BuyGearActionListener(1);
    private EQFrame eqFrame = null;
    private EquipmentModel availableModel = null;
    private EquipmentModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JComboBoxEx cmbBuyPercent = new JComboBoxEx();
    private JComboBoxEx cmbSellPercent = new JComboBoxEx();
    private final JLabel lblAvailableQFilter = new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel"));
    private final JLabel lblSelectedQFilter = new JLabel(PropertyFactory.getString("InfoTabs.FilterLabel"));
    private final JLabel goldLabel = new JLabel(Globals.getLongCurrencyDisplay() + ": ");
    private final JLabel lblBuyRate = new JLabel(PropertyFactory.getString("in_igBuyRateLabel"));
    private final JLabel lblSellRate = new JLabel(PropertyFactory.getString("in_igSellRateLabel"));
    private final JLabel valueLabel = new JLabel(PropertyFactory.getString("in_igValueLabel"));
    private JButton addButton;
    private JButton removeButton;
    private JButton clearAvailableQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private JButton clearSelectedQFilterButton = new JButton(PropertyFactory.getString("in_clear"));
    private JCheckBox allowDebtBox = new JCheckBox(PropertyFactory.getString("in_igAllowDebt"));
    private JCheckBox autoResize = new JCheckBox(PropertyFactory.getString("in_igAutoResize"));
    private JCheckBox autoSort = new JCheckBox(PropertyFactory.getString("in_igAutoSort"), true);
    private JCheckBox chkViewAll = new JCheckBox();
    private JCheckBox costBox = new JCheckBox(PropertyFactory.getString("in_igIgnoreCost"));
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel = new JLabelPane();
    private JMenu pcCopyMenu = Utility.createMenu(PropertyFactory.getString("in_igCopyItemMenuTitle"), '\u0000', PropertyFactory.getString("in_igCopyItemMenuDesc"), null, true);
    private JMenu pcMoveMenu = Utility.createMenu(PropertyFactory.getString("in_igMoveItemMenuTitle"), '\u0000', PropertyFactory.getString("in_igMoveItemMenuDesc"), null, true);
    private JPanel center = new JPanel();
    private JPanel pnlBuy = new JPanel();
    private JPanel pnlSell = new JPanel();
    private JPanel south = new JPanel();
    private JScrollPane eqScroll = new JScrollPane();
    private JTextField textAvailableQFilter = new JTextField();
    private JTextField textSelectedQFilter = new JTextField();
    private JTextField gold = new JTextField();
    private JTextField totalValue = new JTextField("Temp");
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private SellGearActionListener sellOneListener = new SellGearActionListener(1);
    private Runnable sellOneRunnable = new Runnable(){

        public void run() {
            InfoGear.this.sellOneListener.actionPerformed(null);
        }
    };
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private boolean readyForRefresh = false;
    private PlayerCharacter pc;
    private int serial = 0;

    public InfoGear(PlayerCharacter playerCharacter) {
        this.pc = playerCharacter;
        this.setName(tab.toString());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoGear.this.initComponents();
                InfoGear.this.initActionListeners();
            }
        });
    }

    @Override
    public void setPc(PlayerCharacter playerCharacter) {
        if (this.pc != playerCharacter || playerCharacter.getSerial() > this.serial) {
            this.pc = playerCharacter;
            this.serial = playerCharacter.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public PlayerCharacter getPc() {
        return this.pc;
    }

    @Override
    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Gear.Order", tab.ordinal());
    }

    @Override
    public void setTabOrder(int n) {
        SettingsHandler.setPCGenOption(".Panel.Gear.Order", n);
    }

    @Override
    public String getTabName() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabName(tab);
    }

    @Override
    public boolean isShown() {
        GameMode gameMode = SettingsHandler.getGame();
        return gameMode.getTabShown(tab);
    }

    @Override
    public List<String> getToDos() {
        ArrayList<String> arrayList = new ArrayList<String>();
        return arrayList;
    }

    @Override
    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    @Override
    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    @Override
    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean bl) {
        needsUpdate = bl;
    }

    @Override
    public boolean isMatchAnyEnabled() {
        return true;
    }

    @Override
    public boolean isNegateEnabled() {
        return true;
    }

    @Override
    public int getSelectionMode() {
        return 2;
    }

    public void buySpecifiedEquipment(Equipment equipment, double d) {
        this.buySpecifiedEquipmentRate(equipment, d, SettingsHandler.getGearTab_BuyRate());
    }

    @Override
    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllEquipmentFilters(this);
    }

    public void refreshAvailableList(Equipment equipment, boolean bl, boolean bl2) {
        this.availableModel.addItemToModel(equipment, true);
        this.availableModel.updateTree();
        this.availableTable.updateUI();
        if (bl2 && this.availableTable.search(equipment.getName(), true) != null) {
            this.availableTable.requestFocus();
        }
        if (bl) {
            this.buySpecifiedEquipment(equipment, 1.0);
        }
    }

    @Override
    public void refreshFiltering() {
        this.forceRefresh();
    }

    public void sellSpecifiedEquipment(Equipment equipment, double d) {
        this.sellSpecifiedEquipmentRate(equipment, d, SettingsHandler.getGearTab_SellRate());
    }

    private void updateCharacterInfo() {
        int n = 0;
        this.pcMoveMenu.removeAll();
        this.pcCopyMenu.removeAll();
        for (PlayerCharacter playerCharacter : Globals.getPCList()) {
            if (playerCharacter != this.pc) {
                this.pcMoveMenu.add(Utility.createMenuItem(playerCharacter.getName(), new MoveItemListener(n, 0), "MoveItemTo", '\u0000', null, "Move Item To " + playerCharacter.getName(), null, true));
                this.pcCopyMenu.add(Utility.createMenuItem(playerCharacter.getName(), new MoveItemListener(n, 1), "CopyItemTo", '\u0000', null, "Copy Item To " + playerCharacter.getName(), null, true));
            }
            ++n;
        }
        this.pcMoveMenu.setEnabled(this.pcMoveMenu.getItemCount() > 0);
        this.pcCopyMenu.setEnabled(this.pcCopyMenu.getItemCount() > 0);
        if (!needsUpdate) {
            return;
        }
        this.autoSort.setSelected(this.pc.isAutoSortGear());
        this.costBox.setSelected(this.pc.isIgnoreCost());
        this.allowDebtBox.setSelected(this.pc.isAllowDebt());
        this.autoResize.setSelected(this.pc.isAutoResize());
        this.pc.aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.gold.setText(this.pc.getGold().toString());
        this.updateTotalValue();
        needsUpdate = false;
    }

    private static int getEventSelectedIndex(ListSelectionEvent listSelectionEvent) {
        DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)listSelectionEvent.getSource();
        if (defaultListSelectionModel == null) {
            return -1;
        }
        return defaultListSelectionModel.getMinSelectionIndex();
    }

    private Object getCurrentAvailableTableItem() {
        Object object = null;
        int n = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
        if (n >= 0) {
            TreePath treePath = this.availableTable.getTree().getPathForRow(n);
            Object object2 = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object2;
            object = pObjectNode.getItem();
        }
        return object;
    }

    private Object getCurrentSelectedTableItem() {
        Object object = null;
        int n = this.selectedTable.getSelectionModel().getAnchorSelectionIndex();
        if (n >= 0) {
            TreePath treePath = this.selectedTable.getTree().getPathForRow(n);
            Object object2 = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object2;
            object = pObjectNode.getItem();
        }
        return object;
    }

    private int getHighestOutputIndex() {
        int n = 0;
        if (this.pc == null) {
            return 0;
        }
        for (Equipment equipment : this.pc.getEquipmentMasterList()) {
            if (equipment.getOutputIndex() <= n) continue;
            n = equipment.getOutputIndex();
        }
        return n;
    }

    private void setInfoLabelText(Equipment equipment) {
        if (equipment != null) {
            Map<String, String> map;
            int n;
            Integer n2;
            String string;
            String string2;
            Object object;
            StringBuilder stringBuilder = new StringBuilder(50);
            stringBuilder.append(OutputNameFormatting.piString(equipment, false));
            if (!equipment.longName().equals(equipment.getName())) {
                stringBuilder.append("(").append(equipment.longName()).append(")");
            }
            InfoLabelTextBuilder infoLabelTextBuilder = new InfoLabelTextBuilder(stringBuilder.toString());
            infoLabelTextBuilder.appendLineBreak();
            infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextType", StringUtil.join(equipment.getTrueTypeList(true), ". "));
            if (equipment.isWeapon() || equipment.get(ObjectKey.WIELD) != null) {
                infoLabelTextBuilder.appendSpacer();
                object = equipment.getEffectiveWieldCategory(this.pc);
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextWield", ((WieldCategory)object).getName());
            }
            if (equipment.isWeapon() || equipment.isArmor() || equipment.isShield()) {
                infoLabelTextBuilder.appendSpacer();
                object = this.pc.isProficientWith(equipment) && equipment.meetsPreReqs(this.pc) ? PropertyFactory.getString("in_igInfoLabelTextYes") : SettingsHandler.getPrereqFailColorAsHtmlStart() + PropertyFactory.getString("in_igInfoLabelTextNo") + SettingsHandler.getPrereqFailColorAsHtmlEnd();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextProficient", (String)object);
            }
            if (((String)(object = PrerequisiteUtilities.preReqHTMLStringsForList(this.pc, null, equipment.getPrerequisiteList(), false))).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextReq", (String)object);
            }
            if ((string2 = equipment.getInterestingDisplayString(this.pc)).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextProp", string2);
            }
            if ((string = Globals.getGameModeUnitSet().displayWeightInUnitSet(equipment.getWeight(this.pc).doubleValue())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                string = string + Globals.getGameModeUnitSet().getWeightUnit();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextWeight", string);
            }
            if ((n2 = equipment.getMaxDex(this.pc)) != 100) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextMaxDex", n2.toString());
            }
            n2 = equipment.acCheck(this.pc);
            if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextAcCheck", n2.toString());
            }
            if (Globals.getGameModeACText().length() != 0) {
                n2 = equipment.getACBonus(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendSpacer();
                    infoLabelTextBuilder.appendElement(PropertyFactory.getFormattedString("in_igInfoLabelTextAcBonus", Globals.getGameModeACText()), n2.toString());
                }
            }
            if (Globals.getGameModeShowSpellTab()) {
                n2 = equipment.spellFailure(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendSpacer();
                    infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextArcaneFailure", n2.toString());
                }
            }
            if ((string = Globals.getGameModeDamageResistanceText()).length() != 0) {
                n2 = equipment.eDR(this.pc);
                if (equipment.isArmor() || equipment.isShield() || n2 != 0) {
                    infoLabelTextBuilder.appendSpacer();
                    infoLabelTextBuilder.appendElement(string, n2.toString());
                }
            }
            if ((string = equipment.moveString()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextMove", string);
            }
            if ((string = equipment.getSize()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextSize", string);
            }
            if ((string = equipment.getDamage(this.pc)).length() > 0) {
                if (equipment.isDouble()) {
                    string = string + "/" + equipment.getAltDamage(this.pc);
                }
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextDamage", string);
            }
            int n3 = this.pc.getCritRange(equipment, true);
            int n4 = this.pc.getCritRange(equipment, false);
            String string3 = string = n3 == 0 ? "" : Integer.toString(n3);
            if (equipment.isDouble() && n3 != n4) {
                string = string + "/" + (n4 == 0 ? "" : Integer.toString(n4));
            }
            if (string.length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_ieInfoLabelTextCritRange", string);
            }
            string = equipment.getCritMult();
            if (equipment.isDouble() && equipment.getCritMultiplier() != equipment.getAltCritMultiplier()) {
                string = string + "/" + equipment.getAltCritMult();
            }
            if (string.length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextCritMult", string);
            }
            if (equipment.isWeapon() && (string = Globals.getGameModeUnitSet().displayDistanceInUnitSet(equipment.getRange(this.pc).intValue())).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextRange", string + Globals.getGameModeUnitSet().getDistanceUnit());
            }
            if ((string = equipment.getContainerCapacityString()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextContainer", string);
            }
            if ((string = equipment.getContainerContentsString()).length() > 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextCurrentlyContains", string);
            }
            if ((n = equipment.getRemainingCharges()) >= 0) {
                infoLabelTextBuilder.appendSpacer();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextCharges", Integer.valueOf(n).toString());
            }
            if ((map = equipment.getMapFor(MapKey.QUALITY)) != null) {
                infoLabelTextBuilder.appendSpacer();
                TreeSet<String> treeSet = new TreeSet<String>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    treeSet.add(entry.getKey() + ": " + entry.getValue());
                }
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextQualities", StringUtil.join(treeSet, ", "));
            }
            if ((string = equipment.getDefaultSourceString()).length() > 0) {
                infoLabelTextBuilder.appendLineBreak();
                infoLabelTextBuilder.appendI18nElement("in_igInfoLabelTextSource", string);
            }
            this.infoLabel.setText(infoLabelTextBuilder.toString());
        } else {
            this.infoLabel.setText();
        }
    }

    private double adjustBelongings(Equipment equipment, double d) {
        int n = 1;
        double d2 = d;
        if (this.pc != null) {
            Equipment equipment2 = this.pc.getEquipmentNamed(equipment.getName());
            if (equipment2 != null) {
                double d3 = equipment2.qty() < 0.0 ? 0.0 : equipment2.qty();
                double d4 = d3 + d;
                double d5 = this.getNumberOfItemInUse(this.pc, equipment2);
                if (d4 <= 0.0) {
                    if (d5 > 0.0) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_igAdjBelongStillEquiped", equipment2.getName()), "PCGen", MessageType.ERROR);
                        return 0.0;
                    }
                    d2 = -d3;
                    equipment2.setNumberCarried(new Float(0.0f));
                    equipment2.setLocation(8);
                    Equipment equipment3 = (Equipment)equipment2.getParent();
                    if (equipment3 != null) {
                        equipment3.removeChild(this.pc, equipment2);
                    }
                    this.pc.removeEquipment(equipment2);
                    this.pc.delEquipSetItem(equipment2);
                    this.selectedModel.removeItemFromNodes(null, equipment2);
                    this.pc.setCalcEquipmentList();
                    this.pc.totalWeight();
                } else {
                    if (d5 > d4) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_igAdjBelongNumberStillEquiped", equipment2.getName(), d4, d5), "PCGen", MessageType.ERROR);
                        return 0.0;
                    }
                    this.pc.updateEquipmentQty(equipment2, d3, d4);
                    Float f = new Float(d4);
                    equipment2.setQty(f);
                    equipment2.setNumberCarried(f);
                    this.selectedModel.setValueForItemInNodes(null, equipment2, d4, 3);
                }
            } else if (d > 0.0 && (equipment2 = equipment.clone()) != null) {
                if (this.autoSort.isSelected()) {
                    equipment2.setOutputIndex(n);
                } else if (equipment2.getOutputIndex() == 0) {
                    equipment2.setOutputIndex(this.getHighestOutputIndex() + 1);
                    this.pc.cacheOutputIndex(equipment2);
                }
                Float f = new Float(d);
                equipment2.setQty(f);
                equipment2.setNumberCarried(f);
                this.pc.addEquipment(equipment2);
                if (this.autoSort.isSelected()) {
                    this.resortSelected(0, true);
                }
                this.selectedModel.addItemToModel(equipment2, true);
            }
            this.pc.setCalcEquipmentList();
            this.updateEqInfo(equipment2);
            this.pc.setDirty(true);
            this.selectedModel.updateTree();
            this.selectedTable.updateUI();
            return d2;
        }
        return 0.0;
    }

    private double getNumberOfItemInUse(PlayerCharacter playerCharacter, Equipment equipment) {
        HashMap<String, Float> hashMap = new HashMap<String, Float>();
        for (EquipSet equipSet : playerCharacter.getEquipSet()) {
            if (!equipSet.getValue().equalsIgnoreCase(equipment.getName())) continue;
            String string = equipSet.getRootIdPath();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new Float(0.0));
            }
            Float f = (Float)hashMap.get(string);
            f = new Float(f.floatValue() + equipSet.getQty().floatValue());
            hashMap.put(string, f);
        }
        if (hashMap.isEmpty()) {
            return 0.0;
        }
        Float f = (Float)Collections.max(hashMap.values());
        return f.doubleValue();
    }

    private void adjustGold(Equipment equipment, double d, int n, int n2) {
        if (!this.costBox.isSelected() && this.pc != null) {
            double d2 = d * (double)equipment.getCost(this.pc).floatValue() * -0.01;
            if (d < 0.0) {
                d2 *= (double)n2;
            } else if (d > 0.0) {
                d2 *= (double)n;
            }
            this.pc.setDirty(true);
            this.pc.adjustGold(d2);
            this.gold.setText(this.pc.getGold().toString());
        }
    }

    private void buySpecifiedEquipmentRate(Equipment equipment, double d) {
        String string = this.cmbSellPercent.getSelectedItem().toString();
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(this, PropertyFactory.getString("in_igBuyPricePercMsg"), PropertyFactory.getString("in_igBuyPricePercTitle"), MessageType.QUESTION, null, string);
        if (object != null) {
            String string2 = object.toString().trim();
            try {
                int n = Integer.parseInt(string2);
                this.buySpecifiedEquipmentRate(equipment, d, n);
            }
            catch (NumberFormatException numberFormatException) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igBuyPricePercNoInteger"), "PCGen", MessageType.ERROR);
            }
        }
    }

    private void buySpecifiedEquipmentRate(Equipment equipment, double d, int n) {
        try {
            String string;
            if (equipment.getSafe(ObjectKey.MOD_CONTROL).getModifiersRequired() && equipment.getEqModifierList(true).size() == 0 && equipment.getEqModifierList(false).size() == 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igBuyMustCustomizeItemFirst"), "PCGen", MessageType.ERROR);
                return;
            }
            double d2 = d;
            if (d2 < 0.0) {
                string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_igBuyEnterQuantity"), "PCGen", 3);
                if (string != null) {
                    try {
                        d2 = Float.parseFloat(string.trim());
                    }
                    catch (Exception exception) {
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igInvalidNumber"), "PCGen", MessageType.ERROR);
                        return;
                    }
                } else {
                    return;
                }
            }
            if (equipment.acceptsChildren() && !CoreUtility.doublesEqual(d2 % 1.0, 0.0)) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igBuyNonIntegralNumContainers"), "PCGen", MessageType.ERROR);
                return;
            }
            if (this.autoResize.isEnabled() && this.autoResize.isSelected() && Globals.canResizeHaveEffect(this.pc, equipment, null) && this.pc.sizeInt() != Globals.sizeInt(equipment.getSize())) {
                string = this.pc.getSize();
                String string2 = equipment.getKeyName();
                String string3 = equipment.createKeyForAutoResize(string);
                Equipment equipment2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string3);
                if (!string3.equals(string2)) {
                    if (equipment2 != null) {
                        equipment = equipment2;
                    } else {
                        String string4 = equipment.createNameForAutoResize(string);
                        equipment2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string4);
                        if (equipment2 != null) {
                            equipment = equipment2;
                        } else {
                            Equipment equipment3 = equipment.clone();
                            if (!equipment3.containsKey(ObjectKey.BASE_ITEM)) {
                                equipment3.put(ObjectKey.BASE_ITEM, CDOMDirectSingleRef.getRef(equipment));
                            }
                            equipment3.setName(string4);
                            equipment3.put(StringKey.OUTPUT_NAME, string4);
                            equipment3.put(StringKey.KEY_NAME, string3);
                            equipment3.resizeItem(this.pc, SettingsHandler.getGame().getSizeAdjustmentNamed(string));
                            equipment3.removeType(Type.AUTO_GEN);
                            equipment3.removeType(Type.STANDARD);
                            if (!equipment3.isType("Custom")) {
                                equipment3.addType(Type.CUSTOM);
                            }
                            Globals.getContext().ref.importObject(equipment3);
                            this.refreshAvailableList(equipment3, false, true);
                            equipment = equipment3;
                        }
                    }
                }
            }
            if (this.canAfford(equipment, d2, n)) {
                this.adjustBelongings(equipment, d2);
                this.adjustGold(equipment, d2, n, 0);
            } else {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_igBuyInsufficientFunds", d, equipment.getName()), "PCGen", MessageType.INFORMATION);
            }
        }
        catch (Exception exception) {
            ShowMessageDelegate.showMessageDialog("buySpecifiedEquipment: Exception:" + exception.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    private boolean canAfford(Equipment equipment, double d, int n) {
        float f = this.pc != null ? this.pc.getGold().floatValue() : 0.0f;
        double d2 = d * (double)n * (double)0.01f * (double)equipment.getCost(this.pc).floatValue();
        return this.costBox.isSelected() || this.allowDebtBox.isSelected() || d2 <= (double)f;
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new EquipmentModel(viewMode, true);
        } else {
            this.availableModel.resetModel(InfoGear.viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private JPanel buildModPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        return jPanel;
    }

    private JPanel buildDelPanel(JButton jButton, String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        Utility.setDescription(jButton, string);
        jButton.setEnabled(false);
        jButton.setMargin(new Insets(1, 14, 1, 14));
        jPanel.add(jButton);
        if (SettingsHandler.allowFeatDebugging()) {
            jPanel.add(this.chkViewAll);
        }
        return jPanel;
    }

    private JPanel buildRemoveItemPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 5, 1));
        jPanel.add(this.removeButton);
        this.autoSort.setSelected(this.pc.isAutoSortGear());
        jPanel.add(this.autoSort);
        Utility.setDescription(this.autoSort, PropertyFactory.getString("in_igAutoSortTip"));
        this.autoSort.setEnabled(true);
        this.autoSort.setMargin(new Insets(1, 14, 1, 14));
        return jPanel;
    }

    private void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new EquipmentModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoGear.viewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        JTree jTree = this.availableTable.getTree();
        jTree.setRootVisible(false);
        jTree.setShowsRootHandles(true);
        jTree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.setSelectionMode(0);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    PObjectNode pObjectNode;
                    int n = InfoGear.getEventSelectedIndex(listSelectionEvent);
                    if (n < 0) {
                        return;
                    }
                    Object object = InfoGear.this.availableTable.getTree().getPathForRow(n).getLastPathComponent();
                    if (object != null) {
                        pObjectNode = (PObjectNode)object;
                        if (!(pObjectNode.getItem() instanceof Equipment)) {
                            InfoGear.this.setInfoLabelText(null);
                            return;
                        }
                    } else {
                        return;
                    }
                    Equipment equipment = (Equipment)pObjectNode.getItem();
                    InfoGear.this.addButton.setEnabled(equipment != null);
                    InfoGear.this.setInfoLabelText(equipment);
                }
            }
        });
        this.availableTable.addMouseListener(new JTreeTableMouseAdapter(this.availableTable, new AvailableClickHandler(), false));
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.getColumnModel().getColumn(3).setCellEditor(new QuantityEditor());
        this.selectedTable.getColumnModel().getColumn(4).setCellEditor(new OutputOrderEditor(new String[]{"First", "Last", "Hidden"}));
        JTree jTree2 = this.selectedTable.getTree();
        jTree2.setRootVisible(false);
        jTree2.setShowsRootHandles(true);
        jTree2.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (!listSelectionEvent.getValueIsAdjusting()) {
                    Equipment equipment = null;
                    Object object = InfoGear.this.getCurrentSelectedTableItem();
                    if (object != null) {
                        if (!(object instanceof Equipment)) {
                            InfoGear.this.setInfoLabelText(null);
                            return;
                        }
                        equipment = (Equipment)object;
                    } else {
                        InfoGear.this.infoLabel.setText();
                    }
                    InfoGear.this.removeButton.setEnabled(equipment != null);
                    InfoGear.this.setInfoLabelText(equipment);
                }
            }
        });
        this.selectedTable.setSelectionMode(0);
        this.selectedTable.addMouseListener(new JTreeTableMouseAdapter(this.selectedTable, new SelectedClickHandler(), false));
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void customizeButtonClick() {
        if (!this.addButton.isEnabled()) {
            return;
        }
        int n = this.availableTable.getSelectedRow();
        if (n >= 0) {
            int n2 = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
            TreePath treePath = this.availableTable.getTree().getPathForRow(n2);
            Object object = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            if (!(pObjectNode.getItem() instanceof Equipment)) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igCanNotCustomizeTypes"), "PCGen", MessageType.ERROR);
                return;
            }
            Equipment equipment = (Equipment)pObjectNode.getItem();
            this.openCustomizer(equipment);
        }
    }

    private void deleteCustomButtonClick() {
        int n = this.availableTable.getSelectedRow();
        if (n >= 0) {
            int n2 = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
            TreePath treePath = this.availableTable.getTree().getPathForRow(n2);
            Object object = treePath.getLastPathComponent();
            PObjectNode pObjectNode = (PObjectNode)object;
            if (!(pObjectNode.getItem() instanceof Equipment)) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igCanNotDeleteTypes"), "PCGen", MessageType.ERROR);
                return;
            }
            Equipment equipment = (Equipment)pObjectNode.getItem();
            if (!equipment.isType("Custom")) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igCanOnlyDeleteCustom"), "PCGen", MessageType.ERROR);
                return;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (PlayerCharacter playerCharacter : Globals.getPCList()) {
                if (playerCharacter.getEquipmentNamed(equipment.getName()) == null) continue;
                arrayList.add(playerCharacter.getName());
            }
            if (arrayList.size() != 0) {
                Object object2 = ((Object)arrayList).toString();
                object2 = ((String)object2).substring(1, ((String)object2).length() - 1);
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getFormattedString("in_igCanOnlyDeleteUncarriedItems", object2), "PCGen", MessageType.ERROR);
                return;
            }
            if ((equipment = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, equipment.getKeyName())) != null) {
                if (JOptionPane.showConfirmDialog(null, PropertyFactory.getFormattedString("in_igConfirmDelete", equipment.getName()), "PCGen", 0) == 1) {
                    return;
                }
                Globals.getContext().ref.forget(equipment);
                this.updateAvailableModel();
            }
        }
    }

    private void editChargesButtonClicked() {
        Object object = this.getCurrentSelectedTableItem();
        if (!(object instanceof Equipment)) {
            return;
        }
        Equipment equipment = (Equipment)object;
        int n = equipment.getMinCharges();
        int n2 = equipment.getMaxCharges();
        if (n < 0) {
            ShowMessageDelegate.showMessageDialog("This item cannot hold charges.", "PCGen", MessageType.ERROR);
            return;
        }
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object2 = inputInterface.showInputDialog(null, "Enter Number of Charges (" + Integer.toString(n) + "-" + Integer.toString(n2) + ")", "PCGen", MessageType.INFORMATION, null, Integer.toString(equipment.getRemainingCharges()));
        if (object2 == null) {
            return;
        }
        try {
            String string = ((String)object2).trim();
            int n3 = Integer.parseInt(string);
            if (n3 < n || n3 > n2) {
                ShowMessageDelegate.showMessageDialog("Value out of range", "PCGen", MessageType.ERROR);
                return;
            }
            if (equipment.getRemainingCharges() != n3) {
                Equipment equipment2;
                Equipment equipment3 = equipment.clone();
                equipment3.setRemainingCharges(n3);
                equipment3.setQty(1.0);
                equipment.setQty((double)equipment.getQty().floatValue() - 1.0);
                this.pc.updateEquipSetItem(equipment, equipment3);
                if (equipment.getQty().floatValue() <= 0.0f) {
                    this.pc.removeEquipment(equipment);
                }
                if ((equipment2 = this.pc.getEquipmentNamed(equipment3.getName())) == null) {
                    this.pc.addEquipment(equipment3);
                    this.updateEqInfo(equipment3);
                } else {
                    equipment2.setQty((double)equipment2.getQty().floatValue() + 1.0);
                    this.updateEqInfo(equipment2);
                }
                this.updateSelectedModel();
                this.pc.setDirty(true);
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.setMessageAreaTextWithoutSaving("Equipment character is not proficient with are in Red.");
        this.refresh();
        this.setDividerLocs();
    }

    private void setDividerLocs() {
        int n = this.splitPane.getDividerLocation();
        int n2 = this.bsplit.getDividerLocation();
        int n3 = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int n4;
            TableColumn tableColumn;
            int n5;
            this.hasBeenSized = true;
            n = SettingsHandler.getPCGenOption("InfoGear.splitPane", (int)(this.getSize().getWidth() * 6.0 / 10.0));
            n2 = SettingsHandler.getPCGenOption("InfoGear.bsplit", (int)(this.getSize().getHeight() - 180.0));
            n3 = SettingsHandler.getPCGenOption("InfoGear.asplit", (int)(this.getSize().getWidth() - 295.0));
            for (n5 = 0; n5 < this.selectedTable.getColumnCount(); ++n5) {
                tableColumn = this.selectedTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("InvSel", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "InvSel", n5));
            }
            for (n5 = 0; n5 < this.availableTable.getColumnCount(); ++n5) {
                tableColumn = this.availableTable.getColumnModel().getColumn(n5);
                n4 = Globals.getCustColumnWidth("InvAva", n5);
                if (n4 != 0) {
                    tableColumn.setPreferredWidth(n4);
                }
                tableColumn.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "InvAva", n5));
            }
        }
        if (n > 0) {
            this.splitPane.setDividerLocation(n);
            SettingsHandler.setPCGenOption("InfoGear.splitPane", n);
        }
        if (n2 > 0) {
            this.bsplit.setDividerLocation(n2);
            SettingsHandler.setPCGenOption("InfoGear.bsplit", n2);
        }
        if (n3 > 0) {
            this.asplit.setDividerLocation(n3);
            SettingsHandler.setPCGenOption("InfoGear.asplit", n3);
        }
    }

    private void hookupPopupMenu(JTreeTable jTreeTable) {
        jTreeTable.addMouseListener(new GearPopupListener(jTreeTable, new GearPopupMenu(jTreeTable)));
    }

    private void initActionListeners() {
        this.gold.setInputVerifier(new InputVerifier(){

            public boolean shouldYieldFocus(JComponent jComponent) {
                boolean bl = this.verify(jComponent);
                if (InfoGear.this.gold.getText().length() > 0) {
                    if (InfoGear.this.pc != null) {
                        InfoGear.this.pc.setDirty(true);
                        InfoGear.this.pc.setGold(InfoGear.this.gold.getText());
                    }
                    return bl;
                }
                if (InfoGear.this.pc != null) {
                    InfoGear.this.gold.setText(InfoGear.this.pc.getGold().toString());
                }
                return bl;
            }

            public boolean verify(JComponent jComponent) {
                return true;
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                InfoGear.this.formComponentShown();
            }
        });
        this.asplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                InfoGear.this.saveDividerLocs();
            }
        });
        this.bsplit.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                InfoGear.this.saveDividerLocs();
            }
        });
        this.splitPane.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                InfoGear.this.saveDividerLocs();
            }
        });
        this.removeButton.addActionListener(this.sellOneListener);
        this.addButton.addActionListener(this.buyOneListener);
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoGear.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoGear.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.textAvailableQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setAvailableQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setAvailableQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setAvailableQFilter();
            }
        });
        this.clearAvailableQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoGear.this.clearAvailableQFilter();
            }
        });
        this.textSelectedQFilter.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setSelectedQFilter();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setSelectedQFilter();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                InfoGear.this.setSelectedQFilter();
            }
        });
        this.clearSelectedQFilterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                InfoGear.this.clearSelectedQFilter();
            }
        });
        this.costBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoGear.this.pc != null) {
                    InfoGear.this.pc.setDirty(true);
                    InfoGear.this.pc.setIgnoreCost(InfoGear.this.costBox.isSelected());
                }
            }
        });
        this.allowDebtBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoGear.this.pc != null) {
                    InfoGear.this.pc.setDirty(true);
                    InfoGear.this.pc.setAllowDebt(InfoGear.this.allowDebtBox.isSelected());
                }
            }
        });
        this.autoResize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoGear.this.pc != null) {
                    InfoGear.this.pc.setDirty(true);
                    InfoGear.this.pc.setAutoResize(InfoGear.this.autoResize.isSelected());
                }
            }
        });
        this.autoSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (InfoGear.this.pc != null) {
                    InfoGear.this.pc.setDirty(true);
                    InfoGear.this.pc.setAutoSortGear(InfoGear.this.autoSort.isSelected());
                }
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    public void saveDividerLocs() {
        if (!this.hasBeenSized) {
            return;
        }
        int n = this.splitPane.getDividerLocation();
        if (n > 0) {
            SettingsHandler.setPCGenOption("InfoGear.splitPane", n);
        }
        if ((n = this.asplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoGear.asplit", n);
        }
        if ((n = this.bsplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoGear.bsplit", n);
        }
    }

    private void initComponents() {
        Object object;
        int pObjectNodeArray5;
        this.readyForRefresh = true;
        int n2 = SettingsHandler.getGearTab_AvailableListMode();
        if (n2 >= 0 && n2 <= 4) {
            viewMode = n2;
        }
        SettingsHandler.setGearTab_AvailableListMode(viewMode);
        n2 = SettingsHandler.getGearTab_SelectedListMode();
        if (n2 >= 0 && n2 <= 4) {
            viewSelectMode = n2;
        }
        SettingsHandler.setGearTab_SelectedListMode(viewSelectMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeSubtypeName"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_allTypes"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        Utility.setDescription(this.viewComboBox, "You can change how the Equipment in the Tables are listed.");
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_typeSubtypeName"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_typeName"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_allTypes"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_sourceName"));
        Utility.setDescription(this.viewSelectComboBox, "You can change how the Equipment in the Tables are listed.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        boolean bl = Equipment.getEquipmentTypes().contains("Custom");
        typeSubtypeRoot = new PObjectNode();
        typeRoot = new PObjectNode();
        allTypeRoot = new PObjectNode();
        sourceRoot = new PObjectNode();
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList<String> arrayList3 = new ArrayList<String>();
        if (bl) {
            arrayList.add("Custom");
            arrayList2.add("Custom");
            arrayList3.add("Custom Equipment");
        }
        for (Equipment pObjectNodeArray2 : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
            List<Type> i = pObjectNodeArray2.getTrueTypeList(true);
            if (i.isEmpty()) continue;
            String n = i.get(0).toString();
            if (!arrayList.contains(n)) {
                arrayList.add(n);
            }
            if (!arrayList2.contains(n)) {
                arrayList2.add(n);
            }
            for (int i2 = 1; i2 < i.size(); ++i2) {
                n = i.get(i2).toString();
                if (arrayList2.contains(n)) continue;
                arrayList2.add(n);
            }
            String i3 = SourceFormat.getFormattedString(pObjectNodeArray2, SourceFormat.LONG, false);
            if (i3.length() == 0 || arrayList3.contains(i3)) continue;
            arrayList3.add(i3);
        }
        Collections.sort(arrayList);
        Collections.sort(arrayList2);
        PObjectNode[] pObjectNodeArray3 = new PObjectNode[arrayList.size()];
        PObjectNode[] pObjectNodeArray = new PObjectNode[arrayList.size()];
        for (int pObjectNodeArray4 = 0; pObjectNodeArray4 < arrayList.size(); ++pObjectNodeArray4) {
            pObjectNodeArray3[pObjectNodeArray4] = new PObjectNode();
            pObjectNodeArray3[pObjectNodeArray4].setItem(arrayList.get(pObjectNodeArray4));
            pObjectNodeArray3[pObjectNodeArray4].setParent((PObjectNode)typeSubtypeRoot);
            pObjectNodeArray[pObjectNodeArray4] = new PObjectNode();
            pObjectNodeArray[pObjectNodeArray4].setItem(arrayList.get(pObjectNodeArray4));
            pObjectNodeArray[pObjectNodeArray4].setParent((PObjectNode)typeRoot);
        }
        ((PObjectNode)typeSubtypeRoot).setChildren(pObjectNodeArray3);
        ((PObjectNode)typeRoot).setChildren(pObjectNodeArray);
        Collections.sort(arrayList3);
        PObjectNode[] pObjectNodeArray2 = new PObjectNode[arrayList3.size()];
        for (pObjectNodeArray5 = 0; pObjectNodeArray5 < arrayList3.size(); ++pObjectNodeArray5) {
            pObjectNodeArray2[pObjectNodeArray5] = new PObjectNode();
            pObjectNodeArray2[pObjectNodeArray5].setItem(((String)arrayList3.get(pObjectNodeArray5)).toString());
            pObjectNodeArray2[pObjectNodeArray5].setParent((PObjectNode)sourceRoot);
        }
        ((PObjectNode)sourceRoot).setChildren(pObjectNodeArray2);
        for (pObjectNodeArray5 = 0; pObjectNodeArray5 < pObjectNodeArray3.length; ++pObjectNodeArray5) {
            arrayList.clear();
            for (Equipment equipment : Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class)) {
                if (!equipment.isType((String)(object = pObjectNodeArray3[pObjectNodeArray5].toString()))) continue;
                for (Type type : equipment.getTrueTypeList(true)) {
                    String string = type.toString();
                    if (string.equals(object) || arrayList.contains(string)) continue;
                    arrayList.add(string);
                }
            }
            Collections.sort(arrayList);
            for (String string : arrayList) {
                object = new PObjectNode();
                ((PObjectNode)object).setParent(pObjectNodeArray3[pObjectNodeArray5]);
                pObjectNodeArray3[pObjectNodeArray5].addChild((PObjectNode)object);
                ((PObjectNode)object).setItem(string);
            }
        }
        PObjectNode[] pObjectNodeArray4 = new PObjectNode[arrayList2.size()];
        for (int jPanel = 0; jPanel < arrayList2.size(); ++jPanel) {
            pObjectNodeArray4[jPanel] = new PObjectNode();
            pObjectNodeArray4[jPanel].setItem(arrayList2.get(jPanel));
            pObjectNodeArray4[jPanel].setParent((PObjectNode)allTypeRoot);
        }
        ((PObjectNode)allTypeRoot).setChildren(pObjectNodeArray4);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.splitPane = new FlippingSplitPane(splitOrientation, jPanel, jPanel2);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        jPanel.setLayout(new BorderLayout());
        object = new JLabel("Available: ");
        jPanel.add((Component)InfoTabUtils.createFilterPane((JLabel)object, this.viewComboBox, this.lblAvailableQFilter, this.textAvailableQFilter, this.clearAvailableQFilterButton), "North");
        Object object2 = new JScrollPane(this.availableTable, 22, 30);
        jPanel.add((Component)object2, "Center");
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        jPanel.add((Component)this.buildModPanel(this.addButton, "Click to add the selected item from the Available list of items"), "South");
        JButton jButton = new JButton();
        ((JScrollPane)object2).setCorner("UPPER_RIGHT_CORNER", jButton);
        jButton.setText("^");
        new TableColumnManager(this.availableTable, jButton, this.availableModel);
        int n = this.availableTable.convertColumnIndexToView(1);
        if (n > -1) {
            this.availableTable.setColAlign(n, 4);
        }
        jPanel2.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel("Selected: ");
        jPanel2.add((Component)InfoTabUtils.createFilterPane(jLabel, this.viewSelectComboBox, this.lblSelectedQFilter, this.textSelectedQFilter, this.clearSelectedQFilterButton), "North");
        object2 = new JScrollPane(this.selectedTable, 22, 30);
        jPanel2.add((Component)object2, "Center");
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        jPanel2.add((Component)this.buildDelPanel(this.removeButton, PropertyFactory.getString("in_igRemoveHelpMsg")), "South");
        JButton jButton2 = new JButton();
        ((JScrollPane)object2).setCorner("UPPER_RIGHT_CORNER", jButton2);
        jButton2.setText("^");
        new TableColumnManager(this.selectedTable, jButton2, this.selectedModel);
        jPanel2.add((Component)this.buildRemoveItemPanel(), "South");
        TitledBorder titledBorder = BorderFactory.createTitledBorder(PropertyFactory.getString("in_igEqInfo"));
        titledBorder.setTitleJustification(2);
        this.eqScroll.setBorder(titledBorder);
        this.infoLabel.setBackground(jPanel2.getBackground());
        this.eqScroll.setViewportView(this.infoLabel);
        Utility.setDescription(this.eqScroll, PropertyFactory.getString("in_igReqNotMet"));
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.south.setLayout(gridBagLayout);
        this.south.setMinimumSize(new Dimension(280, 66));
        this.totalValue.setEditable(false);
        this.totalValue.setColumns(8);
        this.totalValue.setBorder(null);
        this.totalValue.setOpaque(false);
        this.gold.setColumns(9);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BorderLayout());
        jPanel4.add((Component)this.goldLabel, "West");
        jPanel4.add((Component)this.gold, "East");
        jPanel3.add((Component)jPanel4, "East");
        Utility.buildConstraints(gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        this.south.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout(new BorderLayout());
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BorderLayout());
        jPanel6.add((Component)this.valueLabel, "West");
        jPanel6.add((Component)this.totalValue, "East");
        jPanel5.add((Component)jPanel6, "East");
        Utility.buildConstraints(gridBagConstraints, 0, 1, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel5, gridBagConstraints);
        this.south.add(jPanel5);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout(new BorderLayout());
        jPanel7.add((Component)this.allowDebtBox, "Before");
        jPanel7.add((Component)this.costBox, "After");
        jPanel7.add((Component)this.autoResize, "Last");
        Utility.buildConstraints(gridBagConstraints, 0, 2, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(jPanel7, gridBagConstraints);
        this.south.add(jPanel7);
        this.costBox.setSelected(SettingsHandler.getGearTab_IgnoreCost());
        this.autoResize.setSelected(SettingsHandler.getGearTab_AutoResize());
        this.autoResize.setEnabled(SettingsHandler.getGame().getAllowAutoResize());
        this.allowDebtBox.setSelected(SettingsHandler.getGearTab_AllowDebt());
        Integer[] integerArray = new Integer[5];
        for (int i = 0; i < 5; ++i) {
            integerArray[i] = i * 50;
        }
        this.cmbBuyPercent.setEditable(true);
        this.cmbSellPercent.setEditable(true);
        this.cmbBuyPercent.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.cmbSellPercent.setModel(new DefaultComboBoxModel<Integer>(integerArray));
        this.cmbBuyPercent.setSelectedItem(SettingsHandler.getGearTab_BuyRate());
        this.cmbSellPercent.setSelectedItem(SettingsHandler.getGearTab_SellRate());
        this.cmbBuyPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    int n;
                    Object object = InfoGear.this.cmbBuyPercent.getSelectedItem();
                    if (object instanceof Integer) {
                        n = (Integer)object;
                    } else {
                        try {
                            n = Integer.parseInt((String)object);
                        }
                        catch (Exception exception) {
                            n = -1;
                        }
                    }
                    if (n < 0) {
                        n = SettingsHandler.getGearTab_BuyRate();
                        InfoGear.this.cmbBuyPercent.setSelectedItem(n);
                    }
                    SettingsHandler.setGearTab_BuyRate(n);
                }
            }
        });
        this.cmbSellPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (actionEvent.getActionCommand().equals("comboBoxChanged")) {
                    int n;
                    Object object = InfoGear.this.cmbSellPercent.getSelectedItem();
                    if (object instanceof Integer) {
                        n = (Integer)object;
                    } else {
                        try {
                            n = Integer.parseInt((String)object);
                        }
                        catch (Exception exception) {
                            n = -1;
                        }
                    }
                    if (n < 0) {
                        n = SettingsHandler.getGearTab_SellRate();
                        InfoGear.this.cmbSellPercent.setSelectedItem(n);
                    }
                    SettingsHandler.setGearTab_SellRate(n);
                }
            }
        });
        this.pnlBuy.setLayout(new BorderLayout());
        this.pnlSell.setLayout(new BorderLayout());
        this.pnlBuy.add((Component)this.lblBuyRate, "West");
        this.pnlBuy.add((Component)this.cmbBuyPercent, "East");
        this.pnlSell.add((Component)this.lblSellRate, "West");
        this.pnlSell.add((Component)this.cmbSellPercent, "East");
        Utility.buildConstraints(gridBagConstraints, 0, 3, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.pnlBuy, gridBagConstraints);
        this.south.add((Component)this.pnlBuy, gridBagConstraints);
        Utility.buildConstraints(gridBagConstraints, 0, 4, 1, 1, 0.0, 0.0);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.pnlSell, gridBagConstraints);
        this.south.add(this.pnlSell);
        this.asplit = new FlippingSplitPane(1, this.eqScroll, this.south);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout(new BorderLayout());
        jPanel8.setMinimumSize(new Dimension(200, 120));
        jPanel8.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, jPanel8);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                InfoGear.this.refresh();
            }
        });
        this.setDividerLocs();
    }

    private void openCustomizer(Equipment equipment) {
        if (equipment != null) {
            if (this.eqFrame == null) {
                this.eqFrame = new EQFrame(this.pc);
            }
            if (this.eqFrame.setEquipment(equipment)) {
                this.eqFrame.setVisible(true);
                this.eqFrame.toFront();
            }
        }
    }

    private double removeSpecifiedEquipment(Equipment equipment, double d) {
        double d2 = d;
        if (d2 < 0.0) {
            String string = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_igRemoveEnterQuantity"), "PCGen", 3);
            if (string != null) {
                try {
                    d2 = Float.parseFloat(string.trim());
                }
                catch (Exception exception) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igInvalidNumber"), "PCGen", MessageType.ERROR);
                    return 0.0;
                }
            } else {
                return 0.0;
            }
        }
        if (equipment.getChildCount() == 0) {
            if (!equipment.acceptsChildren() || CoreUtility.doublesEqual(d2 % 1.0, 0.0)) {
                return this.adjustBelongings(equipment, -d2);
            }
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igRemoveNoIntegerMsg"), "PCGen", MessageType.ERROR);
            return 0.0;
        }
        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igRemoveNoRemoveFilledContainer"), "PCGen", MessageType.ERROR);
        return 0.0;
    }

    private void resortSelected(int n, boolean bl) {
        ResortComparator resortComparator = new ResortComparator(n, bl, this.pc);
        int n2 = 1;
        List<Equipment> list = this.pc.getEquipmentMasterList();
        Collections.sort(list, resortComparator);
        for (Equipment equipment : list) {
            if (equipment.getOutputIndex() < 0) continue;
            equipment.setOutputIndex(n2++);
            if (!equipment.isAutomatic()) continue;
            this.pc.cacheOutputIndex(equipment);
        }
        this.selectedModel.updateTree();
        this.selectedTable.updateUI();
        this.pc.setDirty(true);
    }

    private void clearAvailableQFilter() {
        this.availableModel.clearQFilter();
        if (saveAvailableViewMode != null) {
            viewMode = saveAvailableViewMode;
            saveAvailableViewMode = null;
        }
        this.textAvailableQFilter.setText("");
        this.availableModel.resetModel(InfoGear.viewMode, true);
        this.clearAvailableQFilterButton.setEnabled(false);
        this.viewComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void clearSelectedQFilter() {
        this.selectedModel.clearQFilter();
        if (saveSelectedViewMode != null) {
            viewSelectMode = saveSelectedViewMode;
            saveSelectedViewMode = null;
        }
        this.textSelectedQFilter.setText("");
        this.selectedModel.resetModel(InfoGear.viewSelectMode, false);
        this.clearSelectedQFilterButton.setEnabled(false);
        this.viewSelectComboBox.setEnabled(true);
        this.forceRefresh();
    }

    private void setAvailableQFilter() {
        String string = this.textAvailableQFilter.getText();
        if (string.length() == 0) {
            this.clearAvailableQFilter();
            return;
        }
        this.availableModel.setQFilter(string);
        if (saveAvailableViewMode == null) {
            saveAvailableViewMode = viewMode;
        }
        viewMode = 2;
        this.availableModel.resetModel(InfoGear.viewMode, true);
        this.clearAvailableQFilterButton.setEnabled(true);
        this.viewComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void setSelectedQFilter() {
        String string = this.textSelectedQFilter.getText();
        if (string.length() == 0) {
            this.clearSelectedQFilter();
            return;
        }
        this.selectedModel.setQFilter(string);
        if (saveSelectedViewMode == null) {
            saveSelectedViewMode = viewSelectMode;
        }
        viewSelectMode = 2;
        this.selectedModel.resetModel(InfoGear.viewMode, false);
        this.clearSelectedQFilterButton.setEnabled(true);
        this.viewSelectComboBox.setEnabled(false);
        this.forceRefresh();
    }

    private void sellSpecifiedEquipmentRate(Equipment equipment) {
        this.sellSpecifiedEquipmentRate(equipment, equipment.qty());
    }

    private void sellSpecifiedEquipmentRate(Equipment equipment, double d) {
        String string = this.cmbSellPercent.getSelectedItem().toString();
        InputInterface inputInterface = InputFactory.getInputInstance();
        Object object = inputInterface.showInputDialog(this, PropertyFactory.getString("in_igSellPricePercMsg"), PropertyFactory.getString("Sell at Percent"), MessageType.QUESTION, null, string);
        if (object != null) {
            String string2 = object.toString().trim();
            try {
                int n = Integer.parseInt(string2);
                this.sellSpecifiedEquipmentRate(equipment, d, n);
            }
            catch (NumberFormatException numberFormatException) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_igSellPricePercNoIntegerMsg"), PropertyFactory.getString("in_igSellPricePercNoIntegerTitle"), MessageType.ERROR);
            }
        }
    }

    private void sellSpecifiedEquipmentRate(Equipment equipment, double d, int n) {
        this.adjustGold(equipment, this.removeSpecifiedEquipment(equipment, d), 0, n);
    }

    private void updateAvailableModel() {
        try {
            List<String> list = this.availableTable.getExpandedPaths();
            this.createAvailableModel();
            this.availableTable.updateUI();
            this.availableTable.expandPathList(list);
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void updateEqInfo(Equipment equipment) {
        this.updateTotalValue();
        if (equipment.hasVFeats()) {
            this.pc.setVirtualAbilitiesStable(AbilityCategory.FEAT, false);
        }
    }

    private void updateSelectedModel() {
        List<String> list = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(list);
    }

    private void updateTotalValue() {
        this.totalValue.setText(BigDecimalHelper.trimZeros(this.pc.totalValue()) + " " + Globals.getCurrencyDisplay());
    }

    private void viewComboBoxActionPerformed() {
        int n = this.viewComboBox.getSelectedIndex();
        if (n != viewMode) {
            viewMode = n;
            SettingsHandler.setGearTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int n = this.viewSelectComboBox.getSelectedIndex();
        if (n != viewSelectMode) {
            viewSelectMode = n;
            SettingsHandler.setGearTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    private class SellRateGearActionListener
    extends SelectedGearActionListener {
        SellRateGearActionListener(int n) {
            super(n);
        }

        protected void updateEquipment(Equipment equipment, int n) {
            if (n < -1) {
                InfoGear.this.sellSpecifiedEquipmentRate(equipment);
            } else {
                InfoGear.this.sellSpecifiedEquipmentRate(equipment, n);
            }
        }
    }

    private class SellGearActionListener
    extends SelectedGearActionListener {
        SellGearActionListener(int n) {
            super(n);
        }

        protected void updateEquipment(Equipment equipment, int n) {
            if (n < -1) {
                InfoGear.this.sellSpecifiedEquipment(equipment, equipment.qty());
            } else {
                InfoGear.this.sellSpecifiedEquipment(equipment, n);
            }
        }
    }

    private static final class QuantityEditor
    extends JTextField
    implements TableCellEditor {
        private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
        private transient String d_originalValue = "";

        private QuantityEditor() {
            this.setAlignmentX(1.0f);
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            try {
                return new Float(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return new Float(this.d_originalValue);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object instanceof Number && (float)((Number)object).intValue() == ((Number)object).floatValue()) {
                this.setText(Integer.toString(((Number)object).intValue()));
            } else if (object != null) {
                this.setText(object.toString());
            } else {
                this.setText("0");
            }
            this.d_originalValue = this.getText();
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            this.setAlignmentX(1.0f);
            this.selectAll();
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setText(this.d_originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingCanceled(changeEvent);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingStopped(changeEvent);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class EquipmentModel
    extends AbstractTreeTableModel
    implements TableColumnManagerModel {
        private int currentMode;
        private static final int MODEL_TYPE_AVAIL = 0;
        private static final int MODEL_TYPE_SELECTED = 1;
        private String[] names;
        private int[] widths;
        private int modelType;
        private List<Boolean> displayList;

        private EquipmentModel(int n, boolean bl) {
            super(null);
            this.currentMode = 0;
            this.names = new String[]{PropertyFactory.getString("in_igEqModelColItem"), PropertyFactory.getString("in_igEqModelColCost"), PropertyFactory.getString("in_igEqModelColWeight"), PropertyFactory.getString("in_igEqModelColQty"), PropertyFactory.getString("in_igEqModelColOrder"), PropertyFactory.getString("in_igEqModelColSource")};
            this.widths = new int[]{100, 20, 20, 20, 20, 100};
            this.modelType = 0;
            if (!bl) {
                this.modelType = 1;
            }
            this.resetModel(n, bl);
            int n2 = 1;
            this.displayList = new ArrayList<Boolean>();
            this.displayList.add(Boolean.TRUE);
            this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
            if (bl) {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
            } else {
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], true));
                this.displayList.add(this.getColumnViewOption(this.modelType + "." + this.names[n2++], false));
            }
        }

        @Override
        public boolean isCellEditable(Object object, int n) {
            return n == 0 || this.modelType == 1 && ((PObjectNode)object).getItem() instanceof Equipment && (n == 3 || n == 4);
        }

        @Override
        public Class<?> getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return TreeTableModel.class;
                }
                case 1: {
                    return BigDecimal.class;
                }
                case 2: {
                    return Float.class;
                }
                case 3: {
                    return Float.class;
                }
                case 5: {
                    return String.class;
                }
                case 4: {
                    return Integer.class;
                }
            }
            Logging.errorPrint("In InfoGear.EquipmentModel.getColumnClass the column " + n + " is not supported.");
            return String.class;
        }

        @Override
        public int getColumnCount() {
            return this.names.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.names[n];
        }

        @Override
        public Object getRoot() {
            return super.getRoot();
        }

        @Override
        public Object getValueAt(Object object, int n) {
            PObjectNode pObjectNode = (PObjectNode)object;
            Object object2 = null;
            Equipment equipment = null;
            Object object3 = pObjectNode.getItem();
            if (object3 instanceof Equipment) {
                equipment = (Equipment)object3;
            }
            switch (n) {
                case 0: {
                    object2 = pObjectNode.toString();
                    break;
                }
                case 1: {
                    if (equipment == null) break;
                    object2 = equipment.getCost(InfoGear.this.pc);
                    break;
                }
                case 2: {
                    if (equipment == null) break;
                    object2 = equipment.getWeight(InfoGear.this.pc);
                    break;
                }
                case 3: {
                    if (equipment == null) break;
                    object2 = new Float(equipment.qty());
                    break;
                }
                case 4: {
                    if (equipment == null) break;
                    object2 = equipment.getOutputIndex();
                    if (!equipment.isAutomatic()) break;
                    object2 = InfoGear.this.pc.getCachedOutputIndex(equipment.getKeyName());
                    break;
                }
                case 5: {
                    object2 = pObjectNode.getSource().toString();
                    break;
                }
                case -1: {
                    object2 = pObjectNode.getItem();
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.getValueAt the column " + n + " is not supported.");
                }
            }
            return object2;
        }

        private void setRoot(PObjectNode pObjectNode) {
            super.setRoot(pObjectNode);
        }

        @Override
        public void setValueAt(Object object, Object object2, int n) {
            if (InfoGear.this.pc == null) {
                return;
            }
            if (this.modelType != 1) {
                return;
            }
            Object object3 = ((PObjectNode)object2).getItem();
            if (!(object3 instanceof Equipment)) {
                return;
            }
            Equipment equipment = (Equipment)object3;
            if (this.getBaseEquipment(equipment) == null) {
                return;
            }
            switch (n) {
                case 3: {
                    this.setColumnQty(equipment, object);
                    break;
                }
                case 4: {
                    this.setColumnIndex(equipment, object);
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.setValueAt the column " + n + " is not supported.");
                }
            }
        }

        private void setColumnQty(Equipment equipment, Object object) {
            double d = (double)((Float)object).floatValue() - equipment.qty();
            if (d > 0.0) {
                InfoGear.this.buySpecifiedEquipment(equipment, d);
            } else if (d < 0.0) {
                InfoGear.this.sellSpecifiedEquipment(equipment, -d);
            }
        }

        private void setColumnIndex(Equipment equipment, Object object) {
            int n = (Integer)object;
            int n2 = 1;
            if (n == 1000) {
                n = InfoGear.this.getHighestOutputIndex() + 1;
            } else if (n == 0) {
                n = 1;
                n2 = 2;
            }
            equipment.setOutputIndex(n);
            for (Equipment equipment2 : InfoGear.this.pc.getEquipmentMasterListInOutputOrder()) {
                if (n2 == n) {
                    ++n2;
                }
                if (equipment2.getOutputIndex() <= -1 || equipment2 == equipment) continue;
                equipment2.setOutputIndex(n2++);
                if (!equipment2.isAutomatic()) continue;
                InfoGear.this.pc.cacheOutputIndex(equipment2);
            }
            InfoGear.this.selectedModel.updateTree();
            InfoGear.this.selectedTable.updateUI();
            if (equipment.isAutomatic()) {
                InfoGear.this.pc.cacheOutputIndex(equipment);
            }
            InfoGear.this.pc.setDirty(true);
        }

        private Equipment getBaseEquipment(Equipment equipment) {
            String string = equipment.getKeyName();
            Equipment equipment2 = Globals.getContext().ref.silentlyGetConstructedCDOMObject(Equipment.class, string);
            if (equipment2 == null) {
                equipment2 = InfoGear.this.pc.getEquipmentNamed(string);
            }
            return equipment2;
        }

        private void setValueForItemInNodes(PObjectNode pObjectNode, Equipment equipment, double d, int n) {
            block7: {
                block6: {
                    if (pObjectNode == null) {
                        pObjectNode = (PObjectNode)super.getRoot();
                    }
                    Object object = pObjectNode.getItem();
                    if (pObjectNode.getChildCount() != 0 || object == null || !(object instanceof Equipment) || !object.equals(equipment)) break block6;
                    Equipment equipment2 = (Equipment)object;
                    switch (n) {
                        case 3: {
                            equipment2.setQty(new Float(d));
                            if ((double)equipment2.getCarried().floatValue() > d) {
                                equipment2.setNumberCarried(new Float(d));
                                break;
                            }
                            break block7;
                        }
                        default: {
                            Logging.errorPrint("In InfoGear.EquipmentModel.setValueForItemInNodes the column " + n + " is not supported.");
                            break;
                        }
                    }
                    break block7;
                }
                for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                    this.setValueForItemInNodes(pObjectNode.getChild(i), equipment, d, n);
                }
            }
        }

        private void addItemToModel(Equipment equipment, boolean bl) {
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (equipment == null || !this.shouldDisplayThis(equipment)) {
                return;
            }
            switch (this.currentMode) {
                case 0: {
                    this.addChildTypeSubtypeName(equipment, pObjectNode, bl);
                    break;
                }
                case 1: {
                    this.addChildTypeName(equipment, pObjectNode, bl);
                    break;
                }
                case 2: {
                    this.addChildName(equipment, pObjectNode, bl);
                    break;
                }
                case 3: {
                    this.addChildAllTypes(equipment, pObjectNode, bl);
                    break;
                }
                case 4: {
                    this.addChildSourceName(equipment, pObjectNode, bl);
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.addItemToModel (second switch) the mode " + this.currentMode + " is not supported.");
                }
            }
        }

        private void addChildTypeSubtypeName(Equipment equipment, PObjectNode pObjectNode, boolean bl) {
            Cloneable cloneable;
            if (bl) {
                if (equipment.isType("Custom")) {
                    this.addChild("Custom", typeSubtypeRoot, true);
                }
                String string = equipment.typeIndex(0);
                this.addChild(string, typeSubtypeRoot, true);
                cloneable = (PObjectNode)typeSubtypeRoot;
                for (String string2 : equipment.typeList()) {
                    for (int i = 0; i < ((PObjectNode)cloneable).getChildCount(); ++i) {
                        String string3 = ((PObjectNode)cloneable).getChild(i).toString();
                        if (((PObjectNode)cloneable).getChild(i).getItem() instanceof PObject || !equipment.isType(string3) || string2.equals(string3)) continue;
                        this.addChild(string2, ((PObjectNode)cloneable).getChild(i), true);
                    }
                }
            }
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                if (!equipment.isType(pObjectNode.getChild(i).toString())) continue;
                if (equipment.typeList().size() == 1) {
                    cloneable = new ArrayList(1);
                    cloneable.add(pObjectNode.getChild(i));
                } else {
                    cloneable = pObjectNode.getChild(i).getChildren();
                }
                for (int j = 0; cloneable != null && j < cloneable.size(); ++j) {
                    if (((PObjectNode)cloneable.get(j)).getItem() instanceof PObject || !equipment.isType(((PObjectNode)cloneable.get(j)).toString())) continue;
                    this.addChild(equipment, cloneable.get(j), bl);
                }
            }
        }

        private void addChildTypeName(Equipment equipment, PObjectNode pObjectNode, boolean bl) {
            if (bl) {
                if (equipment.isType("Custom")) {
                    this.addChild("Custom", typeRoot, true);
                }
                String string = equipment.typeIndex(0);
                this.addChild(string, typeRoot, true);
            }
            int n = pObjectNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (!equipment.isType(pObjectNode.getChild(i).toString())) continue;
                this.addChild(equipment, pObjectNode.getChild(i), bl);
            }
        }

        private void addChildName(Equipment equipment, PObjectNode pObjectNode, boolean bl) {
            this.addChild(equipment, pObjectNode, bl);
        }

        private void addChildAllTypes(Equipment equipment, PObjectNode pObjectNode, boolean bl) {
            if (bl) {
                for (String string : equipment.typeList()) {
                    this.addChild(string, allTypeRoot, true);
                }
            }
            for (int i = 0; i < pObjectNode.getChildCount(); ++i) {
                if (!equipment.isType(pObjectNode.getChild(i).toString())) continue;
                this.addChild(equipment, pObjectNode.getChild(i), bl);
            }
        }

        private void addChildSourceName(Equipment equipment, PObjectNode pObjectNode, boolean bl) {
            String string = SourceFormat.getFormattedString(equipment, SourceFormat.LONG, false);
            if (bl) {
                if (equipment.isType("Custom")) {
                    this.addChild("Custom Equipment", sourceRoot, true);
                }
                this.addChild(string, sourceRoot, true);
            }
            int n = pObjectNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                if (string.length() == 0) {
                    Logging.errorPrintLocalised("in_igLogGearHasNoLongSource", equipment.getName());
                    continue;
                }
                if (!string.equals(pObjectNode.getChild(i).toString())) continue;
                this.addChild(equipment, pObjectNode.getChild(i), bl);
            }
        }

        private boolean addChild(Object object, Object object2, boolean bl) {
            PObjectNode pObjectNode = new PObjectNode();
            pObjectNode.setItem(object);
            pObjectNode.setParent((PObjectNode)object2);
            if (object instanceof Equipment) {
                Equipment equipment = (Equipment)object;
                PrereqHandler.passesAll(equipment.getPrerequisiteList(), InfoGear.this.pc, equipment);
            }
            return ((PObjectNode)object2).addChild(pObjectNode, bl);
        }

        private void removeItemFromNodes(PObjectNode pObjectNode, Object object) {
            if (pObjectNode == null) {
                pObjectNode = (PObjectNode)super.getRoot();
            }
            pObjectNode.removeItemFromNodes(object);
        }

        private void resetModel(int n, boolean bl) {
            Collection<Equipment> collection = bl ? Globals.getContext().ref.getConstructedCDOMObjects(Equipment.class) : InfoGear.this.pc.getEquipmentMasterList();
            this.currentMode = n;
            String string = this.getQFilter();
            switch (n) {
                case 0: {
                    this.setRoot(((PObjectNode)typeSubtypeRoot).clone());
                    break;
                }
                case 1: {
                    this.setRoot(((PObjectNode)typeRoot).clone());
                    break;
                }
                case 2: {
                    this.setRoot(new PObjectNode());
                    break;
                }
                case 3: {
                    this.setRoot(((PObjectNode)allTypeRoot).clone());
                    break;
                }
                case 4: {
                    this.setRoot(((PObjectNode)sourceRoot).clone());
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.resetModel the mode " + n + " is not supported.");
                }
            }
            for (Equipment equipment : collection) {
                if (string != null && equipment.getName().toLowerCase().indexOf(string) < 0 && equipment.getType().toLowerCase().indexOf(string) < 0) continue;
                this.addItemToModel(equipment, false);
            }
            PObjectNode pObjectNode = (PObjectNode)super.getRoot();
            if (pObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Equipment equipment) {
            if (this.modelType == 0) {
                return InfoGear.this.accept(InfoGear.this.pc, equipment);
            }
            return true;
        }

        @Override
        public List<String> getMColumnList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.names.length; ++i) {
                arrayList.add(this.names[i]);
            }
            return arrayList;
        }

        public List<String> getMColumnAlignList() {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 1; i < this.names.length; ++i) {
                arrayList.add(this.names[i]);
            }
            return arrayList;
        }

        @Override
        public boolean isMColumnDisplayed(int n) {
            return this.displayList.get(n);
        }

        @Override
        public void setMColumnDisplayed(int n, boolean bl) {
            this.setColumnViewOption(this.modelType + "." + this.names[n], bl);
            this.displayList.set(n, bl);
        }

        @Override
        public int getMColumnOffset() {
            return 1;
        }

        @Override
        public int getMColumnDefaultWidth(int n) {
            return SettingsHandler.getPCGenOption("InfoGear.sizecol." + this.names[n], this.widths[n]);
        }

        @Override
        public void setMColumnDefaultWidth(int n, int n2) {
            SettingsHandler.setPCGenOption("InfoGear.sizecol." + this.names[n], n2);
        }

        private boolean getColumnViewOption(String string, boolean bl) {
            return SettingsHandler.getPCGenOption("InfoGear.viewcol." + string, bl);
        }

        private void setColumnViewOption(String string, boolean bl) {
            SettingsHandler.setPCGenOption("InfoGear.viewcol." + string, bl);
        }

        @Override
        public void resetMColumn(int n, TableColumn tableColumn) {
            switch (n) {
                case 1: 
                case 2: 
                case 3: {
                    tableColumn.setCellRenderer(new JTableEx.AlignCellRenderer(0));
                    break;
                }
            }
        }
    }

    private static final class OutputOrderEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List<CellEditorListener> d_listeners = new ArrayList<CellEditorListener>();
        private transient int d_originalValue = 0;

        private OutputOrderEditor(String[] stringArray) {
            super(stringArray);
            this.setEditable(true);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutputOrderEditor.this.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1000;
                }
                case 2: {
                    return -1;
                }
            }
            return Integer.valueOf((String)this.getSelectedItem());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            if (object == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (object instanceof Integer) {
                int n3 = (Integer)object;
                if (n3 == -1) {
                    this.setSelectedItem("Hidden");
                } else {
                    this.setSelectedItem(String.valueOf(n3));
                }
            } else {
                this.setSelectedItem("Hidden");
            }
            jTable.setRowSelectionInterval(n, n);
            jTable.setColumnSelectionInterval(n2, n2);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingCanceled(changeEvent);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent changeEvent = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                this.d_listeners.get(i).editingStopped(changeEvent);
            }
        }
    }

    private class GearPopupListener
    extends MouseAdapter {
        private GearPopupMenu menu;
        private JTree tree;

        private GearPopupListener(JTreeTable jTreeTable, GearPopupMenu gearPopupMenu) {
            this.tree = jTreeTable.getTree();
            this.menu = gearPopupMenu;
            KeyListener keyListener = new KeyListener(){

                public void keyTyped(KeyEvent keyEvent) {
                    InfoGear.this.dispatchEvent(keyEvent);
                }

                public void keyPressed(KeyEvent keyEvent) {
                    int n = keyEvent.getKeyCode();
                    if (n != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
                        for (int i = 0; i < GearPopupListener.this.menu.getComponentCount(); ++i) {
                            KeyStroke keyStroke2;
                            Component component = GearPopupListener.this.menu.getComponent(i);
                            if (!(component instanceof JMenuItem) || (keyStroke2 = ((JMenuItem)component).getAccelerator()) == null || !keyStroke.equals(keyStroke2)) continue;
                            InfoGear.this.selPath = GearPopupListener.this.tree.getSelectionPath();
                            ((JMenuItem)component).doClick(2);
                            return;
                        }
                    }
                    InfoGear.this.dispatchEvent(keyEvent);
                }

                public void keyReleased(KeyEvent keyEvent) {
                    InfoGear.this.dispatchEvent(keyEvent);
                }
            };
            jTreeTable.addKeyListener(keyListener);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                InfoGear.this.selPath = this.tree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (InfoGear.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoGear.this.selPath);
                    this.tree.getSelectionModel().resetRowSelection();
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else if (!this.tree.isPathSelected(InfoGear.this.selPath)) {
                    this.tree.setSelectionPath(InfoGear.this.selPath);
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                } else {
                    this.tree.addSelectionPath(InfoGear.this.selPath);
                    this.tree.getSelectionModel().resetRowSelection();
                    this.menu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResortComparator
    implements Comparator<Object> {
        public static final int RESORT_NAME = 0;
        public static final int RESORT_WEIGHT = 1;
        public static final boolean RESORT_ASCENDING = true;
        public static final boolean RESORT_DESCENDING = false;
        private boolean sortOrder = true;
        private int sort = 0;
        private PlayerCharacter pc;

        public ResortComparator(int n, boolean bl, PlayerCharacter playerCharacter) {
            this.sort = n;
            this.sortOrder = bl;
            this.pc = playerCharacter;
        }

        @Override
        public int compare(Object object, Object object2) {
            Equipment equipment;
            Equipment equipment2;
            if (this.sortOrder) {
                equipment2 = (Equipment)object;
                equipment = (Equipment)object2;
            } else {
                equipment2 = (Equipment)object2;
                equipment = (Equipment)object;
            }
            switch (this.sort) {
                case 1: {
                    return equipment2.getWeight(this.pc).compareTo(equipment.getWeight(this.pc));
                }
            }
            return equipment2.getName().compareToIgnoreCase(equipment.getName());
        }
    }

    private class ResortActionListener
    implements ActionListener {
        boolean sortOrder;
        int sort;

        public ResortActionListener(int n, boolean bl) {
            this.sort = n;
            this.sortOrder = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            InfoGear.this.resortSelected(this.sort, this.sortOrder);
        }
    }

    private class RemoveGearActionListener
    extends SelectedGearActionListener {
        RemoveGearActionListener(int n) {
            super(n);
        }

        protected void updateEquipment(Equipment equipment, int n) {
            if (n < -1) {
                InfoGear.this.removeSpecifiedEquipment(equipment, equipment.qty());
            } else {
                InfoGear.this.removeSpecifiedEquipment(equipment, n);
            }
        }
    }

    private class MoveItemListener
    implements ActionListener {
        int moveType;
        int pcIndex;

        public MoveItemListener(int n, int n2) {
            this.pcIndex = n;
            this.moveType = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlayerCharacter playerCharacter = Globals.getPCList().get(this.pcIndex);
            Equipment equipment = (Equipment)InfoGear.this.getCurrentSelectedTableItem();
            if (equipment == null) {
                return;
            }
            if (this.moveType == 0) {
                playerCharacter.addEquipment(equipment.clone());
                playerCharacter.setDirty(true);
                InfoGear.this.pc.removeEquipment(equipment);
                InfoGear.this.pc.setDirty(true);
            } else {
                playerCharacter.addEquipment(equipment.clone());
            }
            playerCharacter.setDirty(true);
            InfoGear.this.updateSelectedModel();
        }
    }

    private class GearPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -2320970658737297916L;

        private GearPopupMenu(JTreeTable jTreeTable) {
            if (jTreeTable == InfoGear.this.availableTable) {
                this.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy1"), 1, "shortcut EQUALS"));
                JMenu jMenu = Utility.createMenu(PropertyFactory.getString("in_igBuyQuantity"), '\u0000', PropertyFactory.getString("in_igBuyQuantity"), null, true);
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy2"), 2, null));
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy5"), 5, null));
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy10"), 10, null));
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy15"), 15, null));
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy20"), 20, null));
                jMenu.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuy50"), 50, null));
                this.add(jMenu);
                this.add(this.createBuyMenuItem(PropertyFactory.getString("in_igBuyN"), -1, "alt N"));
                this.addSeparator();
                this.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy1At"), 1, null));
                JMenu jMenu2 = Utility.createMenu(PropertyFactory.getString("in_igBuyQuantityAt"), '\u0000', PropertyFactory.getString("in_igBuyQuantityAt"), null, true);
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy2At"), 2, null));
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy5At"), 5, null));
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy10At"), 10, null));
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy15At"), 15, null));
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy20At"), 20, null));
                jMenu2.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuy50At"), 50, null));
                this.add(jMenu2);
                this.add(this.createBuyRateMenuItem(PropertyFactory.getString("in_igBuyNAt"), -1, "alt N"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_igCreateCustomItemLabel"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        InfoGear.this.customizeButtonClick();
                    }
                }, "newCustomItem", '\u0000', "alt C", PropertyFactory.getString("in_igCreateCustomItemDesc"), null, true));
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_igDeleteCustomItemLabel"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        InfoGear.this.deleteCustomButtonClick();
                    }
                }, "deleteItem", '\u0000', "DELETE", PropertyFactory.getString("in_igDeleteCustomItemDesc"), null, true));
            } else {
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove1"), 1, "shortcut MINUS"));
                JMenu jMenu = Utility.createMenu(PropertyFactory.getString("in_igRemoveQuantity"), '\u0000', PropertyFactory.getString("in_igRemoveQuantity"), null, true);
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove2"), 2, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove5"), 5, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove10"), 10, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove15"), 15, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove20"), 20, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemove50"), 50, null));
                jMenu.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemoveN"), -1, null));
                this.add(jMenu);
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_igRemoveAll"), -5, null));
                this.addSeparator();
                this.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell1"), 1, null));
                JMenu jMenu3 = Utility.createMenu(PropertyFactory.getString("in_igSellQuantity"), '\u0000', PropertyFactory.getString("in_igSellQuantity"), null, true);
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell2"), 2, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell5"), 5, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell10"), 10, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell15"), 15, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell20"), 20, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSell50"), 50, null));
                jMenu3.add(this.createSellMenuItem(PropertyFactory.getString("in_igSellN"), -1, null));
                this.add(jMenu3);
                this.add(this.createSellMenuItem(PropertyFactory.getString("in_igSellAll"), -5, null));
                this.addSeparator();
                this.add(this.createSellRateMenuItem(PropertyFactory.getString("in_igSell1At"), 1, null));
                this.add(this.createSellRateMenuItem(PropertyFactory.getString("in_igSellNAtt"), -1, null));
                this.add(this.createSellRateMenuItem(PropertyFactory.getString("in_igSellAllAt"), -5, null));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_igModChargesMenuLabel"), new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        InfoGear.this.editChargesButtonClicked();
                    }
                }, PropertyFactory.getString("in_igModChargesMenuCommand"), '\u0000', PropertyFactory.getString("in_igModChargesMenuAccelerator"), PropertyFactory.getString("in_igModChargesMenuDesc"), null, true));
                this.addSeparator();
                this.add(InfoGear.this.pcMoveMenu);
                this.add(InfoGear.this.pcCopyMenu);
                this.addSeparator();
                JMenu jMenu4 = Utility.createMenu(PropertyFactory.getString("in_igSortMenuLabel"), '\u0000', PropertyFactory.getString("in_igSortMenuDesc"), null, true);
                this.add(jMenu4);
                jMenu4.add(Utility.createMenuItem(PropertyFactory.getString("in_igSortNameAscLabel"), new ResortActionListener(0, true), PropertyFactory.getString("in_igSortCommand"), '\u0000', null, PropertyFactory.getString("in_igSortNameAscDesc"), null, true));
                jMenu4.add(Utility.createMenuItem(PropertyFactory.getString("in_igSortNameDscLabel"), new ResortActionListener(0, false), PropertyFactory.getString("in_igSortCommand"), '\u0000', null, PropertyFactory.getString("in_igSortNameDscDesc"), null, true));
                jMenu4.add(Utility.createMenuItem(PropertyFactory.getString("in_igSortWeightAscLabel"), new ResortActionListener(1, true), PropertyFactory.getString("in_igSortCommand"), '\u0000', null, PropertyFactory.getString("in_igSortWeightAscDesc"), null, true));
                jMenu4.add(Utility.createMenuItem(PropertyFactory.getString("in_igSortWeightDscLabel"), new ResortActionListener(1, false), PropertyFactory.getString("in_igSortCommand"), '\u0000', null, PropertyFactory.getString("in_igSortWeightDscDesc"), null, true));
            }
        }

        private JMenuItem createBuyMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new BuyGearActionListener(n), PropertyFactory.getFormattedString("in_igBuyMenuCommand", n), '\u0000', string2, PropertyFactory.getFormattedString("in_igBuyRateMenuDesc", n < 0 ? "n" : Integer.toString(n)), "Add16.gif", true);
        }

        private JMenuItem createBuyRateMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new BuyRateGearActionListener(n), PropertyFactory.getFormattedString("in_igBuyRateMenuCommand", n), '\u0000', string2, PropertyFactory.getFormattedString("in_igBuyRateMenuDesc", n < 0 ? "n" : Integer.toString(n)), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new RemoveGearActionListener(n), PropertyFactory.getFormattedString("in_igRemoveMenuCommand", n), '\u0000', string2, PropertyFactory.getFormattedString("in_igRemoveMenuDesc", n < 0 ? "n" : Integer.toString(n)), "Remove16.gif", true);
        }

        private JMenuItem createSellMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new SellGearActionListener(n), PropertyFactory.getFormattedString("in_igSellMenuCommand", n), '\u0000', string2, PropertyFactory.getFormattedString("in_igSellMenuDesc", n < 0 ? "n" : Integer.toString(n)), null, true);
        }

        private JMenuItem createSellRateMenuItem(String string, int n, String string2) {
            return Utility.createMenuItem(string, new SellRateGearActionListener(n), PropertyFactory.getFormattedString("in_igSellRateMenuCommand", n), '\u0000', string2, PropertyFactory.getFormattedString("in_igSellRateMenuDesc", n < 0 ? "n" : Integer.toString(n)), null, true);
        }
    }

    private class BuyRateGearActionListener
    extends AvailableGearActionListener {
        private BuyRateGearActionListener(int n) {
            super(n);
        }

        protected void updateEquipment(Equipment equipment, int n) {
            InfoGear.this.buySpecifiedEquipmentRate(equipment, n);
        }
    }

    private class BuyGearActionListener
    extends AvailableGearActionListener {
        private BuyGearActionListener(int n) {
            super(n);
        }

        protected void updateEquipment(Equipment equipment, int n) {
            InfoGear.this.buySpecifiedEquipment(equipment, n);
        }
    }

    private abstract class SelectedGearActionListener
    extends GearActionListener {
        private SelectedGearActionListener(int n) {
            super(n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = InfoGear.this.getCurrentSelectedTableItem();
            if (object != null && object instanceof Equipment) {
                this.updateEquipment((Equipment)object, this.qty);
            }
        }
    }

    private abstract class AvailableGearActionListener
    extends GearActionListener {
        private AvailableGearActionListener(int n) {
            super(n);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = InfoGear.this.getCurrentAvailableTableItem();
            if (object != null && object instanceof Equipment) {
                this.updateEquipment((Equipment)object, this.qty);
            }
        }
    }

    private static abstract class GearActionListener
    implements ActionListener {
        int qty = 0;

        private GearActionListener(int n) {
            this.qty = n;
        }

        protected abstract void updateEquipment(Equipment var1, int var2);
    }

    private class SelectedClickHandler
    implements ClickHandler {
        private SelectedClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            SwingUtilities.invokeLater(InfoGear.this.sellOneRunnable);
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }

    private class AvailableClickHandler
    implements ClickHandler {
        private AvailableClickHandler() {
        }

        public void singleClickEvent() {
        }

        public void doubleClickEvent() {
            InfoGear.this.buyOneListener.actionPerformed(null);
        }

        public boolean isSelectable(Object object) {
            return !(object instanceof String);
        }
    }
}

